/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Pattern;
import org.basex.core.Prop;
import org.basex.io.IO;
import org.basex.io.in.BufferInput;
import org.basex.io.out.BufferOutput;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.xml.sax.InputSource;

public final class IOFile
extends IO {
    private final File file;

    public IOFile(String f) {
        this(new File(f));
    }

    public IOFile(File f) {
        super(new PathList().create(f.getAbsolutePath()));
        this.file = f;
    }

    public IOFile(String dir, String n) {
        this(new File(dir, n));
    }

    public IOFile(IOFile dir, String n) {
        this(new File(dir.file, n));
    }

    public File file() {
        return this.file;
    }

    public boolean touch() {
        for (int i = 0; i < 5; ++i) {
            try {
                if (!this.file.createNewFile()) continue;
                return true;
            }
            catch (IOException ex) {
                Performance.sleep((long)i * 10L);
                Util.debug(ex);
            }
        }
        return false;
    }

    @Override
    public byte[] read() throws IOException {
        return new BufferInput(this).content();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isDir() {
        return this.file.isDirectory();
    }

    @Override
    public long timeStamp() {
        return this.file.lastModified();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public InputSource inputSource() {
        return new InputSource(this.path);
    }

    @Override
    public InputStream inputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public IO merge(String f) {
        IO io = IO.get(f);
        if (!(io instanceof IOFile) || f.contains(":") || f.startsWith("/")) {
            return io;
        }
        return new IOFile(this.dir(), f);
    }

    public boolean md() {
        return !this.file.exists() && this.file.mkdirs();
    }

    @Override
    public String dir() {
        return this.isDir() ? this.path : this.path.substring(0, this.path.lastIndexOf(47) + 1);
    }

    public IOFile[] children() {
        return this.children(".*");
    }

    public IOFile[] children(String regex) {
        File[] ch = this.file.listFiles();
        if (ch == null) {
            return new IOFile[0];
        }
        ArrayList<IOFile> io = new ArrayList<IOFile>(ch.length);
        Pattern p = Pattern.compile(regex, Prop.WIN ? 2 : 0);
        for (File f : ch) {
            if (!p.matcher(f.getName()).matches()) continue;
            io.add(new IOFile(f));
        }
        return io.toArray(new IOFile[io.size()]);
    }

    public synchronized StringList descendants() {
        StringList files = new StringList();
        File[] ch = this.file.listFiles();
        if (ch == null) {
            return files;
        }
        if (this.exists()) {
            IOFile.add(this, files, this.path().length() + 1);
        }
        return files;
    }

    private static void add(IOFile io, StringList files, int off) {
        if (io.isDir()) {
            for (IOFile f : io.children()) {
                IOFile.add(f, files, off);
            }
        } else {
            files.add(io.path().substring(off).replace('\\', '/'));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] c) throws IOException {
        FileOutputStream out = new FileOutputStream(this.path);
        try {
            out.write(c);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InputStream in) throws IOException {
        BufferOutput out = null;
        try {
            int i;
            out = new BufferOutput(this.path);
            while ((i = in.read()) != -1) {
                out.write(i);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            if (out != null) {
                out.close();
            }
        }
    }

    public boolean delete() {
        boolean ok = true;
        if (this.file.exists()) {
            if (this.isDir()) {
                for (IOFile ch : this.children()) {
                    ok &= ch.delete();
                }
            }
            for (int i = 0; i < 5; ++i) {
                if (this.file.delete() && !this.file.exists()) {
                    return ok;
                }
                Performance.sleep((long)i * 10L);
            }
        }
        return false;
    }

    public boolean rename(IOFile trg) {
        return this.file.renameTo(trg.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(IOFile trg) throws IOException {
        int bsize = (int)Math.max(1L, Math.min(this.length(), 0x400000L));
        byte[] buf = new byte[bsize];
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int i;
            new IOFile(trg.dir()).md();
            fis = new FileInputStream(this.file);
            fos = new FileOutputStream(trg.file);
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    @Override
    public String url() {
        TokenBuilder tb = new TokenBuilder("file:");
        if (!this.path.startsWith("/")) {
            tb.add("///");
        }
        for (int p = 0; p < this.path.length(); ++p) {
            char ch = this.path.charAt(p);
            if (ch == ' ') {
                tb.add("%20");
                continue;
            }
            tb.add(ch);
        }
        return tb.toString();
    }

    public static boolean isValid(String s) {
        return s.length() < 3 || s.indexOf(58) == -1 || Token.letter(s.charAt(0)) && s.charAt(1) == ':';
    }

    public static String regex(String glob) {
        return IOFile.regex(glob, true);
    }

    public static String regex(String glob, boolean sub) {
        StringBuilder sb = new StringBuilder();
        for (String g : glob.split(",")) {
            boolean suf = false;
            String gl = g.trim();
            if (sb.length() != 0) {
                if (!suf) {
                    sb.append(".*");
                }
                suf = false;
                sb.append('|');
            }
            for (int f = 0; f < gl.length(); ++f) {
                char ch = gl.charAt(f);
                if (ch == '*') {
                    suf = true;
                    sb.append(gl.endsWith(".") ? "[^.]" : ".");
                } else if (ch == '?') {
                    ch = '.';
                    suf = true;
                } else if (ch == '.') {
                    suf = true;
                    if (f + 1 == gl.length()) break;
                    sb.append('\\');
                } else if (!Character.isLetterOrDigit(ch)) {
                    sb.append('\\');
                }
                sb.append(ch);
            }
            if (suf || !sub) continue;
            sb.append(".*");
        }
        return Prop.WIN ? sb.toString().toLowerCase(Locale.ENGLISH) : sb.toString();
    }

    static class PathList
    extends StringList {
        PathList() {
        }

        String create(String path) {
            TokenBuilder tb = new TokenBuilder();
            int l = path.length();
            for (int i = 0; i < l; ++i) {
                char ch = path.charAt(i);
                if (ch == '\\' || ch == '/') {
                    this.add(tb);
                    continue;
                }
                tb.add(ch);
            }
            this.add(tb);
            if (path.startsWith("\\\\") || path.startsWith("//")) {
                tb.add("//");
            }
            for (int s = 0; s < this.size; ++s) {
                if (s != 0 || path.startsWith("/")) {
                    tb.add(47);
                }
                tb.add(this.list[s]);
            }
            return tb.toString();
        }

        private void add(TokenBuilder tb) {
            String s = tb.toString();
            if (s.length() > 1 && s.charAt(1) == ':' && this.size == 0) {
                s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
            }
            if (s.equals("..") && this.size > 0) {
                if (this.list[this.size - 1].indexOf(58) == -1) {
                    this.deleteAt(this.size - 1);
                }
            } else if (!s.equals(".") && !s.isEmpty()) {
                this.add(s);
            }
            tb.reset();
        }
    }
}

