/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.flwor.For;
import org.basex.query.iter.Iter;
import org.basex.query.util.Var;
import org.basex.query.value.item.Bln;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public final class Quantifier
extends ParseExpr {
    private final boolean every;
    private final For[] fl;
    private Expr sat;

    public Quantifier(InputInfo ii, For[] f, Expr s, boolean e) {
        super(ii);
        this.sat = s;
        this.fl = f;
        this.every = e;
        this.type = SeqType.BLN;
    }

    @Override
    public void checkUp() throws QueryException {
        for (For f : this.fl) {
            f.checkUp();
        }
        this.checkNoUp(this.sat);
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        int vs = ctx.vars.size();
        for (For f : this.fl) {
            f.compile(ctx);
        }
        this.sat = this.sat.compile(ctx).compEbv(ctx);
        ctx.vars.size(vs);
        boolean empty = false;
        for (For f : this.fl) {
            empty |= f.isEmpty();
        }
        return empty ? this.optPre(Bln.get(this.every), ctx) : this;
    }

    @Override
    public Bln item(QueryContext ctx, InputInfo ii) throws QueryException {
        Iter[] iter = new Iter[this.fl.length];
        for (int f = 0; f < this.fl.length; ++f) {
            iter[f] = ctx.iter(this.fl[f]);
        }
        return Bln.get(this.iter(ctx, iter, 0));
    }

    private boolean iter(QueryContext ctx, Iter[] it, int p) throws QueryException {
        boolean last;
        boolean bl = last = p + 1 == this.fl.length;
        while (it[p].next() != null) {
            if (!(this.every ^ (last ? this.sat.ebv(ctx, this.info).bool(this.info) : this.iter(ctx, it, p + 1)))) continue;
            for (Iter ri : it) {
                ri.reset();
            }
            return !this.every;
        }
        return this.every;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.VAR || this.sat.uses(u);
    }

    @Override
    public int count(Var v) {
        int c = 0;
        for (For f : this.fl) {
            c += f.count(v);
        }
        return c + this.sat.count(v);
    }

    @Override
    public boolean removable(Var v) {
        for (For f : this.fl) {
            if (f.removable(v)) continue;
            return false;
        }
        return this.sat.removable(v);
    }

    @Override
    public Expr remove(Var v) {
        for (For f : this.fl) {
            f.remove(v);
        }
        this.sat = this.sat.remove(v);
        return this;
    }

    @Override
    public boolean databases(StringList db) {
        for (For f : this.fl) {
            if (f.databases(db)) continue;
            return false;
        }
        return this.sat.databases(db);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.TYP, this.every ? "every" : "some"), new Object[]{this.fl, this.sat});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.every ? "every" : "some");
        for (For f : this.fl) {
            sb.append(' ').append(f);
        }
        return sb.append(" satisfies " + this.sat).toString();
    }
}

