/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.util.Num;
import org.basex.util.list.ByteList;

public final class Compress
extends ByteList {
    private int pc;
    private int po;
    private int uc;
    private int uo;
    private static final byte[] UNPACK1 = new byte[]{32, 97, 101, 110, 105, 111, 114, 115, 116, 108, 117, 104, 100, 99, 103, 109, 112, 121, 98, 107, 102, 118, 67, 83, 119, 77, 65, 66, 80, 122, 46, 10, 84, 82, 75, 76, 71, 78, 72, 106, 69, 73, 68, 70, 74, 120, 79, 113, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 45, 39, 44, 34, 63, 86, 87, 85, 90, 89, 81, 88, 9, 64, 40, 47, 41, 43, 126, 33, 35, 36, 37, 38, 42, 59, 60, 61, 62, 91, 92, 93, 94, 95, 96, 123, 124, 125, 127, 0, 1, 2, 3, 4, 5, 6, 7, 8, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final byte[] PACK1 = new byte[UNPACK1.length];
    private static final byte[] UNPACK2 = new byte[UNPACK1.length];
    private static final byte[] PACK2 = new byte[UNPACK2.length];

    public byte[] pack(byte[] txt) {
        int tl = txt.length;
        this.reset();
        Num.set(this.list, tl, 0);
        this.size = Num.length(tl);
        this.pc = 0;
        this.po = 0;
        this.push(0, 1);
        int lc = 0;
        for (byte b : txt) {
            lc += b >= 65 && b <= 90 ? -1 : 1;
        }
        byte[] pack = lc >= 0 ? PACK1 : PACK2;
        this.push(lc >= 0 ? 1 : 0, 1);
        for (int t = 0; t < tl; ++t) {
            byte b = txt[t];
            if (b >= 0) {
                b = pack[b];
            }
            if (b >= 0 && b < 8) {
                this.push(1 | b << 1, 4);
                continue;
            }
            if (b >= 8 && b < 16) {
                this.push(2 | b << 2, 5);
                continue;
            }
            if (b >= 16 && b < 32) {
                this.push(4 | b << 3, 7);
                continue;
            }
            if (b >= 32 && b < 64) {
                this.push(8 | b << 4, 9);
                continue;
            }
            this.push(b << 4, 12);
        }
        if (this.po != 0) {
            this.add(this.pc);
        }
        return this.size() < tl ? this.toArray() : txt;
    }

    private void push(int b, int s) {
        int bb = b;
        int oo = this.po;
        int cc = this.pc;
        for (int i = 0; i < s; ++i) {
            cc |= (bb & 1) << oo;
            bb >>= 1;
            if (++oo != 8) continue;
            this.add(cc);
            oo = 0;
            cc = 0;
        }
        this.po = oo;
        this.pc = cc;
    }

    public synchronized byte[] unpack(byte[] txt) {
        this.list = txt;
        this.size = txt.length;
        this.uc = Num.length(txt, 0);
        this.uo = 0;
        this.pull();
        byte[] unpack = this.pull() ? UNPACK1 : UNPACK2;
        int l = Num.get(txt, 0);
        byte[] res = new byte[l];
        for (int r = 0; r < l; ++r) {
            int b = this.pull() ? this.pull(3) : (this.pull() ? this.pull(3) | 8 : (this.pull() ? this.pull(4) | 0x10 : (this.pull() ? this.pull(5) | 0x20 : this.pull(8))));
            res[r] = (byte)(b >= 128 ? b : unpack[b]);
        }
        return res;
    }

    private int pull(int s) {
        int oo = this.uo;
        int cc = this.uc;
        int x = 0;
        for (int i = 0; i < s; ++i) {
            if ((this.list[cc] & 1 << oo) != 0) {
                x |= 1 << i;
            }
            if (++oo != 8) continue;
            oo = 0;
            ++cc;
        }
        this.uo = oo;
        this.uc = cc;
        return x;
    }

    private boolean pull() {
        boolean b;
        boolean bl = b = (this.list[this.uc] & 1 << this.uo) != 0;
        if (++this.uo == 8) {
            this.uo = 0;
            ++this.uc;
        }
        return b;
    }

    static {
        int pl = UNPACK1.length;
        for (int p = 0; p < pl; ++p) {
            byte b2;
            int b1 = UNPACK1[p];
            Compress.UNPACK2[p] = b2 = (byte)(b1 >= 65 && b1 <= 90 ? b1 + 32 : (b1 >= 97 && b1 <= 122 ? b1 - 32 : b1));
            Compress.PACK1[b1] = (byte)p;
            Compress.PACK2[b2] = (byte)p;
        }
    }
}

