/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Scanner;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.server.LoginException;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.StringList;

public final class Util {
    private static final boolean NOCONSOLE = System.console() == null;

    private Util() {
    }

    public static String bug(Throwable ex) {
        TokenBuilder tb = new TokenBuilder("Improper use? Potential bug? Your feedback is welcome:");
        tb.add(Text.NL).add("Contact: ").add(Text.MAIL);
        tb.add(Text.NL).add("Version: ").add("BaseX 7.3.1 beta");
        tb.add(Text.NL).add("Java: ").add(System.getProperty("java.vendor"));
        tb.add(", ").add(System.getProperty("java.version"));
        tb.add(Text.NL).add("OS: ").add(System.getProperty("os.name"));
        tb.add(", ").add(System.getProperty("os.arch"));
        tb.add(Text.NL).add("Stack Trace: ");
        for (String e : Util.toArray(ex)) {
            tb.add(Text.NL).add(e);
        }
        return tb.toString();
    }

    public static RuntimeException notexpected(Object ... ext) {
        TokenBuilder tb = new TokenBuilder();
        tb.addExt("%", ext.length == 0 ? "Not Expected." : ext[0]);
        throw new RuntimeException(tb.toString());
    }

    public static RuntimeException notimplemented(Object ... ext) {
        TokenBuilder tb = new TokenBuilder("Not Implemented");
        if (ext.length != 0) {
            tb.addExt(" (%)", ext);
        }
        throw new UnsupportedOperationException(tb.add(46).toString());
    }

    public static String name(Object o) {
        return Util.name(o.getClass());
    }

    public static String name(Class<?> o) {
        return o.getSimpleName();
    }

    public static String input() {
        Scanner sc = new Scanner(System.in);
        return sc.hasNextLine() ? sc.nextLine().trim() : "";
    }

    public static String password() {
        if (NOCONSOLE) {
            return Util.input();
        }
        char[] pw = System.console().readPassword();
        return pw != null ? new String(pw) : "";
    }

    public static void outln() {
        Util.out(Text.NL, new Object[0]);
    }

    public static void outln(Object str, Object ... ext) {
        Util.out((str instanceof byte[] ? Token.string((byte[])str) : str) + Text.NL, ext);
    }

    public static void out(Object str, Object ... ext) {
        System.out.print(Util.info(str, ext));
    }

    public static void errln(Object obj, Object ... ext) {
        Util.err((obj instanceof Throwable ? Util.message((Throwable)obj) : obj) + Text.NL, ext);
    }

    public static void err(String string, Object ... ext) {
        System.err.print(Util.info(string, ext));
    }

    public static String message(Throwable ex) {
        String msg = ex.getMessage();
        if (ex instanceof BindException) {
            return Text.SRV_RUNNING;
        }
        if (ex instanceof FileNotFoundException) {
            return Util.info(Text.RES_NOT_FOUND_X, msg);
        }
        if (ex instanceof LoginException) {
            return Text.ACCESS_DENIED;
        }
        if (ex instanceof ConnectException) {
            return Text.CONNECTION_ERROR;
        }
        if (ex instanceof SocketTimeoutException) {
            return Text.TIMEOUT_EXCEEDED;
        }
        if (ex instanceof SocketException) {
            return Text.CONNECTION_ERROR;
        }
        if (ex instanceof UnknownHostException) {
            return Util.info(Text.UNKNOWN_HOST_X, msg);
        }
        if (ex instanceof RuntimeException) {
            return ex.getStackTrace()[0].getClassName() + ": " + ex;
        }
        return msg != null && !msg.isEmpty() ? msg : ex.toString();
    }

    public static boolean debug(Throwable ex) {
        if (Prop.debug && ex != null) {
            Util.stack(ex);
        }
        return false;
    }

    public static void debug(Object str, Object ... ext) {
        if (Prop.debug) {
            Util.errln(str, ext);
        }
    }

    public static void memory(Performance perf) {
        if (!Prop.debug) {
            return;
        }
        Util.errln(" " + perf + " (" + Performance.getMemory() + ')', new Object[0]);
    }

    public static String info(Object str, Object ... ext) {
        return Token.string(Util.inf(str, ext));
    }

    public static byte[] inf(Object str, Object ... ext) {
        return new TokenBuilder().addExt(str, ext).finish();
    }

    public static void stack(int i) {
        Util.errln("You're here:", new Object[0]);
        Util.stack(new Throwable(), i);
    }

    public static void stack(Throwable th) {
        Util.stack(th, 0);
    }

    private static void stack(Throwable th, int i) {
        String[] stack = Util.toArray(th);
        int l = stack.length;
        if (i > 0 && i < l) {
            l = i;
        }
        for (int s = 0; s < l; ++s) {
            Util.errln(stack[s], new Object[0]);
        }
    }

    private static String[] toArray(Throwable th) {
        StackTraceElement[] st = th.getStackTrace();
        String[] obj = new String[st.length + 1];
        obj[0] = th.toString();
        for (int i = 0; i < st.length; ++i) {
            obj[i + 1] = "  " + st[i];
        }
        return obj;
    }

    public static Process start(Class<?> clz, String ... args) {
        String[] largs = new String[]{"java", "-Xmx" + Runtime.getRuntime().maxMemory(), "-cp", System.getProperty("java.class.path"), clz.getName(), "-D"};
        StringList sl = new StringList().add(largs).add(args);
        try {
            return new ProcessBuilder(sl.toArray()).start();
        }
        catch (IOException ex) {
            Util.notexpected(ex);
            return null;
        }
    }

    public static boolean yes(String string) {
        return Token.eqic(string, "yes", "true", "ON", Text.INFOON);
    }

    public static boolean no(String string) {
        return Token.eqic(string, "no", "false", "OFF", Text.INFOOFF);
    }

    public static String flag(boolean flag) {
        return flag ? Text.INFOON : Text.INFOOFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Date date, DateFormat format) {
        DateFormat dateFormat = format;
        synchronized (dateFormat) {
            return format.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String date, DateFormat format) throws ParseException {
        DateFormat dateFormat = format;
        synchronized (dateFormat) {
            return format.parse(date);
        }
    }
}

