/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.File;
import java.io.FileInputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Vector;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.ChallengeAnswerRequest;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.GetSiteInfoResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib4.HandleElement;
import net.handle.hdllib4.HandleElementSet;
import net.handle.hdllib4.HandleResolver;
import net.handle.hdllib4.HandleResponse;
import net.handle.server.AbstractServer;
import net.handle.server.Main;
import net.handle.util.StreamTable;

public class HandleGateway
extends AbstractServer {
    private static final byte[] MSG_HANDLE_NOT_FOUND = Util.encodeString("Handle not found");
    private static final byte[] MSG_VALUES_NOT_FOUND = Util.encodeString("Requested values not found");
    private static final byte[] MSG_INTERNAL_ERROR = Util.encodeString("Internal Error");
    private static final byte[] MSG_OUT_OF_DATE_SITE_INFO = Util.encodeString("Site info out of date");
    private static final byte[] MSG_WRONG_SERVER_HASH = Util.encodeString("Request was hashed incorrectly");
    private static final byte[] MSG_INVALID_REQUEST = Util.encodeString("Request was invalid");
    private static final byte[] MSG_NOT_A_PRIMARY = Util.encodeString("Server is read-only");
    private static final byte[] MSG_CHALLENGE_NOT_FOUND = Util.encodeString("Challenge not found");
    private static final byte[] MSG_SERVER_TIMED_OUT = Util.encodeString("Server timed out");
    public static final String THIS_SERVER_ID = "this_server_id";
    public static final String SERVER_ADMINS = "server_admins";
    public static final String SITE_INFO_FILE = "siteinfo.bin";
    public static final String PRIVATE_KEY_FILE = "privkey.bin";
    private String TRANSACTION_LOCK = "TRANSACTION_LOCK";
    private String NEXT_TXN_ID_LOCK = "NEXT_TXN_ID_LOCK";
    private static final byte[] SIGN_TEST = Util.encodeString("Testing...1..2..3");
    private boolean keepRunning = true;
    private HandleResolver resolver4 = new HandleResolver();
    private boolean caseSensitive = false;
    private ValueReference[] serverAdmins;
    private SiteInfo thisSite = null;
    private int thisServerNum = -1;
    private Signature serverSignature = null;

    public HandleGateway(Main main, StreamTable config) throws Exception {
        super(main, config);
        this.resolver4.tcpTimeout = 10000L;
        try {
            int thisId = Integer.parseInt((String)config.get(THIS_SERVER_ID));
            SiteInfo site = new SiteInfo();
            File siteInfoFile = new File(main.getConfigDir(), SITE_INFO_FILE);
            if (!siteInfoFile.exists() || !siteInfoFile.canRead()) {
                throw new Exception("Missing or inaccessible site info file: " + siteInfoFile.getAbsolutePath());
            }
            byte[] siteInfoBuf = new byte[(int)siteInfoFile.length()];
            new FileInputStream(siteInfoFile).read(siteInfoBuf);
            Encoder.decodeSiteInfoRecord(siteInfoBuf, 0, site);
            this.thisServerNum = -1;
            for (int i = 0; i < site.servers.length; ++i) {
                if (site.servers[i].serverId != thisId) continue;
                this.thisServerNum = i;
            }
            if (this.thisServerNum < 0) {
                throw new Exception("Server ID " + thisId + " does not exist in site!");
            }
            this.thisSite = site;
        }
        catch (Exception e) {
            System.err.println("Invalid site/server specification: " + e);
            throw e;
        }
        try {
            int r;
            this.serverSignature = Signature.getInstance("SHA1withDSA");
            File privateKeyFile = new File(main.getConfigDir(), PRIVATE_KEY_FILE);
            if (!privateKeyFile.exists() || !privateKeyFile.canRead()) {
                System.err.println("Missing or inaccessible private key file: " + privateKeyFile.getAbsolutePath());
                System.err.println("See net.server.ServerKeyGenerator about generating a set of keys");
                throw new Exception("Missing or inaccessible private key file: " + privateKeyFile.getAbsolutePath());
            }
            FileInputStream in = new FileInputStream(privateKeyFile);
            byte[] encKeyBytes = new byte[(int)privateKeyFile.length()];
            for (int n = 0; n < encKeyBytes.length && (r = in.read(encKeyBytes, n, encKeyBytes.length - n)) >= 0; n += r) {
            }
            byte[] secKey = null;
            if (Util.requiresSecretKey(encKeyBytes)) {
                secKey = Util.getPassphrase("Enter the passphrase for this server's private key: ");
            }
            byte[] keyBytes = Util.decrypt(encKeyBytes, secKey);
            for (int i = 0; secKey != null && i < secKey.length; ++i) {
                secKey[i] = 0;
            }
            PrivateKey privKey = Util.getPrivateKeyFromBytes(keyBytes, 0);
            this.serverSignature.initSign(privKey);
            for (int i = 0; i < keyBytes.length; ++i) {
                keyBytes[i] = 0;
            }
            PublicKey pubKey = Util.getPublicKeyFromBytes(this.thisSite.servers[this.thisServerNum].publicKey, 0);
            this.serverSignature.update(SIGN_TEST);
            byte[] testSig = this.serverSignature.sign();
            Signature verifier = Signature.getInstance(this.serverSignature.getAlgorithm());
            verifier.initVerify(pubKey);
            verifier.update(SIGN_TEST);
            if (!verifier.verify(testSig)) {
                throw new Exception("Private key doesn't match public key from site info!");
            }
        }
        catch (Exception e) {
            System.err.println("Unable to initialize server signature object: " + e);
            throw e;
        }
        if (config.containsKey(SERVER_ADMINS)) {
            try {
                Vector adminVect = (Vector)config.get(SERVER_ADMINS);
                this.serverAdmins = new ValueReference[adminVect.size()];
                for (int i = 0; i < adminVect.size(); ++i) {
                    String adminStr = String.valueOf(adminVect.elementAt(i));
                    int colIdx = adminStr.indexOf(58);
                    if (colIdx <= 0) {
                        throw new Exception("Invalid server administrator ID: \"" + adminStr + "\"");
                    }
                    this.serverAdmins[i] = new ValueReference(Util.encodeString(adminStr.substring(colIdx + 1)), Integer.parseInt(adminStr.substring(0, colIdx)));
                }
            }
            catch (Exception e) {
                throw new Exception("Error processing server administrator list: " + e);
            }
        }
    }

    public void processRequest(AbstractRequest req, ResponseMessageCallback callback) throws HandleException {
        this.processRequest(req, null, null, callback);
    }

    private void processRequest(AbstractRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq, ResponseMessageCallback callback) throws HandleException {
        switch (req.opCode) {
            case 2: {
                this.sendResponse(callback, new GetSiteInfoResponse(req, this.thisSite));
            }
            case 1: {
                this.sendResponse(callback, this.doResolution((ResolutionRequest)req, cRes, crReq));
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 201: 
            case 1000: 
            case 1001: 
            case 1002: {
                this.sendResponse(callback, new ErrorResponse(req, 2, MSG_NOT_A_PRIMARY));
            }
            case 200: {
                this.sendResponse(callback, new ErrorResponse(req, 405, MSG_CHALLENGE_NOT_FOUND));
            }
        }
        throw new HandleException(1, "Unknown operation: " + req.opCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(ResponseMessageCallback callback, AbstractResponse response) throws HandleException {
        response.siteInfoSerial = this.thisSite.serialNumber;
        if (response.certify) {
            try {
                Signature signature = this.serverSignature;
                synchronized (signature) {
                    response.signMessage(this.serverSignature);
                }
            }
            catch (Exception e) {
                this.main.logError(75, "Exception signing response: " + e);
            }
        }
        callback.handleResponse(response);
    }

    private static final long[] newTypesToOld(byte[][] newTypes) {
        long[] oldTypes = new long[newTypes.length];
        for (int i = 0; i < oldTypes.length; ++i) {
            oldTypes[i] = HandleGateway.newTypeToOld(newTypes[i]);
        }
        return oldTypes;
    }

    private static final long newTypeToOld(byte[] newType) {
        if (Util.equalsCI(newType, Common.STD_TYPE_URL)) {
            return 0L;
        }
        if (Util.equalsCI(newType, Common.STD_TYPE_EMAIL)) {
            return 1L;
        }
        if (Util.equalsCI(newType, Common.STD_TYPE_HSSERV)) {
            return 10L;
        }
        if (Util.equalsCI(newType, Common.STD_TYPE_HOSTNAME)) {
            return 4L;
        }
        if (Util.equalsCI(newType, Common.STD_TYPE_URN)) {
            return 12L;
        }
        try {
            return Long.parseLong(Util.decodeString(newType));
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    private static final byte[] oldTypeToNew(int oldType) {
        switch (oldType) {
            case 0: {
                return Common.STD_TYPE_URL;
            }
            case 1: 
            case 2: {
                return Common.STD_TYPE_EMAIL;
            }
            case 4: {
                return Common.STD_TYPE_HOSTNAME;
            }
            case 6: {
                return Common.STD_TYPE_EMAIL;
            }
            case 10: {
                return Common.STD_TYPE_HSSERV;
            }
            case 12: {
                return Common.STD_TYPE_URN;
            }
        }
        return Util.encodeString(String.valueOf(oldType));
    }

    private AbstractResponse doResolution(ResolutionRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        try {
            HandleResponse response = this.resolver4.resolveHandleWithDefaultMethod(Util.decodeString(req.handle), HandleGateway.newTypesToOld(req.requestedTypes));
            if (response.haveAllPackets()) {
                HandleElementSet valueSet = response.getPackagedData();
                if (valueSet == null) {
                    return new ErrorResponse(req, 100, MSG_HANDLE_NOT_FOUND);
                }
                if (valueSet.getElementCount() <= 0) {
                    return new ErrorResponse(req, 200, MSG_VALUES_NOT_FOUND);
                }
                HandleElement[] oldValues = valueSet.getAllElements();
                byte[][] values = new byte[oldValues.length][];
                int now = (int)(System.currentTimeMillis() / 1000L);
                for (int i = 0; i < values.length; ++i) {
                    HandleValue val = new HandleValue(i + 1, HandleGateway.oldTypeToNew((int)oldValues[i].handleType), oldValues[i].handleValue, 0, 86400, now, null, true, true, true, false);
                    values[i] = new byte[Encoder.calcStorageSize(val)];
                    Encoder.encodeHandleValue(values[i], 0, val);
                }
                return new ResolutionResponse(req, req.handle, values);
            }
            return new ErrorResponse(req, 2, MSG_SERVER_TIMED_OUT);
        }
        catch (Exception e) {
            this.main.logError(50, String.valueOf(this.getClass()) + ": error getting values: " + e);
            return new ErrorResponse(req, 2, Util.encodeString(String.valueOf(e)));
        }
    }

    public void shutdown() {
        this.keepRunning = false;
    }
}

