/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.clarin.profiles;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JDialog;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.arbil.ui.ArbilTreeController;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;

public class ProfilePreview {
    private static SessionStorage sessionStorage;
    private static DataNodeLoader dataNodeLoader;

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    public String schemaToTreeView(String uriString) {
        String returnString = "";
        try {
            ArbilWindowManager windowManager;
            File tempFile = File.createTempFile("ArbilPreview", ".cmdi", sessionStorage.getApplicationSettingsDirectory());
            tempFile.deleteOnExit();
            ArbilComponentBuilder componentBuilder = new ArbilComponentBuilder();
            URI addedNodePath = componentBuilder.createComponentFile(tempFile.toURI(), new URI(uriString), true);
            ArbilDataNode demoNode = dataNodeLoader.getArbilDataNode(null, addedNodePath);
            demoNode.waitTillLoaded();
            DefaultMutableTreeNode rootTreeNode = new DefaultMutableTreeNode(demoNode);
            DefaultTreeModel demoTreeModel = new DefaultTreeModel(rootTreeNode, true);
            ArbilWindowManager dialogHandler = windowManager = new ArbilWindowManager();
            ArbilTreeHelper treeHelper = new ArbilTreeHelper(sessionStorage, windowManager);
            ArbilTreeController treeController = new ArbilTreeController(sessionStorage, treeHelper, windowManager, dialogHandler, dataNodeLoader);
            ArbilTree demoTree = new ArbilTree(treeController, treeHelper, windowManager);
            demoTree.setModel(demoTreeModel);
            demoTree.requestResort();
            JDialog demoDialogue = new JDialog();
            demoDialogue.setDefaultCloseOperation(2);
            demoDialogue.pack();
            demoDialogue.setContentPane(demoTree);
            demoDialogue.setVisible(true);
        }
        catch (IOException exception) {
            System.out.println(exception.getMessage());
        }
        catch (URISyntaxException exception) {
            System.out.println(exception.getMessage());
        }
        return returnString;
    }

    public static void main(String[] args) {
        new ProfilePreview().schemaToTreeView("http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/profiles/clarin.eu:cr1:p_1271859438166/xsd");
    }
}

