/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.plugins.export;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.ProgressMonitor;
import nl.mpi.flap.kinnate.entityindexer.QueryException;
import nl.mpi.flap.plugin.PluginBugCatcher;
import nl.mpi.flap.plugin.PluginDialogHandler;
import nl.mpi.flap.plugin.PluginException;
import nl.mpi.flap.plugin.PluginSessionStorage;
import nl.mpi.kinnate.entityindexer.CollectionExport;
import nl.mpi.kinnate.plugins.export.GedcomExport;

public class MigrationWizard {
    final PluginBugCatcher bugCatcher;
    final PluginDialogHandler dialogHandler;
    final PluginSessionStorage sessionStorage;

    public MigrationWizard(PluginBugCatcher bugCatcher, PluginDialogHandler dialogHandler, PluginSessionStorage sessionStorage) {
        this.bugCatcher = bugCatcher;
        this.dialogHandler = dialogHandler;
        this.sessionStorage = sessionStorage;
    }

    public File checkAndOfferMigration(int majorVersion, int minorVersion) {
        File oldAppDir = new File(this.sessionStorage.getApplicationSettingsDirectory().getParentFile(), ".kinoath-" + majorVersion + "-" + (minorVersion - 1));
        File oldAppExportFile = new File(oldAppDir, "MigrationWizard.kinoath");
        File newAppDir = this.sessionStorage.getProjectWorkingDirectory();
        if (oldAppDir.exists() && (!newAppDir.exists() || newAppDir.list().length < 3)) {
            if (this.dialogHandler.showConfirmDialogBox("This is a new version of KinOath.\nWould you like to import the data from the last version?\n", "Migration Wizard")) {
                if (!oldAppExportFile.exists()) {
                    this.createDatabase(oldAppDir, oldAppExportFile);
                }
                return oldAppExportFile;
            }
            this.dialogHandler.addMessageDialogToQueue("If you change you mind, you can migrate your data from the old version manually\nvia the plugins menu and 'single file export' followed by an import.", "Migration Wizard");
            return null;
        }
        return null;
    }

    private void createDatabase(File importDirectory, File exportFile) {
        ProgressMonitor pogressMonitor = new ProgressMonitor(null, "Migration Wizard", "cteating temporary database", 0, 5);
        pogressMonitor.setMillisToDecideToPopup(0);
        pogressMonitor.setMillisToPopup(0);
        pogressMonitor.setProgress(1);
        CollectionExport entityCollection = new CollectionExport(this.bugCatcher, this.sessionStorage);
        try {
            GedcomExport gedcomExport = new GedcomExport(entityCollection);
            gedcomExport.dropAndCreate(importDirectory, "*.kmdi");
            pogressMonitor.setNote("generating export file.");
            pogressMonitor.setProgress(2);
            if (pogressMonitor.isCanceled()) {
                return;
            }
            String generateExportResult = gedcomExport.generateExport(gedcomExport.getGedcomQuery());
            pogressMonitor.setNote("saving export file.");
            pogressMonitor.setProgress(3);
            if (pogressMonitor.isCanceled()) {
                return;
            }
            FileWriter fileWriter = new FileWriter(exportFile);
            fileWriter.write(generateExportResult);
            fileWriter.close();
            pogressMonitor.setNote("save complete.");
            pogressMonitor.setProgress(4);
            if (pogressMonitor.isCanceled()) {
                return;
            }
        }
        catch (IOException exception) {
            this.dialogHandler.addMessageDialogToQueue("Error Saving File\n" + exception.getMessage(), "Migration Wizard");
            this.bugCatcher.logException(new PluginException(exception.getMessage()));
        }
        catch (QueryException exception) {
            this.dialogHandler.addMessageDialogToQueue("Error Creating Export\n" + exception.getMessage(), "Migration Wizard");
            this.bugCatcher.logException(new PluginException(exception.getMessage()));
        }
        pogressMonitor.setProgress(5);
    }
}

