/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.RelationTypeDefinition;
import nl.mpi.kinnate.kindocument.RelationLinker;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.svg.GraphicsDragHandle;
import nl.mpi.kinnate.svg.RelationDragHandle;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.SvgElementEditor;
import nl.mpi.kinnate.uniqueidentifiers.IdentifierException;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MouseListenerSvg
extends MouseInputAdapter
implements EventListener {
    private Cursor preDragCursor;
    private KinDiagramPanel kinDiagramPanel;
    private GraphPanel graphPanel;
    private Point startDragPoint = null;
    private Point startRectangleSelectPoint = null;
    private boolean mouseActionOnNode = false;
    private boolean mouseActionIsPopupTrigger = false;
    private boolean mouseActionIsDrag = false;
    private UniqueIdentifier entityToToggle = null;
    private HashMap<UniqueIdentifier, SvgElementEditor> shownGraphicsEditors;
    private MessageDialogHandler dialogHandler;
    private final SessionStorage sessionStorage;
    private EntityCollection entityCollection;

    public MouseListenerSvg(KinDiagramPanel kinDiagramPanel, GraphPanel graphPanel, SessionStorage sessionStorage, MessageDialogHandler dialogHandler, EntityCollection entityCollection) {
        this.kinDiagramPanel = kinDiagramPanel;
        this.graphPanel = graphPanel;
        this.dialogHandler = dialogHandler;
        this.sessionStorage = sessionStorage;
        this.entityCollection = entityCollection;
        this.shownGraphicsEditors = new HashMap();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (this.graphPanel.svgUpdateHandler.relationDragHandle != null) {
            this.graphPanel.svgUpdateHandler.updateDragRelation(me.getPoint().x, me.getPoint().y);
        } else {
            if (this.startDragPoint != null) {
                if (SwingUtilities.isMiddleMouseButton(me)) {
                    this.graphPanel.svgUpdateHandler.dragCanvas(me.getPoint().x - this.startDragPoint.x, me.getPoint().y - this.startDragPoint.y);
                } else if (SwingUtilities.isLeftMouseButton(me)) {
                    this.checkSelectionClearRequired(me);
                    if (!this.mouseActionOnNode) {
                        if (this.startRectangleSelectPoint == null) {
                            this.startRectangleSelectPoint = me.getPoint();
                        }
                        this.graphPanel.svgUpdateHandler.drawSelectionRect(new Point(this.startRectangleSelectPoint.x, this.startRectangleSelectPoint.y), new Point(me.getPoint().x, me.getPoint().y));
                    } else if (this.graphPanel.selectedGroupId.size() > 0) {
                        this.graphPanel.svgCanvas.setCursor(Cursor.getPredefinedCursor(13));
                        this.graphPanel.svgUpdateHandler.updateDragNode(me.getPoint().x - this.startDragPoint.x, me.getPoint().y - this.startDragPoint.y);
                    }
                }
                this.mouseActionIsDrag = true;
            } else {
                this.graphPanel.svgUpdateHandler.startDrag();
            }
            this.startDragPoint = me.getPoint();
        }
    }

    private void checkSelectionClearRequired(MouseEvent me) {
        boolean shiftDown = me.isShiftDown();
        if (!shiftDown && !this.mouseActionIsPopupTrigger && !this.mouseActionOnNode && SwingUtilities.isLeftMouseButton(me)) {
            System.out.println("Clear selection");
            this.graphPanel.selectedGroupId.clear();
            this.updateSelectionDisplay();
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (this.graphPanel.dataStoreSvg.graphData == null) {
            return;
        }
        this.graphPanel.svgCanvas.setCursor(this.preDragCursor);
        if (this.mouseActionIsDrag) {
            this.graphPanel.svgUpdateHandler.updateCanvasSize(false);
        }
        this.startDragPoint = null;
        if (!this.mouseActionIsDrag && this.entityToToggle != null) {
            this.graphPanel.selectedGroupId.remove(this.entityToToggle);
            this.entityToToggle = null;
            this.updateSelectionDisplay();
        }
        this.checkSelectionClearRequired(me);
        if (this.startRectangleSelectPoint != null) {
            this.startRectangleSelectPoint = null;
            Rectangle dragSelectionRectOnDocument = this.graphPanel.svgUpdateHandler.removeSelectionRect();
            this.graphPanel.selectedGroupId.addAll(this.graphPanel.entitySvg.getEntitiesWithinRect(dragSelectionRectOnDocument));
            this.updateSelectionDisplay();
        }
        this.mouseActionOnNode = false;
        if (this.graphPanel.svgUpdateHandler.relationDragHandle != null) {
            new Thread(new Runnable(){

                public void run() {
                    if (((MouseListenerSvg)MouseListenerSvg.this).graphPanel.svgUpdateHandler.relationDragHandle.targetIdentifier != null) {
                        MouseListenerSvg.this.kinDiagramPanel.showProgressBar();
                        try {
                            DataTypes.RelationType relationType = DataTypes.getOpposingRelationType(((MouseListenerSvg)MouseListenerSvg.this).graphPanel.svgUpdateHandler.relationDragHandle.getRelationType());
                            UniqueIdentifier[] changedIdentifiers = new RelationLinker(MouseListenerSvg.this.sessionStorage, MouseListenerSvg.this.dialogHandler, MouseListenerSvg.this.entityCollection).linkEntities(((MouseListenerSvg)MouseListenerSvg.this).graphPanel.svgUpdateHandler.relationDragHandle.targetIdentifier, MouseListenerSvg.this.graphPanel.getSelectedIds(), relationType, ((MouseListenerSvg)MouseListenerSvg.this).graphPanel.svgUpdateHandler.relationDragHandle.getDataCategory(), ((MouseListenerSvg)MouseListenerSvg.this).graphPanel.svgUpdateHandler.relationDragHandle.getDisplayName());
                            MouseListenerSvg.this.kinDiagramPanel.entityRelationsChanged(changedIdentifiers);
                        }
                        catch (ImportException exception) {
                            MouseListenerSvg.this.dialogHandler.addMessageDialogToQueue("Failed to create relation: " + exception.getMessage(), "Drag Relation");
                        }
                        MouseListenerSvg.this.kinDiagramPanel.clearProgressBar();
                    }
                    ((MouseListenerSvg)MouseListenerSvg.this).graphPanel.svgUpdateHandler.relationDragHandle = null;
                    MouseListenerSvg.this.updateSelectionDisplay();
                }
            }).start();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.kinDiagramPanel.verifyDiagramDataLoaded()) {
            return;
        }
        this.mouseActionIsDrag = false;
        this.mouseActionIsPopupTrigger = e.isPopupTrigger();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
    }

    @Override
    public void handleEvent(Event evt) {
        if (!this.kinDiagramPanel.verifyDiagramDataLoaded()) {
            return;
        }
        this.mouseActionOnNode = true;
        boolean shiftDown = false;
        if (evt instanceof DOMMouseEvent) {
            shiftDown = ((DOMMouseEvent)evt).getShiftKey();
        }
        System.out.println("dom mouse event: " + evt.getCurrentTarget());
        Element currentDraggedElement = (Element)((Object)evt.getCurrentTarget());
        this.preDragCursor = this.graphPanel.svgCanvas.getCursor();
        String handleTypeString = currentDraggedElement.getAttribute("handletype");
        String targetIdString = currentDraggedElement.getAttribute("target");
        if (targetIdString != null && targetIdString.length() > 0 || handleTypeString != null && handleTypeString.length() > 0) {
            if (evt instanceof DOMMouseEvent) {
                SVGMatrix draggedElementScreenMatrix = ((SVGLocatable)currentDraggedElement).getScreenCTM();
                SVGMatrix draggedElementMatrix = this.graphPanel.doc.getRootElement().getTransformToElement((SVGElement)currentDraggedElement);
                float scaleFactor = draggedElementScreenMatrix.inverse().getA();
                float xTranslate = draggedElementMatrix.getE();
                float yTranslate = draggedElementMatrix.getF();
                if (targetIdString != null && targetIdString.length() > 0) {
                    this.graphPanel.svgUpdateHandler.relationDragHandle = new GraphicsDragHandle(this.graphPanel.doc.getElementById(targetIdString), currentDraggedElement, (Element)currentDraggedElement.getParentNode().getFirstChild(), Float.valueOf(currentDraggedElement.getAttribute("cx")).floatValue(), Float.valueOf(currentDraggedElement.getAttribute("cy")).floatValue(), ((DOMMouseEvent)evt).getClientX(), ((DOMMouseEvent)evt).getClientY(), scaleFactor);
                } else {
                    RelationTypeDefinition customTypeDefinition = null;
                    DataTypes.RelationType relationType = null;
                    if (handleTypeString.startsWith("custom:")) {
                        String[] handleParts = handleTypeString.split(":");
                        relationType = DataTypes.RelationType.valueOf(handleParts[1]);
                        int typeHashCode = Integer.parseInt(handleParts[2]);
                        for (RelationTypeDefinition currentDefinition : this.graphPanel.dataStoreSvg.getRelationTypeDefinitions()) {
                            if (currentDefinition.hashCode() != typeHashCode) continue;
                            customTypeDefinition = currentDefinition;
                            break;
                        }
                    } else {
                        relationType = DataTypes.RelationType.valueOf(handleTypeString);
                    }
                    this.graphPanel.svgUpdateHandler.relationDragHandle = new RelationDragHandle(customTypeDefinition, relationType, Float.valueOf(currentDraggedElement.getAttribute("cx")).floatValue() - xTranslate, Float.valueOf(currentDraggedElement.getAttribute("cy")).floatValue() - yTranslate, ((DOMMouseEvent)evt).getClientX(), ((DOMMouseEvent)evt).getClientY(), scaleFactor);
                }
            }
        } else {
            String attributeString = currentDraggedElement.getAttribute("id");
            try {
                UniqueIdentifier entityIdentifier = new UniqueIdentifier(attributeString);
                System.out.println("entityPath: " + entityIdentifier.getAttributeIdentifier());
                boolean nodeAlreadySelected = this.graphPanel.selectedGroupId.contains(entityIdentifier);
                if (!shiftDown && !nodeAlreadySelected) {
                    System.out.println("Clear selection");
                    this.graphPanel.selectedGroupId.clear();
                    this.graphPanel.selectedGroupId.add(entityIdentifier);
                } else if (shiftDown && nodeAlreadySelected) {
                    this.entityToToggle = entityIdentifier;
                } else if (!nodeAlreadySelected) {
                    this.graphPanel.selectedGroupId.add(entityIdentifier);
                }
                this.updateSelectionDisplay();
            }
            catch (IdentifierException exception) {
                BugCatcherManager.getBugCatcher().logError((Exception)exception);
                this.dialogHandler.addMessageDialogToQueue("Failed to read selection identifier, selection might not be correct", "Selection Highlight");
            }
        }
    }

    protected void updateSelectionDisplay() {
        this.graphPanel.svgUpdateHandler.updateSvgSelectionHighlights();
        if (this.graphPanel.metadataPanel != null) {
            this.graphPanel.metadataPanel.removeAllArbilDataNodeRows();
            ArrayList<UniqueIdentifier> remainingEditors = new ArrayList<UniqueIdentifier>(this.shownGraphicsEditors.keySet());
            ArrayList<EntityData> selectedEntities = new ArrayList<EntityData>();
            for (UniqueIdentifier currentSelectedId : this.graphPanel.selectedGroupId) {
                EntityData currentSelectedEntity;
                remainingEditors.remove(currentSelectedId);
                if (currentSelectedId.isGraphicsIdentifier()) {
                    if (this.shownGraphicsEditors.containsKey(currentSelectedId)) continue;
                    Element graphicsElement = this.graphPanel.doc.getElementById(currentSelectedId.getAttributeIdentifier());
                    SvgElementEditor elementEditor = new SvgElementEditor(this.graphPanel.svgCanvas.getUpdateManager(), graphicsElement);
                    this.graphPanel.metadataPanel.addTab("Graphics Editor", elementEditor);
                    this.shownGraphicsEditors.put(currentSelectedId, elementEditor);
                    continue;
                }
                if (currentSelectedId.isTransientIdentifier() || (currentSelectedEntity = this.graphPanel.getEntityForElementId(currentSelectedId)) == null) continue;
                selectedEntities.add(currentSelectedEntity);
                this.graphPanel.metadataPanel.addEntityDataNode(currentSelectedEntity);
            }
            for (UniqueIdentifier remainingIdentifier : remainingEditors) {
                this.graphPanel.metadataPanel.removeTab(this.shownGraphicsEditors.get(remainingIdentifier));
                this.shownGraphicsEditors.remove(remainingIdentifier);
            }
            this.graphPanel.metadataPanel.updateEditorPane();
        }
    }

    private void expandSelectionByRelations(int maxCount, EntityData currentEntity, HashSet<UniqueIdentifier> selectedIds, boolean addRecursively) {
        if (maxCount <= selectedIds.size()) {
            return;
        }
        for (EntityData alterNode : currentEntity.getVisiblyRelated()) {
            if (!alterNode.isVisible || selectedIds.contains(alterNode.getUniqueIdentifier())) continue;
            selectedIds.add(alterNode.getUniqueIdentifier());
            if (!addRecursively) continue;
            this.expandSelectionByRelations(maxCount, alterNode, selectedIds, addRecursively);
        }
    }

    public void performMenuAction(ActionCode commandCode) {
        System.out.println("commandCode: " + commandCode.name());
        boolean addRecursively = true;
        switch (commandCode) {
            case selectAll: {
                this.graphPanel.selectedGroupId.clear();
                for (EntityData currentEntity : this.graphPanel.dataStoreSvg.graphData.getDataNodes()) {
                    if (!currentEntity.isVisible || this.graphPanel.selectedGroupId.contains(currentEntity.getUniqueIdentifier())) continue;
                    this.graphPanel.selectedGroupId.add(currentEntity.getUniqueIdentifier());
                }
                break;
            }
            case expandSelection: {
                addRecursively = false;
            }
            case selectRelated: {
                HashSet<UniqueIdentifier> selectedIds = new HashSet<UniqueIdentifier>(this.graphPanel.selectedGroupId);
                for (EntityData currentEntity : this.graphPanel.dataStoreSvg.graphData.getDataNodes()) {
                    if (!currentEntity.isVisible || !this.graphPanel.selectedGroupId.contains(currentEntity.getUniqueIdentifier())) continue;
                    this.expandSelectionByRelations(this.graphPanel.dataStoreSvg.graphData.getDataNodes().length, currentEntity, selectedIds, addRecursively);
                }
                this.graphPanel.selectedGroupId.clear();
                this.graphPanel.selectedGroupId.addAll(selectedIds);
                break;
            }
            case deselectAll: {
                this.graphPanel.selectedGroupId.clear();
            }
        }
        this.updateSelectionDisplay();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ActionCode {
        selectAll,
        selectRelated,
        expandSelection,
        deselectAll;

    }
}

