/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg.relationlines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kindata.RelationTypeDefinition;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.svg.OldFormatException;
import nl.mpi.kinnate.svg.relationlines.LineLookUpTable;
import nl.mpi.kinnate.svg.relationlines.RelationRecord;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationRecordTable {
    HashMap<String, RelationRecord> recordStore = new HashMap();
    LineLookUpTable lineLookUpTable;
    ArrayList<String> doneRelations = new ArrayList();

    public void addRecord(GraphPanel graphPanel, EntityData entityData, EntityRelation entityRelation, int hSpacing, int vSpacing, int lineWidth) throws OldFormatException {
        EntityData rightEntity;
        EntityData leftEntity;
        DataTypes.RelationType directedRelation = entityRelation.getRelationType();
        if (entityRelation.getRelationType() == DataTypes.RelationType.descendant) {
            directedRelation = DataTypes.getOpposingRelationType(entityRelation.getRelationType());
            leftEntity = entityRelation.getAlterNode();
            rightEntity = entityData;
        } else if (entityRelation.getRelationType() == DataTypes.RelationType.ancestor) {
            leftEntity = entityData;
            rightEntity = entityRelation.getAlterNode();
        } else if (entityRelation.getRelationType() == DataTypes.RelationType.directedin) {
            directedRelation = DataTypes.getOpposingRelationType(entityRelation.getRelationType());
            leftEntity = entityRelation.getAlterNode();
            rightEntity = entityData;
        } else if (entityRelation.getRelationType() == DataTypes.RelationType.directedout) {
            leftEntity = entityData;
            rightEntity = entityRelation.getAlterNode();
        } else if (entityData.getUniqueIdentifier().getQueryIdentifier().compareTo(entityRelation.getAlterNode().getUniqueIdentifier().getQueryIdentifier()) > 0) {
            leftEntity = entityRelation.getAlterNode();
            rightEntity = entityData;
        } else {
            leftEntity = entityData;
            rightEntity = entityRelation.getAlterNode();
        }
        String compoundIdentifier = directedRelation == DataTypes.RelationType.ancestor ? "commonparent:" + leftEntity.getUniqueIdentifier().getQueryIdentifier() + directedRelation.name() + ":" + entityRelation.dcrType + ":" + entityRelation.customType : leftEntity.getUniqueIdentifier().getQueryIdentifier() + rightEntity.getUniqueIdentifier().getQueryIdentifier() + directedRelation.name() + ":" + entityRelation.dcrType + ":" + entityRelation.customType;
        if (!this.doneRelations.contains(compoundIdentifier)) {
            boolean skipSiblingRelation = false;
            String groupId = this.getGroupId(entityData, entityRelation);
            if (entityRelation.getRelationType() == DataTypes.RelationType.sibling) {
                String siblingGroupId = this.getGroupId(entityData, entityRelation);
                boolean bl = skipSiblingRelation = groupId != null && groupId.equals(siblingGroupId);
            }
            if (!skipSiblingRelation) {
                this.doneRelations.add(compoundIdentifier);
                String lineColour = entityRelation.lineColour;
                String labelString = null;
                RelationTypeDefinition.CurveLineOrientation curveLineOrientation = RelationTypeDefinition.CurveLineOrientation.horizontal;
                int lineDash = 0;
                if (lineColour == null) {
                    for (RelationTypeDefinition relationTypeDefinition : graphPanel.dataStoreSvg.getRelationTypeDefinitions()) {
                        if (!relationTypeDefinition.matchesType(entityRelation)) continue;
                        lineColour = relationTypeDefinition.getLineColour();
                        lineWidth = relationTypeDefinition.getLineWidth();
                        curveLineOrientation = relationTypeDefinition.getCurveLineOrientation();
                        lineDash = relationTypeDefinition.getLineDash();
                        labelString = relationTypeDefinition.getDisplayName();
                        break;
                    }
                }
                if (entityRelation.labelString != null) {
                    labelString = labelString == null ? entityRelation.labelString : labelString + " : " + entityRelation.labelString;
                }
                RelationRecord relationRecord = new RelationRecord(groupId, graphPanel, this.size(), leftEntity, rightEntity, directedRelation, lineWidth, lineDash, curveLineOrientation, lineColour, labelString, hSpacing, vSpacing);
                this.recordStore.put(relationRecord.lineIdString, relationRecord);
            }
        }
    }

    public String getGroupId(EntityData currentNode, EntityRelation graphLinkNode) {
        if (!DataTypes.isSanguinLine(graphLinkNode.getRelationType())) {
            return null;
        }
        ArrayList<String> parentIdList = new ArrayList<String>();
        if (graphLinkNode.getRelationType() == DataTypes.RelationType.union) {
            parentIdList.add(currentNode.getUniqueIdentifier().getAttributeIdentifier());
            if (!parentIdList.contains(graphLinkNode.alterUniqueIdentifier.getAttributeIdentifier())) {
                parentIdList.add(graphLinkNode.alterUniqueIdentifier.getAttributeIdentifier());
            }
        } else {
            EntityData childNode = graphLinkNode.getRelationType() != DataTypes.RelationType.descendant ? currentNode : graphLinkNode.getAlterNode();
            for (EntityRelation egosRelation : childNode.getAllRelations()) {
                if (egosRelation.getRelationType() != DataTypes.RelationType.ancestor || egosRelation.getAlterNode() == null || !egosRelation.getAlterNode().isVisible || parentIdList.contains(egosRelation.alterUniqueIdentifier.getAttributeIdentifier())) continue;
                parentIdList.add(egosRelation.alterUniqueIdentifier.getAttributeIdentifier());
            }
        }
        if (parentIdList.isEmpty()) {
            return null;
        }
        Collections.sort(parentIdList);
        return parentIdList.toString();
    }

    public RelationRecord getRecord(String idString) {
        return this.recordStore.get(idString);
    }

    public Collection<RelationRecord> getAllRecords() {
        return this.recordStore.values();
    }

    public ArrayList<RelationRecord> getRecordsForSelection(ArrayList<UniqueIdentifier> selectedIdentifiers) {
        ArrayList<RelationRecord> returnRecords = new ArrayList<RelationRecord>();
        HashSet<String> groupSet = new HashSet<String>();
        for (RelationRecord relationRecord : this.recordStore.values()) {
            if (!relationRecord.pertainsToEntity(selectedIdentifiers)) continue;
            returnRecords.add(relationRecord);
            groupSet.add(relationRecord.getGroupName());
        }
        for (RelationRecord relationRecord : this.recordStore.values()) {
            if (!relationRecord.belongsToGroup(groupSet)) continue;
            returnRecords.add(relationRecord);
        }
        return returnRecords;
    }

    public int size() {
        return this.recordStore.size();
    }

    public void adjustLines(GraphPanel graphPanel) throws OldFormatException {
        this.lineLookUpTable = new LineLookUpTable();
        for (RelationRecord relationRecord : this.recordStore.values()) {
            relationRecord.updatePathPoints(this.lineLookUpTable);
        }
        this.lineLookUpTable.separateLinesOverlappingEntities(graphPanel.entitySvg.getAllEntityLocations());
        this.lineLookUpTable.separateOverlappingLines();
        this.lineLookUpTable.addLoops();
    }
}

