/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.util.HashMap;
import org.basex.core.DBLocking;
import org.basex.core.Databases;
import org.basex.core.Datas;
import org.basex.core.Events;
import org.basex.core.ILocking;
import org.basex.core.MainProp;
import org.basex.core.Perm;
import org.basex.core.ProcessLocking;
import org.basex.core.Progress;
import org.basex.core.Prop;
import org.basex.core.User;
import org.basex.core.Users;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.data.Nodes;
import org.basex.index.resource.Resources;
import org.basex.io.random.TableDiskAccess;
import org.basex.query.util.pkg.Repo;
import org.basex.server.ClientListener;
import org.basex.server.Sessions;
import org.basex.util.list.StringList;

public final class Context {
    public final ClientListener listener;
    public final Prop prop = new Prop();
    public final MainProp mprop;
    public final Sessions sessions;
    public final Events events;
    public final Datas datas;
    public final Users users;
    public final Repo repo;
    public User user;
    public Nodes marked;
    public Nodes copied;
    public int focused = -1;
    private String docpath;
    private Nodes current;
    private final ILocking locks;
    private Data data;
    private Databases databases;

    public Context() {
        this(new MainProp());
    }

    public Context(HashMap<String, String> props) {
        this(new MainProp(props));
    }

    public Context(Context ctx, ClientListener cl) {
        this.mprop = ctx.mprop;
        this.datas = ctx.datas;
        this.events = ctx.events;
        this.sessions = ctx.sessions;
        this.locks = ctx.locks;
        this.users = ctx.users;
        this.repo = ctx.repo;
        this.databases = ctx.databases;
        this.listener = cl;
    }

    private Context(MainProp mp) {
        this.mprop = mp;
        this.datas = new Datas();
        this.events = new Events();
        this.sessions = new Sessions();
        this.locks = mp.is(MainProp.DBLOCKING) ? new DBLocking(mp) : new ProcessLocking(this);
        this.users = new Users(true);
        this.repo = new Repo(this);
        this.user = this.users.get("admin");
        this.databases = this.databases();
        this.listener = null;
    }

    public synchronized void close() {
        while (!this.sessions.isEmpty()) {
            ((ClientListener)this.sessions.get(0)).quit();
        }
        this.datas.close();
    }

    public boolean client() {
        return this.listener != null;
    }

    public boolean root() {
        return this.current != null && this.current.root;
    }

    public Data data() {
        return this.data;
    }

    public Nodes current() {
        if (this.current == null && this.data != null) {
            Resources res = this.data.resources;
            this.current = new Nodes((this.docpath == null ? res.docs() : res.docs(this.docpath)).toArray(), this.data);
            this.current.root = this.docpath == null;
        }
        return this.current;
    }

    public void current(Nodes curr) {
        this.current = curr;
    }

    public void openDB(Data d) {
        this.openDB(d, null);
    }

    public void openDB(Data d, String p) {
        this.data = d;
        this.docpath = p;
        this.copied = null;
        this.set(null, new Nodes(d));
    }

    public void closeDB() {
        this.data = null;
        this.copied = null;
        this.set(null, null);
    }

    public void set(Nodes curr, Nodes mark) {
        this.current = curr;
        this.marked = mark;
        this.focused = -1;
    }

    public void update() {
        this.current = null;
    }

    public void pin(Data d) {
        this.datas.add(d);
    }

    public Data pin(String name) {
        return this.datas.pin(name);
    }

    public boolean unpin(Data d) {
        return this.datas.unpin(d);
    }

    public boolean pinned(String db) {
        return this.datas.pinned(db) || TableDiskAccess.locked(db, this);
    }

    public void register(Progress pr) {
        StringList sl;
        if (!this.user.has(Perm.ADMIN)) {
            pr.startTimeout(this.mprop.num(MainProp.TIMEOUT));
        }
        if (!pr.databases(sl = new StringList())) {
            sl = this.databases.listDBs();
        } else {
            for (int d = 0; d < sl.size(); ++d) {
                if (this.data == null || !sl.get(d).isEmpty()) continue;
                sl.set(d, this.data.meta.name);
            }
        }
        this.locks.acquire(pr, sl);
    }

    public void unregister(Progress pr) {
        this.locks.release(pr);
        pr.stopTimeout();
    }

    public void add(ClientListener s) {
        this.sessions.add(s);
    }

    public void delete(ClientListener s) {
        this.sessions.remove(s);
    }

    public boolean perm(Perm p, MetaData md) {
        User us = md == null || p == Perm.CREATE || p == Perm.ADMIN ? null : md.users.get(this.user.name);
        return (us == null ? this.user : us).has(p);
    }

    public Databases databases() {
        if (this.databases == null || !this.databases.dbpath.eq(this.mprop.dbpath())) {
            this.databases = new Databases(this);
        }
        return this.databases;
    }
}

