/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.io.Reader;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Perm;
import org.basex.core.Prop;
import org.basex.core.cmd.Close;
import org.basex.data.Data;
import org.basex.index.IndexBuilder;
import org.basex.index.IndexType;
import org.basex.index.ft.FTBuilder;
import org.basex.index.value.ValueBuilder;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOStream;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public abstract class ACreate
extends Command {
    private boolean newData;

    ACreate(String ... arg) {
        this(Perm.CREATE, false, arg);
        this.newData = true;
    }

    ACreate(Perm p, boolean d, String ... arg) {
        super(p, d, arg);
    }

    @Override
    public boolean newData(Context ctx) {
        if (this.newData) {
            new Close().run(ctx);
        }
        return this.newData;
    }

    @Override
    protected boolean databases(StringList db) {
        db.add("");
        return true;
    }

    @Override
    public final boolean supportsProg() {
        return true;
    }

    @Override
    public boolean stoppable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IO sourceToIO(String name) throws IOException {
        IO io = null;
        if (this.args[1] != null && !this.args[1].isEmpty()) {
            io = IO.get(this.args[1]);
        } else if (this.in != null) {
            if (this.in.getCharacterStream() != null) {
                Reader r = this.in.getCharacterStream();
                TokenBuilder tb = new TokenBuilder();
                try {
                    int c;
                    while ((c = r.read()) != -1) {
                        tb.add(c);
                    }
                }
                finally {
                    r.close();
                }
                io = new IOContent(tb.finish());
            } else if (this.in.getByteStream() != null) {
                io = new IOStream(this.in.getByteStream());
            } else if (this.in.getSystemId() != null) {
                io = IO.get(this.in.getSystemId());
            }
        }
        if (io instanceof IOContent || io instanceof IOStream) {
            io.name(name.isEmpty() ? "" : name + '.' + this.prop.get(Prop.PARSER));
        }
        return io;
    }

    protected static void create(IndexType index, Data data, ACreate cmd) throws IOException {
        IndexBuilder ib;
        if (data.inMemory()) {
            return;
        }
        switch (index) {
            case TEXT: {
                ib = new ValueBuilder(data, true);
                break;
            }
            case ATTRIBUTE: {
                ib = new ValueBuilder(data, false);
                break;
            }
            case FULLTEXT: {
                ib = new FTBuilder(data);
                break;
            }
            default: {
                throw Util.notexpected(new Object[0]);
            }
        }
        data.closeIndex(index);
        data.setIndex(index, (cmd == null ? ib : cmd.progress(ib)).build());
    }

    protected static boolean drop(IndexType index, Data data) {
        String pat = null;
        switch (index) {
            case TEXT: {
                data.meta.textindex = false;
                pat = "txt";
                break;
            }
            case ATTRIBUTE: {
                data.meta.attrindex = false;
                pat = "atv";
                break;
            }
            case FULLTEXT: {
                data.meta.ftxtindex = false;
                pat = "ftx";
                break;
            }
        }
        data.closeIndex(index);
        data.meta.dirty = true;
        return pat == null || data.meta.drop(pat + '.');
    }
}

