/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.DiskBuilder;
import org.basex.build.Parser;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.Perm;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.AlterDB;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.Open;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.Data;
import org.basex.data.DiskData;
import org.basex.data.MetaData;
import org.basex.index.IndexType;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.serial.BuilderSerializer;
import org.basex.query.value.node.DBNode;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

public final class OptimizeAll
extends ACreate {
    int pre;
    private int size;

    public OptimizeAll() {
        super(Perm.WRITE, true, new String[0]);
    }

    @Override
    protected boolean run() {
        Data data = this.context.data();
        try {
            OptimizeAll.optimizeAll(data, this.context, this);
        }
        catch (IOException ex) {
            Util.debug(ex);
            return this.error(Util.message(ex), new Object[0]);
        }
        Open open = new Open(data.meta.name);
        return open.run(this.context) ? this.info(Text.DB_OPTIMIZED_X, data.meta.name, this.perf) : this.error(open.info(), new Object[0]);
    }

    @Override
    public boolean newData(Context ctx) {
        return true;
    }

    @Override
    protected boolean databases(StringList db) {
        db.add("");
        return true;
    }

    @Override
    public double prog() {
        return (double)this.pre / (double)this.size;
    }

    @Override
    public boolean stoppable() {
        return false;
    }

    @Override
    public String det() {
        return Text.CREATE_STATS_D;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.OPTIMIZE) + " " + "ALL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void optimizeAll(Data data, Context ctx, OptimizeAll cmd) throws IOException {
        if (data.inMemory()) {
            throw new BaseXException(Text.NO_MAINMEM, new Object[0]);
        }
        DiskData old = (DiskData)data;
        MetaData m = old.meta;
        if (cmd != null) {
            cmd.size = m.size;
        }
        if (ctx.datas.pins(m.name) > 1) {
            throw new BaseXException(Text.DB_PINNED_X, m.name);
        }
        String tname = ctx.mprop.random(m.name);
        ctx.databases().add(tname);
        ctx.prop.set(Prop.CHOP, m.chop);
        ctx.prop.set(Prop.UPDINDEX, m.updindex);
        ctx.prop.set(Prop.STEMMING, m.stemming);
        ctx.prop.set(Prop.CASESENS, m.casesens);
        ctx.prop.set(Prop.DIACRITICS, m.diacritics);
        ctx.prop.set(Prop.MAXCATS, m.maxcats);
        ctx.prop.set(Prop.MAXLEN, m.maxlen);
        ctx.prop.set(Prop.LANGUAGE, m.language.toString());
        DiskBuilder builder = new DiskBuilder(tname, new DBParser(old, cmd), ctx);
        try {
            IOFile upd;
            DiskData d = builder.build();
            if (m.createtext) {
                OptimizeAll.create(IndexType.TEXT, d, cmd);
            }
            if (m.createattr) {
                OptimizeAll.create(IndexType.ATTRIBUTE, d, cmd);
            }
            if (m.createftxt) {
                OptimizeAll.create(IndexType.FULLTEXT, d, cmd);
            }
            d.meta.createtext = m.createtext;
            d.meta.createattr = m.createattr;
            d.meta.createftxt = m.createftxt;
            d.meta.filesize = m.filesize;
            d.meta.users = m.users;
            d.meta.dirty = true;
            IOFile bin = data.meta.binaries();
            if (bin.exists()) {
                bin.rename(d.meta.binaries());
            }
            if ((upd = old.updateFile()).exists()) {
                upd.copyTo(d.updateFile());
            }
            d.close();
        }
        finally {
            try {
                builder.close();
            }
            catch (IOException ex) {
                Util.debug(ex);
            }
        }
        Close.close(data, ctx);
        if (!DropDB.drop(m.name, ctx)) {
            throw new BaseXException(Text.DB_NOT_DROPPED_X, m.name);
        }
        if (!AlterDB.alter(tname, m.name, ctx)) {
            throw new BaseXException(Text.DB_NOT_RENAMED_X, tname);
        }
    }

    private static final class DBParser
    extends Parser {
        private final DiskData data;
        final OptimizeAll cmd;

        DBParser(DiskData d, OptimizeAll c) {
            super(d.meta.original.isEmpty() ? null : IO.get(d.meta.original), d.meta.prop);
            this.data = d;
            this.cmd = c;
        }

        @Override
        public void parse(Builder build) throws IOException {
            BuilderSerializer ser = new BuilderSerializer(build){

                @Override
                protected void startOpen(byte[] t) throws IOException {
                    super.startOpen(t);
                    if (DBParser.this.cmd != null) {
                        ++DBParser.this.cmd.pre;
                    }
                }

                @Override
                public void openDoc(byte[] name) throws IOException {
                    super.openDoc(name);
                    if (DBParser.this.cmd != null) {
                        ++DBParser.this.cmd.pre;
                    }
                }
            };
            IntList il = this.data.resources.docs();
            int is = il.size();
            for (int i = 0; i < is; ++i) {
                ser.serialize(new DBNode(this.data, il.get(i)));
            }
        }
    }
}

