/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import org.basex.core.cmd.InfoStorage;
import org.basex.data.MemData;
import org.basex.data.MetaData;
import org.basex.data.NSNode;
import org.basex.data.Namespaces;
import org.basex.index.IdPreMap;
import org.basex.index.Index;
import org.basex.index.IndexType;
import org.basex.index.name.Names;
import org.basex.index.path.PathSummary;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexToken;
import org.basex.index.resource.Resources;
import org.basex.io.random.TableAccess;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;
import org.basex.util.list.IntList;

public abstract class Data {
    public static final byte DOC = 0;
    public static final byte ELEM = 1;
    public static final byte TEXT = 2;
    public static final byte ATTR = 3;
    public static final byte COMM = 4;
    public static final byte PI = 5;
    public final Resources resources = new Resources(this);
    public MetaData meta;
    public Names tagindex;
    public Names atnindex;
    public Namespaces nspaces;
    public PathSummary paths;
    public Index txtindex;
    public Index atvindex;
    public Index ftxindex;
    public int pins = 1;
    TableAccess table;
    IdPreMap idmap;
    private byte[] b = new byte[16];
    private int bp;

    public abstract void close();

    public abstract void closeIndex(IndexType var1);

    public abstract void setIndex(IndexType var1, Index var2);

    public abstract boolean startUpdate();

    public abstract void finishUpdate();

    public final IndexIterator iter(IndexToken token) {
        return this.index(token.type()).iter(token);
    }

    public final int count(IndexToken token) {
        return this.index(token.type()).count(token);
    }

    public final byte[] info(IndexType type) {
        return this.index(type).info();
    }

    final Index index(IndexType type) {
        switch (type) {
            case TAG: {
                return this.tagindex;
            }
            case ATTNAME: {
                return this.atnindex;
            }
            case TEXT: {
                return this.txtindex;
            }
            case ATTRIBUTE: {
                return this.atvindex;
            }
            case FULLTEXT: {
                return this.ftxindex;
            }
            case PATH: {
                return this.paths;
            }
        }
        throw Util.notexpected(new Object[0]);
    }

    public final byte[] atom(int pre) {
        int k;
        int p;
        switch (this.kind(pre)) {
            case 2: 
            case 4: {
                return this.text(pre, true);
            }
            case 3: {
                return this.text(pre, false);
            }
            case 5: {
                byte[] txt = this.text(pre, true);
                int i = Token.indexOf(txt, 32);
                return i == -1 ? Token.EMPTY : Token.substring(txt, i + 1);
            }
        }
        TokenBuilder tb = null;
        byte[] t = Token.EMPTY;
        int s = p + this.size(p, this.kind(p));
        for (p = pre; p != s; p += this.attSize(p, k)) {
            k = this.kind(p);
            if (k != 2) continue;
            byte[] txt = this.text(p, true);
            if (t == Token.EMPTY) {
                t = txt;
                continue;
            }
            if (tb == null) {
                tb = new TokenBuilder(t);
            }
            tb.add(txt);
        }
        return tb == null ? t : tb.finish();
    }

    final int preold(int id) {
        int p;
        for (p = Math.max(0, id); p < this.meta.size; ++p) {
            if (id != this.id(p)) continue;
            return p;
        }
        int ps = Math.min(this.meta.size, id);
        for (p = 0; p < ps; ++p) {
            if (id != this.id(p)) continue;
            return p;
        }
        return -1;
    }

    public final int pre(int id) {
        return this.meta.updindex ? this.idmap.pre(id) : this.preold(id);
    }

    public final int[] pre(int[] ids, int off, int len) {
        if (this.meta.updindex) {
            return this.idmap.pre(ids, off, len);
        }
        IntList p = new IntList(ids.length);
        for (int i = off; i < len; ++i) {
            p.add(this.preold(ids[i]));
        }
        return p.sort().toArray();
    }

    public final int id(int pre) {
        return this.table.read4(pre, 12);
    }

    public final int kind(int pre) {
        return this.table.read1(pre, 0) & 7;
    }

    public final int parent(int pre, int kind) {
        return pre - this.dist(pre, kind);
    }

    private int dist(int pre, int kind) {
        switch (kind) {
            case 1: {
                return this.table.read4(pre, 4);
            }
            case 2: 
            case 4: 
            case 5: {
                return this.table.read4(pre, 8);
            }
            case 3: {
                int d;
                if (d >= 31) {
                    for (d = this.table.read1(pre, 0) >> 3 & 0x1F; d < pre && this.kind(pre - d) == 3; ++d) {
                    }
                }
                return d;
            }
        }
        return pre + 1;
    }

    public final int size(int pre, int kind) {
        return kind == 1 || kind == 0 ? this.table.read4(pre, 8) : 1;
    }

    public final int attSize(int pre, int kind) {
        int s;
        int n = s = kind == 1 ? this.table.read1(pre, 0) >> 3 & 0x1F : 1;
        if (s >= 31) {
            while (s < this.meta.size - pre && this.kind(pre + s) == 3) {
                ++s;
            }
        }
        return s;
    }

    public final byte[] attValue(int att, int pre) {
        int a = pre + this.attSize(pre, this.kind(pre));
        int p = pre;
        while (++p != a) {
            if (this.name(p) != att) continue;
            return this.text(p, false);
        }
        return null;
    }

    public final int name(int pre) {
        return this.table.read2(pre, 1) & Short.MAX_VALUE;
    }

    public final byte[] name(int pre, int kind) {
        if (kind == 5) {
            byte[] name = this.text(pre, true);
            int i = Token.indexOf(name, 32);
            return i == -1 ? name : Token.substring(name, 0, i);
        }
        return (kind == 1 ? this.tagindex : this.atnindex).key(this.name(pre));
    }

    public final int uri(int pre, int kind) {
        return kind == 1 || kind == 3 ? this.table.read1(pre, kind == 1 ? 3 : 11) & 0xFF : 0;
    }

    public final boolean nsFlag(int pre) {
        return (this.table.read1(pre, 1) & 0x80) != 0;
    }

    public final Atts ns(int pre) {
        Atts as = new Atts();
        if (this.nsFlag(pre)) {
            int[] nsp = this.nspaces.get(pre);
            for (int n = 0; n < nsp.length; n += 2) {
                as.add(this.nspaces.prefix(nsp[n]), this.nspaces.uri(nsp[n + 1]));
            }
        }
        return as;
    }

    final long textOff(int pre) {
        return this.table.read5(pre, 3);
    }

    public abstract byte[] text(int var1, boolean var2);

    public abstract long textItr(int var1, boolean var2);

    public abstract double textDbl(int var1, boolean var2);

    public abstract int textLen(int var1, boolean var2);

    public final void update(int pre, int kind, byte[] name, byte[] uri) {
        this.meta.update();
        if (kind == 5) {
            this.updateText(pre, Token.trim(Token.concat(name, Token.SPACE, this.atom(pre))), kind);
        } else {
            int npre;
            int ouri = this.nspaces.uri(name, pre);
            boolean ne = ouri == 0 && uri.length != 0;
            int n = npre = kind == 3 ? this.parent(pre, kind) : pre;
            int nuri = ne ? this.nspaces.add(npre, npre, Token.prefix(name), uri) : (ouri != 0 && Token.eq(this.nspaces.uri(ouri), uri) ? ouri : 0);
            this.table.write1(pre, kind == 1 ? 3 : 11, nuri);
            this.table.write2(pre, 1, (this.nsFlag(pre) ? 32768 : 0) | (kind == 1 ? this.tagindex : this.atnindex).index(name, null, false));
            this.table.write2(npre, 1, (ne || this.nsFlag(npre) ? 32768 : 0) | this.name(npre));
        }
    }

    public final void update(int pre, int kind, byte[] value) {
        this.meta.update();
        this.updateText(pre, kind == 5 ? Token.trim(Token.concat(this.name(pre, kind), Token.SPACE, value)) : value, kind);
        if (kind == 0) {
            this.resources.rename(pre, value);
        }
    }

    public final void replace(int rpre, Data data) {
        this.meta.update();
        int dsize = data.meta.size;
        int rkind = this.kind(rpre);
        int rsize = this.size(rpre, rkind);
        int rpar = this.parent(rpre, rkind);
        int diff = dsize - rsize;
        this.buffer(dsize);
        this.resources.replace(rpre, rsize, data);
        if (this.meta.updindex) {
            this.indexDelete(rpre, rsize);
            this.indexBegin();
        }
        block6: for (int dpre = 0; dpre < dsize; ++dpre) {
            int dkind = data.kind(dpre);
            int dpar = data.parent(dpre, dkind);
            int pre = rpre + dpre;
            int dis = dpar >= 0 ? dpre - dpar : pre - this.parent(rpre, rkind);
            switch (dkind) {
                case 0: {
                    this.doc(pre, data.size(dpre, dkind), data.text(dpre, true));
                    ++this.meta.ndocs;
                    continue block6;
                }
                case 1: {
                    byte[] nm = data.name(dpre, dkind);
                    this.elem(dis, this.tagindex.index(nm, null, false), data.attSize(dpre, dkind), data.size(dpre, dkind), this.nspaces.uri(nm, true), false);
                    continue block6;
                }
                case 2: 
                case 4: 
                case 5: {
                    this.text(pre, dis, data.text(dpre, true), dkind);
                    continue block6;
                }
                case 3: {
                    byte[] nm = data.name(dpre, dkind);
                    this.attr(pre, dis, this.atnindex.index(nm, null, false), data.text(dpre, false), this.nspaces.uri(nm, false), false);
                }
            }
        }
        if (this.meta.updindex) {
            this.indexEnd();
            this.idmap.delete(rpre, this.id(rpre), -rsize);
            this.idmap.insert(rpre, this.meta.lastid - dsize + 1, dsize);
        }
        this.table.replace(rpre, this.buffer(), rsize);
        this.buffer(1);
        if (diff == 0) {
            return;
        }
        int p = rpar;
        while (p >= 0) {
            int k = this.kind(p);
            this.size(p, k, this.size(p, k) + diff);
            p = this.parent(p, k);
        }
        this.updateDist(rpre + dsize, diff);
        if (data.kind(0) == 3) {
            int d = 0;
            int i = 0;
            while (i < dsize && data.kind(i++) == 3) {
                ++d;
            }
            if (d > 1) {
                this.attSize(rpar, this.kind(rpar), d + 1);
            }
        }
    }

    public final void delete(int pre) {
        this.meta.update();
        int k = this.kind(pre);
        int s = this.size(pre, k);
        this.resources.delete(pre, s);
        if (this.meta.updindex) {
            this.indexDelete(pre, s);
        }
        if (k != 0 && k != 1) {
            this.delete(pre, k != 3);
        }
        this.nspaces.delete(pre, s);
        int par = pre;
        if (k == 3) {
            par = this.parent(par, 3);
            this.attSize(par, 1, this.attSize(par, 1) - 1);
            this.size(par, 1, this.size(par, 1) - 1);
            k = this.kind(par);
        }
        while (par > 0 && k != 0) {
            par = this.parent(par, k);
            k = this.kind(par);
            this.size(par, k, this.size(par, k) - s);
        }
        int p = pre;
        if (this.kind(p) == 0) {
            --this.meta.ndocs;
        }
        if (this.meta.updindex) {
            this.idmap.delete(pre, this.id(pre), -s);
        }
        this.table.delete(pre, s);
        this.updateDist(p, -s);
    }

    public final void insertAttr(int pre, int par, Data data) {
        this.insert(pre, par, data);
        this.attSize(par, 1, this.attSize(par, 1) + data.meta.size);
    }

    public final void insert(int ipre, int ipar, Data data) {
        this.meta.update();
        if (this.meta.updindex) {
            this.indexBegin();
        }
        this.resources.insert(ipre, data);
        int dsize = data.meta.size;
        int buf = Math.min(dsize, 256);
        this.buffer(buf);
        TokenMap nsScope = new TokenMap();
        NSNode n = this.nspaces.current;
        do {
            for (int i = 0; i < n.vals.length; i += 2) {
                nsScope.add(this.nspaces.prefix(n.vals[i]), this.nspaces.uri(n.vals[i + 1]));
            }
            int pos = n.fnd(ipar);
            if (pos < 0) break;
            n = n.ch[pos];
        } while (n.pre <= ipar && ipar < n.pre + this.size(n.pre, 1));
        IntList preStack = new IntList();
        int dpre = -1;
        NSNode t = this.nspaces.current;
        HashSet<NSNode> newNodes = new HashSet<NSNode>();
        IntList flagPres = new IntList();
        while (++dpre != dsize) {
            int par;
            if (dpre != 0 && dpre % buf == 0) {
                this.insert(ipre + dpre - buf);
            }
            int pre = ipre + dpre;
            int dkind = data.kind(dpre);
            int dpar = data.parent(dpre, dkind);
            int dis = dpar >= 0 ? dpre - dpar : (ipar >= 0 ? pre - ipar : 0);
            int n2 = par = dis == 0 ? -1 : pre - dis;
            if (dpre == 0) {
                int cI;
                LinkedList<NSNode> cand = new LinkedList<NSNode>();
                NSNode cn = this.nspaces.root;
                cand.add(cn);
                while ((cI = cn.fnd(par)) > -1) {
                    cn = cn.ch[cI];
                    cand.add(0, cn);
                }
                cn = this.nspaces.root;
                if (cand.size() > 1) {
                    int ancPre = par;
                    NSNode curr = (NSNode)cand.remove(0);
                    while (ancPre > -1 && cn == this.nspaces.root) {
                        if (curr.pre == ancPre) {
                            cn = curr;
                        } else if (curr.pre < ancPre) {
                            while ((ancPre = this.parent(ancPre, this.kind(ancPre))) > curr.pre) {
                            }
                            if (curr.pre == ancPre) {
                                cn = curr;
                            }
                        }
                        if (cand.isEmpty()) continue;
                        curr = (NSNode)cand.remove(0);
                    }
                }
                this.nspaces.setNearestRoot(cn, par);
            }
            while (!preStack.isEmpty() && preStack.peek() > par) {
                this.nspaces.close(preStack.pop());
            }
            switch (dkind) {
                case 0: {
                    int s = data.size(dpre, dkind);
                    this.doc(pre, s, data.text(dpre, true));
                    ++this.meta.ndocs;
                    this.nspaces.open();
                    preStack.push(pre);
                    break;
                }
                case 1: {
                    boolean ne = false;
                    if (data.nsFlag(dpre)) {
                        Atts at = data.ns(dpre);
                        for (int a = 0; a < at.size(); ++a) {
                            byte[] old = nsScope.get(at.name(a));
                            if (old != null && Token.eq(old, at.string(a))) continue;
                            newNodes.add(this.nspaces.add(at.name(a), at.string(a), pre));
                            ne = true;
                        }
                    }
                    this.nspaces.open();
                    byte[] nm = data.name(dpre, dkind);
                    this.elem(dis, this.tagindex.index(nm, null, false), data.attSize(dpre, dkind), data.size(dpre, dkind), this.nspaces.uri(nm, true), ne);
                    preStack.push(pre);
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    this.text(pre, dis, data.text(dpre, true), dkind);
                    break;
                }
                case 3: {
                    byte[] nm = data.name(dpre, dkind);
                    byte[] attPref = Token.prefix(nm);
                    if (data.nsFlag(dpre) && nsScope.get(attPref) == null) {
                        this.nspaces.add(par, preStack.size() == 0 ? -1 : preStack.peek(), attPref, data.nspaces.uri(data.uri(dpre, dkind)));
                        flagPres.add(par);
                    }
                    this.attr(pre, dis, this.atnindex.index(nm, null, false), data.text(dpre, false), this.nspaces.uri(nm, false), false);
                }
            }
        }
        while (!preStack.isEmpty()) {
            this.nspaces.close(preStack.pop());
        }
        this.nspaces.setRoot(t);
        if (ipar != -1) {
            this.nspaces.insert(ipre, dsize, newNodes);
        }
        if (this.bp != 0) {
            this.insert(ipre + dpre - 1 - (dpre - 1) % buf);
        }
        this.buffer(1);
        for (int f = 0; f < flagPres.size(); ++f) {
            int fl = flagPres.get(f);
            this.table.write2(fl, 1, this.name(fl) | 0x8000);
        }
        int p = ipar;
        while (p >= 0) {
            int k = this.kind(p);
            this.size(p, k, this.size(p, k) + dsize);
            p = this.parent(p, k);
        }
        this.updateDist(ipre + dsize, dsize);
        if (this.meta.updindex) {
            this.idmap.insert(ipre, this.id(ipre), dsize);
            this.indexEnd();
        }
    }

    private void updateDist(int pre, int size) {
        int k;
        for (int p = pre; p < this.meta.size && (k = this.kind(p)) != 0; p += this.size(p, k)) {
            this.dist(p, k, this.dist(p, k) + size);
        }
    }

    public final void size(int pre, int kind, int value) {
        if (kind == 1 || kind == 0) {
            this.table.write4(pre, 8, value);
        }
    }

    final void textOff(int pre, long off) {
        this.table.write5(pre, 3, off);
    }

    protected abstract void updateText(int var1, byte[] var2, int var3);

    private void dist(int pre, int kind, int value) {
        if (kind == 3) {
            this.table.write1(pre, 0, value << 3 | 3);
        } else if (kind != 0) {
            this.table.write4(pre, kind == 1 ? 4 : 8, value);
        }
    }

    private void attSize(int pre, int kind, int value) {
        if (kind == 1) {
            this.table.write1(pre, 0, value << 3 | 1);
        }
    }

    public final void nsFlag(int pre, boolean ne) {
        this.table.write1(pre, 1, this.table.read1(pre, 1) & 0x7F | (ne ? 128 : 0));
    }

    public final void insert(int pre) {
        this.table.insert(pre, this.buffer());
    }

    protected abstract void delete(int var1, boolean var2);

    final void buffer(int size) {
        int bs = size << 4;
        if (this.b.length != bs) {
            this.b = new byte[bs];
        }
    }

    public final void doc(int pre, int size, byte[] value) {
        int i = this.newID();
        long v = this.index(pre, i, value, 0);
        this.s(0);
        this.s(0);
        this.s(0);
        this.s(v >> 32);
        this.s(v >> 24);
        this.s(v >> 16);
        this.s(v >> 8);
        this.s(v);
        this.s(size >> 24);
        this.s(size >> 16);
        this.s(size >> 8);
        this.s(size);
        this.s(i >> 24);
        this.s(i >> 16);
        this.s(i >> 8);
        this.s(i);
    }

    public final void elem(int dist, int name, int asize, int size, int uri, boolean ne) {
        int i = this.newID();
        int n = ne ? 128 : 0;
        this.s(Math.min(31, asize) << 3 | 1);
        this.s(n | (byte)(name >> 8));
        this.s(name);
        this.s(uri);
        this.s(dist >> 24);
        this.s(dist >> 16);
        this.s(dist >> 8);
        this.s(dist);
        this.s(size >> 24);
        this.s(size >> 16);
        this.s(size >> 8);
        this.s(size);
        this.s(i >> 24);
        this.s(i >> 16);
        this.s(i >> 8);
        this.s(i);
    }

    public final void text(int pre, int dist, byte[] value, int kind) {
        int i = this.newID();
        long v = this.index(pre, i, value, kind);
        this.s(kind);
        this.s(0);
        this.s(0);
        this.s(v >> 32);
        this.s(v >> 24);
        this.s(v >> 16);
        this.s(v >> 8);
        this.s(v);
        this.s(dist >> 24);
        this.s(dist >> 16);
        this.s(dist >> 8);
        this.s(dist);
        this.s(i >> 24);
        this.s(i >> 16);
        this.s(i >> 8);
        this.s(i);
    }

    public final void attr(int pre, int dist, int name, byte[] value, int uri, boolean ne) {
        int i = this.newID();
        long v = this.index(pre, i, value, 3);
        int n = ne ? 128 : 0;
        this.s(Math.min(31, dist) << 3 | 3);
        this.s(n | (byte)(name >> 8));
        this.s(name);
        this.s(v >> 32);
        this.s(v >> 24);
        this.s(v >> 16);
        this.s(v >> 8);
        this.s(v);
        this.s(0);
        this.s(0);
        this.s(0);
        this.s(uri);
        this.s(i >> 24);
        this.s(i >> 16);
        this.s(i >> 8);
        this.s(i);
    }

    private void s(int value) {
        this.b[this.bp++] = (byte)value;
    }

    private int newID() {
        return ++this.meta.lastid;
    }

    private void s(long value) {
        this.b[this.bp++] = (byte)value;
    }

    private byte[] buffer() {
        byte[] bb = this.bp == this.b.length ? this.b : Arrays.copyOf(this.b, this.bp);
        this.bp = 0;
        return bb;
    }

    protected abstract long index(int var1, int var2, byte[] var3, int var4);

    void indexBegin() {
    }

    void indexEnd() {
    }

    protected abstract void indexDelete(int var1, int var2);

    public final boolean inMemory() {
        return this instanceof MemData;
    }

    final String toString(int start, int end) {
        return Token.string(InfoStorage.table(this, start, end));
    }

    public final String toString() {
        int max = 20;
        return this.meta.size > 20 ? this.toString(0, 20) + "..." : this.toString(0, this.meta.size);
    }
}

