/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import org.basex.core.Text;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.Optimize;
import org.basex.data.MetaData;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.DialogImport;
import org.basex.gui.dialog.DialogParsing;
import org.basex.gui.dialog.DialogProgress;
import org.basex.gui.dialog.DialogProps;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTabs;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.util.Util;

class DialogAdd
extends BaseXBack {
    final DialogProps dialog;
    final BaseXTextField target;
    private final DialogImport general;
    private final BaseXButton add;
    private final BaseXButton optimize;

    public DialogAdd(DialogProps d) {
        this.dialog = d;
        this.setLayout(new BorderLayout());
        this.add((Component)new BaseXLabel(Text.ADD_RESOURCES).large().border(0, 0, 16, 0), "North");
        this.target = new BaseXTextField("/", d);
        BaseXBack pnl = new BaseXBack(new TableLayout(2, 1));
        pnl.add(new BaseXLabel(Text.TARGET_PATH + ": ", true, true).border(8, 0, 6, 0));
        pnl.add(this.target);
        BaseXTabs tabs = new BaseXTabs(d);
        DialogParsing parsing = new DialogParsing(d, tabs);
        this.general = new DialogImport(d, pnl, parsing);
        tabs.addTab(Text.GENERAL, this.general);
        tabs.addTab(Text.PARSING, parsing);
        this.add((Component)tabs, "Center");
        this.add = new BaseXButton(Text.ADD + "...", d);
        this.optimize = new BaseXButton(Text.OPTIMIZE + "...", d);
        this.add((Component)d.newButtons(this.add, this.optimize), "South");
        this.action(this.general.parser);
    }

    void action(Object comp) {
        String src = this.general.input();
        final String trg = this.target.getText().trim();
        if (comp == this.add) {
            this.general.setOptions();
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    DialogAdd.this.dialog.resources.refreshNewFolder(trg);
                }
            };
            DialogProgress.execute((BaseXDialog)this.dialog, run, new Add(trg, src));
        } else if (comp == this.optimize) {
            DialogProgress.execute((BaseXDialog)this.dialog, new Optimize());
        } else {
            boolean ok = this.general.action(comp, false);
            if (comp == this.general.browse || comp == this.general.input) {
                this.target.setText(this.general.dbname);
            }
            String inf = !ok ? Text.RES_NOT_FOUND : (!ok ? Text.ENTER_DB_NAME : null);
            GUIConstants.Msg icon = GUIConstants.Msg.ERROR;
            if (ok) {
                boolean bl = ok = MetaData.normPath(trg) != null;
                if (!ok) {
                    inf = Util.info(Text.INVALID_X, Text.TARGET_PATH);
                }
            }
            this.general.info.setText(inf, icon);
            this.add.setEnabled(ok);
            this.optimize.setEnabled(!this.dialog.gui.context.data().meta.uptodate);
        }
    }
}

