/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.Language;
import org.basex.util.list.StringList;

final class DialogFT
extends BaseXBack {
    private static final int F_LANG = 0;
    private static final int F_STEM = 1;
    private static final int F_CASE = 2;
    private static final int F_DIA = 3;
    private static final int F_STOP = 4;
    private static final int FLAGS = 5;
    private final BaseXDialog dialog;
    private final BaseXCheckBox[] check = new BaseXCheckBox[5];
    private final BaseXLabel[] labels = new BaseXLabel[5];
    private final BaseXCombo language;
    private final BaseXTextField swpath;
    private final BaseXButton swbrowse;

    DialogFT(BaseXDialog d, boolean create) {
        this.dialog = d;
        this.layout(new TableLayout(create ? 9 : 15, 1));
        Prop prop = d.gui.context.prop;
        this.add(new BaseXLabel(Text.H_FULLTEXT_INDEX, true, false).border(0, 0, 6, 0));
        String sw = prop.get(Prop.STOPWORDS);
        String[] cb = new String[]{Text.LANGUAGE, Text.STEMMING, Text.CASE_SENSITIVITY, Text.DIACRITICS, Text.STOPWORD_LIST};
        String[] desc = new String[]{Text.H_LANGUAGE, Text.H_STEMMING, Text.H_CASE, Text.H_DIACRITICS, Text.H_STOPWORDS};
        boolean[] val = new boolean[]{!prop.get(Prop.LANGUAGE).isEmpty(), prop.is(Prop.STEMMING), prop.is(Prop.CASESENS), prop.is(Prop.DIACRITICS), !sw.isEmpty()};
        for (int f = 0; f < this.check.length; ++f) {
            this.check[f] = new BaseXCheckBox(cb[f], val[f], create ? 1 : 0, d);
            if (!create) {
                this.labels[f] = new BaseXLabel(desc[f], true, false);
                continue;
            }
            this.check[f].setToolTipText(desc[f]);
        }
        BaseXBack b1 = new BaseXBack(new TableLayout(1, 2, 8, 0));
        b1.add(this.check[0]);
        StringList langs = FTLexer.languages();
        this.language = new BaseXCombo(d, langs.toArray());
        Language ln = Language.get(prop);
        for (String l : langs) {
            String s = l.replaceFirst(" \\(.*", "");
            if (!s.equals(ln.toString())) continue;
            this.language.setSelectedItem(l);
        }
        b1.add(this.language);
        this.add(b1);
        if (!create) {
            this.add(this.labels[0]);
        }
        for (int f = 1; f < 4; ++f) {
            this.add(this.check[f]);
            if (create) continue;
            this.add(this.labels[f]);
        }
        this.add(this.check[4]);
        this.add(Box.createVerticalStrut(4));
        BaseXBack b3 = new BaseXBack(new TableLayout(1, 2, 8, 0));
        this.swpath = new BaseXTextField(sw.isEmpty() ? d.gui.gprop.get(GUIProp.STOPPATH) : sw, d);
        b3.add(this.swpath);
        this.swbrowse = new BaseXButton(Text.BROWSE_D, d);
        this.swbrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogFT.this.chooseStop();
            }
        });
        b3.add(this.swbrowse);
        this.add(b3);
        if (!create) {
            this.add(this.labels[4]);
        }
    }

    void chooseStop() {
        GUIProp gprop = this.dialog.gui.gprop;
        BaseXFileChooser fc = new BaseXFileChooser(Text.FILE_OR_DIR, gprop.get(GUIProp.STOPPATH), this.dialog.gui);
        IOFile file = fc.select(BaseXFileChooser.Mode.FOPEN);
        if (file != null) {
            this.swpath.setText(file.path());
            gprop.set(GUIProp.STOPPATH, file.path());
        }
    }

    void action(boolean enabled) {
        boolean exists;
        for (BaseXCheckBox c : this.check) {
            c.setEnabled(enabled);
        }
        this.language.setEnabled(enabled && this.check[0].isSelected());
        this.swbrowse.setEnabled(enabled && this.check[4].isSelected());
        this.swpath.setEnabled(enabled && this.check[4].isSelected());
        String sw = this.swpath.getText().trim();
        IO file = IO.get(sw);
        boolean bl = exists = !sw.isEmpty() && file.exists();
        if (exists) {
            this.dialog.gui.gprop.set(GUIProp.STOPPATH, sw);
        }
    }

    void setOptions() {
        GUI gui = this.dialog.gui;
        String lang = this.language.getSelectedItem().toString();
        gui.set(Prop.LANGUAGE, this.check[0].isSelected() ? Language.get(lang.replaceFirst(" \\(.*", "")).toString() : "");
        gui.set(Prop.STEMMING, this.check[1].isSelected());
        gui.set(Prop.CASESENS, this.check[2].isSelected());
        gui.set(Prop.DIACRITICS, this.check[3].isSelected());
        gui.set(Prop.STOPWORDS, this.check[4].isSelected() ? this.swpath.getText() : "");
    }
}

