/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import org.basex.gui.layout.BaseXSyntax;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class BaseXTextTokens {
    static final int TAB = 2;
    private byte[] text = Token.EMPTY;
    private int ps;
    private int pe;
    private int pc;
    private int ms = -1;
    private int me = -1;
    private int es = -1;

    BaseXTextTokens(byte[] t) {
        this.text = t;
    }

    void init() {
        this.ps = 0;
        this.pe = 0;
    }

    boolean moreWords() {
        if (this.pe >= this.text.length) {
            return false;
        }
        this.ps = this.pe;
        int ch = Token.cp(this.text, this.ps);
        this.pe += Token.cl(this.text, this.ps);
        if (!Token.ftChar(ch)) {
            return true;
        }
        while (this.pe < this.text.length && Token.ftChar(ch = Token.cp(this.text, this.pe))) {
            this.pe += Token.cl(this.text, this.pe);
        }
        return true;
    }

    public String nextWord() {
        return Token.string(this.text, this.ps, this.pe - this.ps);
    }

    int length() {
        return this.pe - this.ps;
    }

    int next(boolean mark) {
        return this.noMark(mark, true) ? this.curr() : this.next();
    }

    void nextToken(boolean mark) {
        int ch = this.next(mark);
        if (ch == 10) {
            return;
        }
        if (Character.isLetterOrDigit(ch)) {
            while (Character.isLetterOrDigit(ch)) {
                ch = this.next();
            }
            while (ch != 10 && Character.isWhitespace(ch)) {
                ch = this.next();
            }
        } else if (Character.isWhitespace(ch)) {
            while (ch != 10 && Character.isWhitespace(ch)) {
                ch = this.next();
            }
        } else {
            while (ch != 10 && !Character.isLetterOrDigit(ch) && !Character.isWhitespace(ch)) {
                ch = this.next();
            }
            while (ch != 10 && Character.isWhitespace(ch)) {
                ch = this.next();
            }
        }
        if (this.ps != this.text.length) {
            this.prev();
        }
    }

    void prevToken(boolean mark) {
        int ch = this.prev(mark);
        if (ch == 10) {
            return;
        }
        if (Character.isLetterOrDigit(ch)) {
            while (Character.isLetterOrDigit(ch)) {
                ch = this.prev();
            }
        } else if (Character.isWhitespace(ch)) {
            while (ch != 10 && Character.isWhitespace(ch)) {
                ch = this.prev();
            }
            while (Character.isLetterOrDigit(ch)) {
                ch = this.prev();
            }
        } else {
            while (ch != 10 && !Character.isLetterOrDigit(ch) && !Character.isWhitespace(ch)) {
                ch = this.prev();
            }
        }
        if (this.ps != 0) {
            this.next();
        }
    }

    boolean more() {
        return this.ps < this.pe;
    }

    public int curr() {
        return this.ps >= this.text.length ? 10 : Token.cp(this.text, this.ps);
    }

    public byte[] text() {
        return this.text;
    }

    int next() {
        int c = this.curr();
        if (this.ps < this.text.length) {
            this.ps += Token.cl(this.text, this.ps);
        }
        return c;
    }

    void pos(int p) {
        this.ps = p;
    }

    int pos() {
        return this.ps;
    }

    int bol(boolean mark) {
        int c = 0;
        if (this.ps == 0) {
            return 0;
        }
        do {
            c += this.curr() == 9 ? 2 : 1;
        } while (this.prev(mark) != 10);
        if (this.ps != 0 || this.curr() == 10) {
            this.next(mark);
        }
        return c;
    }

    void eol(boolean mark) {
        this.forward(Integer.MAX_VALUE, mark);
    }

    int prev(boolean mark) {
        return this.noMark(mark, false) ? this.curr() : this.prev();
    }

    int prev() {
        if (this.ps == 0) {
            return 10;
        }
        int p = this.ps;
        this.ps = Math.max(0, this.ps - 5);
        while (this.ps < p && this.ps + Token.cl(this.text, this.ps) < p) {
            ++this.ps;
        }
        return this.curr();
    }

    void forward(int p, boolean mark) {
        int nc = 0;
        while (this.curr() != 10) {
            if ((nc += this.curr() == 9 ? 2 : 1) >= p) {
                return;
            }
            this.next(mark);
        }
    }

    void add(String str) {
        int c;
        TokenBuilder tb = new TokenBuilder();
        tb.add(this.text, 0, this.ps);
        int cc = 0;
        int cl = str.length();
        for (c = 0; c < cl; ++c) {
            int ch = str.charAt(c);
            if (ch == 13) continue;
            if (ch < 32 && !Token.ws(ch)) {
                ch = 10;
            }
            tb.add(ch);
            ++cc;
        }
        tb.add(this.text, this.ps, this.text.length);
        this.text = tb.finish();
        for (c = 0; c < cc; ++c) {
            this.next();
        }
    }

    void indent(int s, int e, boolean sh) {
        this.pos(s);
        this.bol(true);
        this.startMark();
        this.pos(e);
        this.forward(Integer.MAX_VALUE, true);
        this.next(true);
        this.endMark();
        boolean tab = false;
        int pl = this.text.length;
        for (int p = 0; p < pl; ++p) {
            tab |= this.text[p] == 9;
        }
        byte[] add = new byte[]{9};
        if (!tab) {
            add = new byte[2];
            for (int a = 0; a < 2; ++a) {
                add[a] = 32;
            }
        }
        TokenBuilder tb = new TokenBuilder();
        tb.add(this.text, 0, this.ms);
        for (int p = this.ms; p < this.ps; p += Token.cl(this.text, p)) {
            if (p == 0 || this.text[p - 1] == 10) {
                if (sh) {
                    if (this.text[p] == 9) {
                        --this.me;
                        continue;
                    }
                    if (this.text[p] == 32) {
                        --this.me;
                        for (int i = 1; i < 2 && p + i < pl && this.text[p + i] == 32; ++i) {
                            --this.me;
                            ++p;
                        }
                        continue;
                    }
                } else {
                    tb.add(add);
                    this.me += add.length;
                }
            }
            tb.add(Token.cp(this.text, p));
        }
        tb.add(this.text, this.ps, this.text.length);
        this.ps = this.me;
        this.text = tb.finish();
    }

    void comment(BaseXSyntax syntax) {
        int min;
        byte[] start = syntax.commentOpen();
        byte[] end = syntax.commentEnd();
        boolean add = true;
        int max = this.ps;
        if (this.marked()) {
            min = this.ps < this.ms ? this.ps : this.ms;
            max = this.ps > this.ms ? this.ps : this.ms;
            int mn = Math.max(min + start.length, max - end.length);
            if (Token.indexOf(this.text, start, min) == min && Token.indexOf(this.text, end, mn) == mn) {
                TokenBuilder tb = new TokenBuilder();
                tb.add(this.text, 0, min);
                tb.add(this.text, min + start.length, max - end.length);
                tb.add(this.text, max, this.text.length);
                this.text = tb.finish();
                this.ms = min;
                this.ps = this.me = max - start.length - end.length;
                add = false;
            }
        } else {
            for (min = this.ps; min > 0 && this.text[min - 1] != 10; --min) {
            }
            while (max < this.size() && this.text[max] != 10) {
                ++max;
            }
        }
        if (add) {
            this.pos(max);
            this.add(Token.string(end));
            this.pos(min);
            this.add(Token.string(start));
            this.ms = min;
            this.ps = this.me = max + start.length + end.length;
        }
    }

    void delete() {
        if (this.text.length == 0) {
            return;
        }
        TokenBuilder tb = new TokenBuilder();
        int s = this.marked() ? Math.min(this.ms, this.me) : this.ps;
        int e = this.marked() ? Math.max(this.ms, this.me) : this.ps + Token.cl(this.text, this.ps);
        tb.add(this.text, 0, s);
        if (e < this.text.length) {
            tb.add(this.text, e, this.text.length);
        }
        this.text = tb.finish();
        this.ps = s;
        this.noMark();
    }

    void deleteLine() {
        this.bol(false);
        this.startMark();
        this.eol(true);
        this.next(true);
        this.endMark();
        this.delete();
    }

    private boolean noMark(boolean mark, boolean max) {
        boolean rs;
        boolean bl = rs = !mark && this.marked();
        if (rs) {
            this.ps = max ^ this.ms < this.me ? this.ms : this.me;
            this.noMark();
        }
        return rs;
    }

    void noMark() {
        this.ms = -1;
        this.me = -1;
    }

    void startMark() {
        this.ms = this.ps;
        this.me = this.ps;
    }

    void endMark() {
        this.me = this.ps;
    }

    int start() {
        return this.ms;
    }

    boolean marked() {
        return this.ms != -1;
    }

    void checkMark() {
        if (this.ms == this.me) {
            this.noMark();
        }
    }

    boolean markStart() {
        return this.marked() && (this.inMark() || (this.ms < this.me ? this.ms >= this.ps && this.ms < this.pe : this.me >= this.ps && this.me < this.pe));
    }

    boolean inMark() {
        return this.ms < this.me ? this.ps >= this.ms && this.ps < this.me : this.ps >= this.me && this.ps < this.ms;
    }

    String copy() {
        int s;
        if (!this.marked()) {
            return "";
        }
        TokenBuilder tb = new TokenBuilder();
        int e = this.ms < this.me ? this.me : this.ms;
        int n = s = this.ms < this.me ? this.ms : this.me;
        while (s < e) {
            int t = Token.cp(this.text, s);
            if (t < 0 || t >= 32 || t == 10 || t == 9) {
                tb.add(t);
            }
            s += Token.cl(this.text, s);
        }
        return tb.toString();
    }

    void selectWord() {
        int c;
        this.pos(this.cursor());
        boolean ch = Token.ftChar(this.prev(true));
        while (this.pos() > 0 && (c = this.prev(true)) != 10 && ch == Token.ftChar(c)) {
        }
        if (this.pos() != 0) {
            this.next(true);
        }
        this.startMark();
        while (this.pos() < this.size() && (c = this.curr()) != 10 && ch == Token.ftChar(c)) {
            this.next(true);
        }
        this.endMark();
    }

    void selectLine() {
        this.pos(this.cursor());
        this.bol(true);
        this.startMark();
        this.eol(true);
        this.endMark();
    }

    void selectAll() {
        this.pos(0);
        this.startMark();
        this.pos(this.size());
        this.endMark();
    }

    int error() {
        return this.es;
    }

    public void error(int s) {
        this.es = s;
    }

    boolean erroneous() {
        return this.es >= this.ps && this.es <= this.pe;
    }

    boolean edited() {
        return this.pc >= this.ps && this.pc <= this.pe;
    }

    void setCaret(int c) {
        this.pc = c;
    }

    void setCaret() {
        this.pc = this.ps;
    }

    int cursor() {
        return this.pc;
    }

    int size() {
        return this.text.length;
    }

    public String toString() {
        return this.copy();
    }
}

