/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.core.Context;
import org.basex.core.Progress;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.FTPosData;
import org.basex.data.Nodes;
import org.basex.data.Result;
import org.basex.io.IO;
import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.QueryResources;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.func.JavaMapping;
import org.basex.query.func.UserFuncs;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.up.Updates;
import org.basex.query.util.ClientSessions;
import org.basex.query.util.Err;
import org.basex.query.util.JDBCConnections;
import org.basex.query.util.Var;
import org.basex.query.util.VarContext;
import org.basex.query.util.json.JsonMapConverter;
import org.basex.query.util.pkg.ModuleLoader;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dat;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Tim;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.hash.TokenMap;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

public final class QueryContext
extends Progress {
    private static final Pattern BIND = Pattern.compile("^((\"|')(.*?)\\2:|(\\{(.*?)\\}))(.+)$");
    public StaticContext sc = new StaticContext();
    public final VarContext vars = new VarContext();
    public final UserFuncs funcs = new UserFuncs();
    public final QueryResources resource = new QueryResources(this);
    public final Context context;
    public HashMap<String, IO> stop;
    public HashMap<String, IO> thes;
    public final HashMap<String, String> dbOptions = new HashMap();
    public final HashMap<String, Object> globalOpt = new HashMap();
    public StringList db;
    public Value value;
    public long pos = 1L;
    public long size = 1L;
    Nodes nodes;
    private FTOpt ftOpt;
    public FTLexer fttoken;
    public Dat date;
    public Dtm dtm;
    public Tim time;
    public FTPosData ftpos;
    public byte ftoknum;
    public Updates updates;
    public ValueBuilder output = new ValueBuilder();
    public boolean leaf;
    public boolean grouping;
    public int tailCalls;
    public final int maxCalls;
    public int varIDs;
    final TokenMap modDeclared = new TokenMap();
    final TokenMap modParsed = new TokenMap();
    SerializerProp serProp;
    public Expr ctxItem;
    public ModuleLoader modules;
    JDBCConnections jdbc;
    ClientSessions sessions;
    Expr root;
    private final TokenBuilder info = new TokenBuilder();
    private final boolean inf;
    private boolean firstOpt = true;
    private boolean firstEval = true;
    private boolean closed;

    public QueryContext(Context ctx) {
        this.context = ctx;
        this.nodes = ctx.current();
        this.inf = ctx.prop.is(Prop.QUERYINFO) || Prop.debug;
        String path = ctx.prop.get(Prop.QUERYPATH);
        if (!path.isEmpty()) {
            this.sc.baseURI(path);
        }
        this.maxCalls = ctx.prop.num(Prop.TAILCALLS);
        this.modules = new ModuleLoader(ctx);
        this.sc.xquery3 = ctx.prop.is(Prop.XQUERY3);
    }

    public void parse(String qu) throws QueryException {
        this.root = new QueryParser(qu, this).parse();
    }

    public QNm module(String qu) throws QueryException {
        return (QNm)new QueryParser(qu, this).parse(Token.EMPTY);
    }

    public void compile() throws QueryException {
        if (this.inf) {
            this.compInfo(Text.NL + Text.COMPILING_C, new Object[0]);
        }
        if (!this.dbOptions.isEmpty()) {
            for (Map.Entry<String, String> e : this.dbOptions.entrySet()) {
                this.context.prop.set(e.getKey(), e.getValue());
            }
        }
        if (this.ctxItem != null) {
            try {
                this.value = this.ctxItem.value(this);
            }
            catch (QueryException ex) {
                if (ex.err() != Err.XPNOCTX) {
                    throw ex;
                }
                Err.CTXINIT.thrw(((ParseExpr)this.ctxItem).info, ex);
            }
        } else if (this.nodes != null) {
            if (this.nodes.ftpos != null) {
                this.ftpos = new FTPosData();
            }
            this.resource.compile(this.nodes);
        }
        if (this.value != null && this.sc.initType != null) {
            this.value = SeqType.get(this.sc.initType, SeqType.Occ.ONE).promote(this.value, this, null);
        }
        this.analyze();
        if (this.inf) {
            this.info.add(Text.NL + Text.RESULT_C + this.funcs + this.root + Text.NL);
        }
    }

    public void analyze() throws QueryException {
        try {
            this.funcs.compile(this);
            if (this.root != null) {
                this.root = this.root.compile(this);
            }
        }
        catch (StackOverflowError ex) {
            Util.debug(ex);
            Err.XPSTACK.thrw(null, new Object[0]);
        }
    }

    public Iter iter() throws QueryException {
        try {
            return this.updating ? this.value().iter() : this.iter(this.root);
        }
        catch (StackOverflowError ex) {
            Util.debug(ex);
            throw Err.XPSTACK.thrw(null, new Object[0]);
        }
    }

    public Value value() throws QueryException {
        try {
            Value v = this.value(this.root);
            Value u = this.update();
            return u != null ? u : v;
        }
        catch (StackOverflowError ex) {
            Util.debug(ex);
            throw Err.XPSTACK.thrw(null, new Object[0]);
        }
    }

    public Value update() throws QueryException {
        if (this.updating) {
            this.db = this.updates.databases();
            this.updates.apply();
            if (this.updates.size() != 0 && this.context.data() != null) {
                this.context.update();
            }
            if (this.output.size() != 0L) {
                return this.output.value();
            }
        }
        return null;
    }

    public Iter iter(Expr e) throws QueryException {
        this.checkStop();
        return e.iter(this);
    }

    public Value value(Expr expr) throws QueryException {
        this.checkStop();
        return expr.value(this);
    }

    public Data data() {
        return this.value != null ? this.value.data() : null;
    }

    public Var uniqueVar(InputInfo ii, SeqType type) {
        return Var.create(this, ii, new QNm(Token.token(this.varIDs)), type, null);
    }

    public void compInfo(String string, Object ... ext) {
        if (!this.inf) {
            return;
        }
        if (!this.firstOpt) {
            this.info.add("- ");
        }
        this.firstOpt = false;
        this.info.addExt(string, ext).add(Text.NL);
    }

    public void evalInfo(byte[] string) {
        if (!this.inf) {
            return;
        }
        if (this.firstEval) {
            this.info.add(Text.NL).add(Text.EVALUATING_C).add(Text.NL);
        }
        this.info.add("- ").add(string).add(Text.NL);
        this.firstEval = false;
    }

    public String info() {
        return this.info.toString();
    }

    public JDBCConnections jdbc() {
        if (this.jdbc == null) {
            this.jdbc = new JDBCConnections();
        }
        return this.jdbc;
    }

    public ClientSessions sessions() {
        if (this.sessions == null) {
            this.sessions = new ClientSessions();
        }
        return this.sessions;
    }

    public SerializerProp serParams(boolean optional) {
        if (this.serProp != null) {
            return this.serProp;
        }
        String serial = this.context.prop.get(Prop.SERIALIZER);
        if (optional && serial.isEmpty()) {
            return null;
        }
        return new SerializerProp(serial);
    }

    public FTOpt ftOpt() {
        if (this.ftOpt == null) {
            this.ftOpt = new FTOpt();
        }
        return this.ftOpt;
    }

    public void ftOpt(FTOpt opt) {
        this.ftOpt = opt;
    }

    public void updating(boolean up) {
        if (this.updates == null) {
            this.updates = new Updates();
        }
        this.updating = up;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (Map.Entry<String, Object> e : this.globalOpt.entrySet()) {
            this.context.prop.setObject(e.getKey(), e.getValue());
        }
        this.resource.close();
        if (this.jdbc != null) {
            this.jdbc.close();
        }
        if (this.sessions != null) {
            this.sessions.close();
        }
        this.modules.close();
    }

    @Override
    public String tit() {
        return Text.SAVE;
    }

    @Override
    public String det() {
        return Text.PLEASE_WAIT_D;
    }

    @Override
    public double prog() {
        return 0.0;
    }

    Result execute() throws QueryException {
        int max = this.context.prop.num(Prop.MAXHITS);
        if (!Prop.gui || max < 0) {
            max = Integer.MAX_VALUE;
        }
        Iter ir = this.iter();
        ValueBuilder vb = new ValueBuilder();
        Item it = null;
        if (this.serProp == null && this.nodes != null) {
            IntList pre = new IntList();
            while ((it = ir.next()) != null) {
                this.checkStop();
                if (it.data() != this.nodes.data) break;
                if (pre.size() >= max) continue;
                pre.add(((DBNode)it).pre);
            }
            int ps = pre.size();
            if (it == null || ps == max) {
                return ps == 0 ? vb : new Nodes(pre.toArray(), this.nodes.data, this.ftpos).checkRoot();
            }
            for (int p = 0; p < ps; ++p) {
                vb.add(new DBNode(this.nodes.data, pre.get(p)));
            }
            vb.add(it);
        }
        while ((it = ir.next()) != null) {
            this.checkStop();
            if (vb.size() >= (long)max) continue;
            vb.add(it.materialize(null));
        }
        return vb;
    }

    public void context(Object val, String type) throws QueryException {
        this.ctxItem = this.cast(val, type);
    }

    public void bind(String name, Object val, String type) throws QueryException {
        this.bind(name, this.cast(val, type));
    }

    void plan(FDoc doc) {
        FElem e = new FElem(QueryText.PLAN);
        this.funcs.plan(e);
        this.vars.plan(e);
        this.root.plan(e);
        doc.add(e);
    }

    private void bind(String name, Expr val) throws QueryException {
        String nm = name.indexOf(36) == 0 ? name.substring(1) : name;
        byte[] uri = Token.EMPTY;
        Matcher m = BIND.matcher(nm);
        if (m.find()) {
            String u = m.group(3);
            if (u == null) {
                u = m.group(5);
            }
            uri = Token.token(u);
            nm = m.group(6);
        }
        byte[] ln = Token.token(nm);
        if (nm.isEmpty() || !XMLToken.isNCName(ln)) {
            return;
        }
        QNm qnm = uri.length == 0 ? new QNm(ln, this) : new QNm(ln, uri);
        Var gl = this.vars.globals().get(qnm);
        if (gl == null) {
            this.vars.updateGlobal(Var.create(this, null, qnm, null).bind(val, this));
        } else {
            gl.declared = false;
            gl.bind(gl.type == null ? val : gl.type.type.cast(val.item(this, null), this, null), this);
        }
    }

    private Expr cast(Object val, String type) throws QueryException {
        Enum typ;
        if (type == null || type.isEmpty()) {
            return val instanceof Expr ? (Expr)val : JavaMapping.toValue(val);
        }
        if (type.equalsIgnoreCase("json")) {
            return JsonMapConverter.parse(Token.token(val.toString()), null);
        }
        QNm nm = new QNm(Token.token(type.replaceAll("\\(.*?\\)$", "")), this);
        if (!nm.hasURI() && nm.hasPrefix()) {
            Err.NOURI.thrw(null, nm);
        }
        Enum enum_ = typ = type.endsWith(")") ? NodeType.find(nm) : AtomType.find(nm, false);
        if (typ == null) {
            Err.NOTYPE.thrw(null, type);
        }
        return typ.cast(val, null);
    }
}

