/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.zip.ZipEntry;
import org.basex.io.in.ArrayInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.FNConvert;
import org.basex.query.func.FuncParams;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.path.ExtTest;
import org.basex.query.util.Err;
import org.basex.query.util.archive.ArchiveIn;
import org.basex.query.util.archive.ArchiveOut;
import org.basex.query.util.archive.GZIPIn;
import org.basex.query.util.archive.GZIPOut;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.TokenList;

public class FNArchive
extends StandardFunc {
    private static final Atts NS = new Atts(QueryText.ARCHIVE, QueryText.ARCHIVEURI);
    private static final QNm Q_ENTRY = new QNm("archive:entry", QueryText.ARCHIVEURI);
    private static final QNm Q_OPTIONS = new QNm("archive:options", QueryText.ARCHIVEURI);
    private static final QNm Q_FORMAT = new QNm("archive:format", QueryText.ARCHIVEURI);
    private static final QNm Q_ALGORITHM = new QNm("archive:algorithm", QueryText.ARCHIVEURI);
    private static final ExtTest TEST = new ExtTest(NodeType.ELM, Q_ENTRY);
    private static final QNm Q_LEVEL = new QNm("compression-level");
    private static final QNm Q_ENCODING = new QNm("encoding");
    private static final QNm Q_LAST_MOD = new QNm("last-modified");
    private static final QNm Q_COMP_SIZE = new QNm("compressed-size");
    private static final QNm Q_SIZE = new QNm("size");
    private static final QNm Q_VALUE = new QNm("value");
    private static final byte[] FORMAT = Token.token("format");
    private static final byte[] ALGORITHM = Token.token("algorithm");
    private static final byte[] DEFLATE = Token.token("deflate");
    private static final byte[] STORED = Token.token("stored");
    private static final byte[] UNKNOWN = Token.token("unknown");

    public FNArchive(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _ARCHIVE_ENTRIES: {
                return this.entries(ctx);
            }
            case _ARCHIVE_EXTRACT_TEXT: {
                return this.extractText(ctx);
            }
            case _ARCHIVE_EXTRACT_BINARY: {
                return this.extractBinary(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.checkCreate(ctx);
        switch (this.sig) {
            case _ARCHIVE_CREATE: {
                return this.create(ctx);
            }
            case _ARCHIVE_UPDATE: {
                return this.update(ctx);
            }
            case _ARCHIVE_DELETE: {
                return this.delete(ctx);
            }
            case _ARCHIVE_OPTIONS: {
                return this.options(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private B64 create(QueryContext ctx) throws QueryException {
        Iter entr = ctx.iter(this.expr[0]);
        Iter cont = ctx.iter(this.expr[1]);
        Item opt = this.expr.length > 2 ? this.expr[2].item(ctx, this.info) : null;
        TokenMap map = new FuncParams(Q_OPTIONS, this.info).parse(opt);
        byte[] f = map.get(FORMAT);
        String format = f != null ? Token.string(Token.lc(f)) : "zip";
        ArchiveOut out = ArchiveOut.get(format, this.info);
        byte[] alg = map.get(ALGORITHM);
        int level = 8;
        if (alg != null) {
            if (format.equals("zip") && !Token.eq(alg, STORED, DEFLATE) || format.equals("gzip") && !Token.eq(alg, DEFLATE)) {
                Err.ARCH_SUPP.thrw(this.info, ALGORITHM, alg);
            }
            if (alg.equals(STORED)) {
                level = 0;
            } else if (alg.equals(DEFLATE)) {
                level = 8;
            }
        }
        out.level(level);
        try {
            Item cn;
            Item en;
            int e = 0;
            int c = 0;
            while (true) {
                en = entr.next();
                cn = cont.next();
                if (en == null || cn == null) break;
                if (out instanceof GZIPOut && c > 0) {
                    Err.ARCH_ONE.thrw(this.info, format.toUpperCase(Locale.ENGLISH));
                }
                this.add(this.checkElmStr(en), cn, out, level);
                ++e;
                ++c;
            }
            if (cn != null) {
                do {
                    ++c;
                } while (cont.next() != null);
            }
            if (en != null) {
                do {
                    ++e;
                } while (entr.next() != null);
            }
            if (e != c) {
                throw Err.ARCH_DIFF.thrw(this.info, e, c);
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            throw Err.ARCH_FAIL.thrw(this.info, ex);
        }
        finally {
            out.close();
        }
        return new B64(out.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FElem options(QueryContext ctx) throws QueryException {
        B64 archive = (B64)this.checkType(this.checkItem(this.expr[0], ctx), AtomType.B64);
        String format = null;
        int level = -1;
        ArchiveIn arch = ArchiveIn.get(archive.input(this.info), this.info);
        try {
            format = arch.format();
            while (arch.more()) {
                ZipEntry ze = arch.entry();
                if (ze.isDirectory()) continue;
                level = ze.getMethod();
                break;
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            Err.ARCH_FAIL.thrw(this.info, ex);
        }
        finally {
            arch.close();
        }
        FElem e = new FElem(Q_OPTIONS, NS);
        if (format != null) {
            e.add(new FElem(Q_FORMAT).add(Q_VALUE, Token.token(format)));
        }
        if (level >= 0) {
            byte[] lvl = level == 8 ? DEFLATE : (level == 0 ? STORED : UNKNOWN);
            e.add(new FElem(Q_ALGORITHM).add(Q_VALUE, lvl));
        }
        return e;
    }

    private Iter entries(QueryContext ctx) throws QueryException {
        B64 archive = (B64)this.checkType(this.checkItem(this.expr[0], ctx), AtomType.B64);
        ValueBuilder vb = new ValueBuilder();
        ArchiveIn in = ArchiveIn.get(archive.input(this.info), this.info);
        try {
            Object ze;
            while (in.more()) {
                ze = in.entry();
                if (((ZipEntry)ze).isDirectory()) continue;
                FElem e = new FElem(Q_ENTRY, NS);
                long s = ((ZipEntry)ze).getSize();
                if (s != -1L) {
                    e.add(Q_SIZE, Token.token(s));
                }
                if ((s = ((ZipEntry)ze).getTime()) != -1L) {
                    e.add(Q_LAST_MOD, new Dtm(s, this.info).string(this.info));
                }
                if ((s = ((ZipEntry)ze).getCompressedSize()) != -1L) {
                    e.add(Q_COMP_SIZE, Token.token(s));
                }
                e.add(Token.token(((ZipEntry)ze).getName()));
                vb.add(e);
            }
            ze = vb;
            return ze;
        }
        catch (IOException ex) {
            Util.debug(ex);
            throw Err.ARCH_FAIL.thrw(this.info, ex);
        }
        finally {
            in.close();
        }
    }

    private ValueBuilder extractText(QueryContext ctx) throws QueryException {
        String enc = this.encoding(2, Err.ARCH_ENCODING, ctx);
        ValueBuilder vb = new ValueBuilder();
        for (byte[] b : this.extract(ctx)) {
            vb.add(Str.get(this.encode(b, enc)));
        }
        return vb;
    }

    private ValueBuilder extractBinary(QueryContext ctx) throws QueryException {
        ValueBuilder vb = new ValueBuilder();
        for (byte[] b : this.extract(ctx)) {
            vb.add(new B64(b));
        }
        return vb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private B64 update(QueryContext ctx) throws QueryException {
        Item cn;
        Item en;
        B64 archive = (B64)this.checkType(this.checkItem(this.expr[0], ctx), AtomType.B64);
        TokenObjMap<Item[]> hm = new TokenObjMap<Item[]>();
        Iter entr = ctx.iter(this.expr[1]);
        Iter cont = ctx.iter(this.expr[2]);
        int e = 0;
        int c = 0;
        while (true) {
            en = entr.next();
            cn = cont.next();
            if (en == null || cn == null) break;
            hm.add(this.checkElmStr(en).string(this.info), new Item[]{en, cn});
            ++e;
            ++c;
        }
        if (cn != null) {
            do {
                ++c;
            } while (cont.next() != null);
        }
        if (en != null) {
            do {
                ++e;
            } while (entr.next() != null);
        }
        if (e != c) {
            Err.ARCH_DIFF.thrw(this.info, e, c);
        }
        ArchiveIn in = ArchiveIn.get(archive.input(this.info), this.info);
        ArchiveOut out = ArchiveOut.get(in.format(), this.info);
        try {
            if (in instanceof GZIPIn) {
                Err.ARCH_MODIFY.thrw(this.info, in.format().toUpperCase(Locale.ENGLISH));
            }
            while (in.more()) {
                if (hm.contains(Token.token(in.entry().getName()))) continue;
                out.write(in);
            }
            for (byte[] h : hm) {
                if (h == null) continue;
                Item[] it = (Item[])hm.get(h);
                this.add(it[0], it[1], out, 8);
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            Err.ARCH_FAIL.thrw(this.info, ex);
        }
        finally {
            in.close();
            out.close();
        }
        return new B64(out.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private B64 delete(QueryContext ctx) throws QueryException {
        Item en;
        B64 archive = (B64)this.checkType(this.checkItem(this.expr[0], ctx), AtomType.B64);
        TokenObjMap hm = new TokenObjMap();
        Iter names = ctx.iter(this.expr[1]);
        while ((en = names.next()) != null) {
            hm.add(this.checkElmStr(en).string(this.info), null);
        }
        ArchiveIn in = ArchiveIn.get(archive.input(this.info), this.info);
        ArchiveOut out = ArchiveOut.get(in.format(), this.info);
        try {
            if (in instanceof GZIPIn) {
                Err.ARCH_MODIFY.thrw(this.info, in.format().toUpperCase(Locale.ENGLISH));
            }
            while (in.more()) {
                if (hm.contains(Token.token(in.entry().getName()))) continue;
                out.write(in);
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            Err.ARCH_FAIL.thrw(this.info, ex);
        }
        finally {
            in.close();
            out.close();
        }
        return new B64(out.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TokenList extract(QueryContext ctx) throws QueryException {
        B64 archive = (B64)this.checkType(this.checkItem(this.expr[0], ctx), AtomType.B64);
        TokenSet hs = null;
        if (this.expr.length > 1) {
            Item en;
            hs = new TokenSet();
            Iter names = ctx.iter(this.expr[1]);
            while ((en = names.next()) != null) {
                hs.add(this.checkElmStr(en).string(this.info));
            }
        }
        TokenList tl = new TokenList();
        ArchiveIn in = ArchiveIn.get(archive.input(this.info), this.info);
        try {
            while (in.more()) {
                ZipEntry ze = in.entry();
                if (ze.isDirectory() || hs != null && hs.delete(Token.token(ze.getName())) == 0) continue;
                tl.add(in.read());
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            Err.ARCH_FAIL.thrw(this.info, ex);
        }
        finally {
            in.close();
        }
        return tl;
    }

    private void add(Item entry, Item con, ArchiveOut out, int level) throws QueryException, IOException {
        String name = Token.string(entry.string(this.info));
        if (name.isEmpty()) {
            Err.ARCH_EMPTY.thrw(this.info, new Object[0]);
        }
        ZipEntry ze = new ZipEntry(name);
        String en = null;
        byte[] lvl = null;
        if (entry instanceof ANode) {
            byte[] enc;
            ANode el = (ANode)entry;
            lvl = el.attribute(Q_LEVEL);
            byte[] mod = el.attribute(Q_LAST_MOD);
            if (mod != null) {
                try {
                    ze.setTime(new Int(new Dtm(mod, this.info)).itr());
                }
                catch (QueryException qe) {
                    Err.ARCH_DATETIME.thrw(this.info, new Object[]{mod});
                }
            }
            if ((enc = el.attribute(Q_ENCODING)) != null && !Charset.isSupported(en = Token.string(enc))) {
                Err.ARCH_ENCODING.thrw(this.info, new Object[]{enc});
            }
        }
        byte[] val = null;
        if (con.type.isString()) {
            val = con.string(this.info);
            if (en != null && en != "UTF-8") {
                val = this.encode(val, en);
            }
        } else if (con.type == AtomType.B64) {
            val = ((Bin)con).binary(this.info);
        } else {
            Err.STRB64TYPE.thrw(this.info, con.type);
        }
        try {
            out.level(lvl == null ? level : Token.toInt(lvl));
        }
        catch (IllegalArgumentException ex) {
            Err.ARCH_LEVEL.thrw(this.info, new Object[]{lvl});
        }
        out.write(ze, val);
    }

    private byte[] encode(byte[] val, String en) throws QueryException {
        try {
            return FNConvert.toString(new ArrayInput(val), en);
        }
        catch (IOException ex) {
            throw Err.ARCH_ENCODE.thrw(this.info, ex);
        }
    }

    private Item checkElmStr(Item it) throws QueryException {
        if (it.type.isString() || TEST.eq(it)) {
            return it;
        }
        throw Err.ELMSTRTYPE.thrw(this.info, Q_ENTRY.string(), it.type);
    }
}

