/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.math.BigDecimal;
import java.util.Calendar;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.Err;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.DTd;
import org.basex.query.value.item.Dat;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Tim;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class FNDate
extends StandardFunc {
    public FNDate(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = this.expr[0].item(ctx, this.info);
        if (it == null) {
            return null;
        }
        boolean d = this.expr.length == 2;
        Item zon = d ? this.expr[1].item(ctx, this.info) : null;
        switch (this.sig) {
            case YEARS_FROM_DURATION: {
                return FNDate.yea(this.checkDur(it));
            }
            case YEAR_FROM_DATETIME: {
                return FNDate.yea(this.checkDate(it, AtomType.DTM, ctx));
            }
            case YEAR_FROM_DATE: {
                return FNDate.yea(this.checkDate(it, AtomType.DAT, ctx));
            }
            case MONTHS_FROM_DURATION: {
                return FNDate.mon(this.checkDur(it));
            }
            case MONTH_FROM_DATETIME: {
                return FNDate.mon(this.checkDate(it, AtomType.DTM, ctx));
            }
            case MONTH_FROM_DATE: {
                return FNDate.mon(this.checkDate(it, AtomType.DAT, ctx));
            }
            case DAYS_FROM_DURATION: {
                return FNDate.day(this.checkDur(it));
            }
            case DAY_FROM_DATETIME: {
                return FNDate.day(this.checkDate(it, AtomType.DTM, ctx));
            }
            case DAY_FROM_DATE: {
                return FNDate.day(this.checkDate(it, AtomType.DAT, ctx));
            }
            case HOURS_FROM_DURATION: {
                return FNDate.hou(this.checkDur(it));
            }
            case HOURS_FROM_DATETIME: {
                return FNDate.hou(this.checkDate(it, AtomType.DTM, ctx));
            }
            case HOURS_FROM_TIME: {
                return FNDate.hou(this.checkDate(it, AtomType.TIM, ctx));
            }
            case MINUTES_FROM_DURATION: {
                return FNDate.min(this.checkDur(it));
            }
            case MINUTES_FROM_DATETIME: {
                return FNDate.min(this.checkDate(it, AtomType.DTM, ctx));
            }
            case MINUTES_FROM_TIME: {
                return FNDate.min(this.checkDate(it, AtomType.TIM, ctx));
            }
            case SECONDS_FROM_DURATION: {
                return FNDate.sec(this.checkDur(it));
            }
            case SECONDS_FROM_DATETIME: {
                return FNDate.sec(this.checkDate(it, AtomType.DTM, ctx));
            }
            case SECONDS_FROM_TIME: {
                return FNDate.sec(this.checkDate(it, AtomType.TIM, ctx));
            }
            case TIMEZONE_FROM_DATETIME: {
                return FNDate.zon(this.checkDate(it, AtomType.DTM, ctx));
            }
            case TIMEZONE_FROM_DATE: {
                return FNDate.zon(this.checkDate(it, AtomType.DAT, ctx));
            }
            case TIMEZONE_FROM_TIME: {
                return FNDate.zon(this.checkDate(it, AtomType.TIM, ctx));
            }
            case ADJUST_DATE_TO_TIMEZONE: {
                return this.datzon(it, zon, d);
            }
            case ADJUST_DATETIME_TO_TIMEZONE: {
                return this.dtmzon(it, zon, d);
            }
            case ADJUST_TIME_TO_TIMEZONE: {
                return this.timzon(it, zon, d);
            }
            case DATETIME: {
                return this.dattim(it, zon);
            }
        }
        return super.item(ctx, ii);
    }

    private static Item yea(Item it) {
        return Int.get(it instanceof Dur ? (long)((Dur)it).yea() : (long)((ADate)it).xc.getYear());
    }

    private static Item mon(Item it) {
        return Int.get(it instanceof Dur ? (long)((Dur)it).mon() : (long)((ADate)it).xc.getMonth());
    }

    private static Item day(Item it) {
        return Int.get(it instanceof Dur ? (long)((int)((Dur)it).day()) : (long)((ADate)it).xc.getDay());
    }

    private static Item hou(Item it) {
        return Int.get(it instanceof Dur ? (long)((int)((Dur)it).hou()) : (long)((ADate)it).xc.getHour());
    }

    private static Item min(Item it) {
        return Int.get(it instanceof Dur ? ((Dur)it).min() : (long)((ADate)it).xc.getMinute());
    }

    private static Item sec(Item it) {
        if (it instanceof Dur) {
            return Dec.get(((Dur)it).sec().doubleValue());
        }
        int s = ((ADate)it).xc.getSecond();
        BigDecimal d = ((ADate)it).xc.getFractionalSecond();
        return Dec.get((double)s + (d != null ? d.doubleValue() : 0.0));
    }

    private static Item zon(Item it) {
        int z = ((ADate)it).xc.getTimezone();
        return z == Integer.MIN_VALUE ? null : new DTd(z);
    }

    private Item checkDate(Item it, Type t, QueryContext ctx) throws QueryException {
        return it.type.isUntyped() ? t.cast(it, ctx, this.info) : this.checkType(it, t);
    }

    private Item checkDur(Item it) throws QueryException {
        Type ip = it.type;
        if (ip.isUntyped()) {
            return new Dur(it.string(this.info), this.info);
        }
        if (!ip.isDuration()) {
            Err.type(this, AtomType.DUR, it);
        }
        return it;
    }

    private Item datzon(Item it, Item zon, boolean d) throws QueryException {
        Dat i = it.type.isUntyped() ? new Dat(it.string(this.info), this.info) : new Dat((ADate)this.checkType(it, AtomType.DAT));
        return this.adjust(i, zon, d);
    }

    private Item dtmzon(Item it, Item zon, boolean d) throws QueryException {
        Dtm i = it.type.isUntyped() ? new Dtm(it.string(this.info), this.info) : new Dtm((ADate)this.checkType(it, AtomType.DTM));
        return this.adjust(i, zon, d);
    }

    private Item timzon(Item it, Item zon, boolean d) throws QueryException {
        Tim i = it.type.isUntyped() ? new Tim(it.string(this.info), this.info) : new Tim((ADate)this.checkType(it, AtomType.TIM));
        return this.adjust(i, zon, d);
    }

    private Item dattim(Item date, Item tm) throws QueryException {
        if (tm == null) {
            return null;
        }
        Item d = date.type.isUntyped() ? new Dat(date.string(this.info), this.info) : date;
        Item t = tm.type.isUntyped() ? new Tim(tm.string(this.info), this.info) : tm;
        Dtm dtm = new Dtm((Dat)this.checkType(d, AtomType.DAT));
        Tim tim = (Tim)this.checkType(t, AtomType.TIM);
        dtm.xc.setTime(tim.xc.getHour(), tim.xc.getMinute(), tim.xc.getSecond(), tim.xc.getMillisecond());
        int zone = tim.xc.getTimezone();
        if (dtm.xc.getTimezone() == Integer.MIN_VALUE) {
            dtm.xc.setTimezone(zone);
        } else if (dtm.xc.getTimezone() != zone && zone != Integer.MIN_VALUE) {
            Err.FUNZONE.thrw(this.info, dtm, tim);
        }
        return dtm;
    }

    private ADate adjust(ADate date, Item zon, boolean d) throws QueryException {
        int tz;
        if (d && zon == null) {
            date.xc.setTimezone(Integer.MIN_VALUE);
            return date;
        }
        int zn = date.xc.getTimezone();
        if (zon == null) {
            Calendar c = Calendar.getInstance();
            tz = (c.get(15) + c.get(16)) / 60000;
        } else {
            DTd dtd = (DTd)this.checkType(zon, AtomType.DTD);
            tz = (int)(dtd.min() + dtd.hou() * 60L);
            if (dtd.sec().signum() != 0 || Math.abs(tz) > 840) {
                Err.INVALZONE.thrw(this.info, zon);
            }
        }
        if (zn != Integer.MIN_VALUE) {
            date.xc.add(ADate.df.newDuration(-60000L * (long)(zn - tz)));
        }
        date.xc.setTimezone(tz);
        return date;
    }
}

