/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import java.util.Arrays;
import java.util.Iterator;
import org.basex.query.QueryException;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class ItemSet
implements Iterable<Item> {
    private static final int CAP = 8;
    private int[] hash = new int[8];
    private int[] next = new int[8];
    private int[] bucket = new int[8];
    Item[] keys = new Item[8];
    int size = 1;

    public boolean index(InputInfo ii, Item i) throws QueryException {
        if (this.size == this.next.length) {
            this.rehash();
        }
        int h = i.hash(ii);
        int p = h & this.bucket.length - 1;
        int id = this.bucket[p];
        while (id != 0) {
            if (this.keys[id].equiv(ii, i)) {
                return false;
            }
            id = this.next[id];
        }
        this.next[this.size] = this.bucket[p];
        this.hash[this.size] = h;
        this.keys[this.size] = i;
        ++this.size;
        return true;
    }

    private void rehash() {
        int s = this.size << 1;
        int[] b = new int[s];
        for (int id : this.bucket) {
            while (id != 0) {
                int p = this.hash[id] & s - 1;
                int nx = this.next[id];
                this.next[id] = b[p];
                b[p] = id;
                id = nx;
            }
        }
        this.bucket = b;
        this.next = Arrays.copyOf(this.next, s);
        this.hash = Arrays.copyOf(this.hash, s);
        Item[] i = new Item[s];
        System.arraycopy(this.keys, 0, i, 0, this.size);
        this.keys = i;
    }

    public int size() {
        return this.size - 1;
    }

    @Override
    public Iterator<Item> iterator() {
        return new Iterator<Item>(){
            private int c = 1;

            @Override
            public boolean hasNext() {
                return this.c < ItemSet.this.size;
            }

            @Override
            public Item next() {
                return ItemSet.this.keys[this.c++];
            }

            @Override
            public void remove() {
                Util.notexpected(new Object[0]);
            }
        };
    }
}

