/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class YMDur
extends Dur {
    private static final Pattern DUR = Pattern.compile("(-?)P(([0-9]+)Y)?(([0-9]+)M)?");

    public YMDur(Dur it) {
        super(AtomType.YMD);
        this.mon = it.mon;
        this.sc = BigDecimal.valueOf(0L);
    }

    public YMDur(YMDur it, YMDur a, boolean p) {
        this(it);
        this.mon += p ? a.mon : -a.mon;
    }

    public YMDur(Dur it, double f, boolean m, InputInfo ii) throws QueryException {
        this(it);
        if (Double.isNaN(f)) {
            Err.DATECALC.thrw(ii, this.description(), f);
        }
        if (m ? f == Double.POSITIVE_INFINITY || f == Double.NEGATIVE_INFINITY : f == 0.0) {
            Err.DATEZERO.thrw(ii, this.description());
        }
        this.mon = (int)StrictMath.round(m ? (double)this.mon * f : (double)this.mon / f);
    }

    public YMDur(byte[] v, InputInfo ii) throws QueryException {
        super(AtomType.YMD);
        String val = Token.string(v).trim();
        Matcher mt = DUR.matcher(val);
        if (!mt.matches() || val.endsWith("P")) {
            this.dateErr(v, "P2000Y12M", ii);
        }
        int y = mt.group(2) != null ? Token.toInt(mt.group(3)) : 0;
        int m = mt.group(4) != null ? Token.toInt(mt.group(5)) : 0;
        this.mon = y * 12 + m;
        if (!mt.group(1).isEmpty()) {
            this.mon = -this.mon;
        }
        this.sc = BigDecimal.valueOf(0L);
    }

    public int ymd() {
        return this.mon;
    }

    @Override
    public byte[] string(InputInfo ii) {
        TokenBuilder tb = new TokenBuilder();
        if (this.mon < 0) {
            tb.add(45);
        }
        tb.add(80);
        if (this.yea() != 0) {
            tb.addLong(Math.abs(this.yea()));
            tb.add(89);
        }
        if (this.mon() != 0) {
            tb.addLong(Math.abs(this.mon()));
            tb.add(77);
        }
        if (this.mon == 0) {
            tb.add("0M");
        }
        return tb.finish();
    }

    @Override
    public int diff(InputInfo ii, Item it) throws QueryException {
        if (it.type != this.type) {
            Err.diff(ii, it, this);
        }
        return this.mon - ((Dur)it).mon;
    }
}

