/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import java.util.Iterator;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.ElementList;

public class TokenList
extends ElementList
implements Iterable<byte[]> {
    byte[][] list;

    public TokenList() {
        this(8);
    }

    public TokenList(int is) {
        this.list = new byte[is][];
    }

    public TokenList(double f) {
        this(8);
        this.factor = f;
    }

    public TokenList(byte[][] a) {
        this.list = a;
        this.size = this.list.length;
    }

    public void add(byte[] e) {
        if (this.size == this.list.length) {
            this.list = Array.copyOf(this.list, this.newSize());
        }
        this.list[this.size++] = e;
    }

    public void add(long e) {
        this.add(Token.token(e));
    }

    public void add(String e) {
        this.add(Token.token(e));
    }

    public void insert(int i, byte[][] e) {
        int l = e.length;
        if (l == 0) {
            return;
        }
        if (this.size + l > this.list.length) {
            this.list = (byte[][])Arrays.copyOf(this.list, this.newSize(this.size + l));
        }
        Array.move(this.list, i, l, this.size - i);
        System.arraycopy(e, 0, this.list, i, l);
        this.size += l;
    }

    public void delete(int i) {
        Array.move(this.list, i + 1, -1, --this.size - i);
    }

    public byte[] get(int i) {
        return i < this.list.length ? this.list[i] : null;
    }

    public void set(int i, byte[] e) {
        if (i >= this.list.length) {
            this.list = Array.copyOf(this.list, this.newSize(i + 1));
        }
        this.list[i] = e;
        this.size = Math.max(this.size, i + 1);
    }

    public byte[] pop() {
        return this.list[--this.size];
    }

    public void push(byte[] val) {
        this.add(val);
    }

    public byte[] peek() {
        return this.list[this.size - 1];
    }

    public boolean contains(byte[] e) {
        for (int i = 0; i < this.size; ++i) {
            if (!Token.eq(this.list[i], e)) continue;
            return true;
        }
        return false;
    }

    public byte[][] toArray() {
        return Array.copyOf(this.list, this.size);
    }

    public String[] toStringArray() {
        int is = this.size;
        byte[][] l = this.list;
        String[] items = new String[is];
        for (int i = 0; i < is; ++i) {
            items[i] = Token.string(l[i]);
        }
        return items;
    }

    public TokenList sort(boolean cs) {
        Arrays.sort(this.list, 0, this.size, cs ? Token.COMP : Token.LC_COMP);
        return this;
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new Iterator<byte[]>(){
            private int c;

            @Override
            public boolean hasNext() {
                return this.c < TokenList.this.size;
            }

            @Override
            public byte[] next() {
                return TokenList.this.list[this.c++];
            }

            @Override
            public void remove() {
                Util.notexpected(new Object[0]);
            }
        };
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder(Util.name(this) + '[');
        for (int i = 0; i < this.size; ++i) {
            if (i != 0) {
                tb.add(", ");
            }
            tb.add(this.list[i]);
        }
        return tb.add(93).toString();
    }
}

