/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.xml;

import java.io.IOException;
import java.util.Arrays;
import org.basex.build.BuildException;
import org.basex.build.BuildText;
import org.basex.core.Progress;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.XMLInput;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenMap;

final class XMLScanner
extends Progress {
    private static final String[] ENTITIES = new String[]{"amp", "&", "apos", "'", "quot", "\"", "lt", "<", "gt", ">"};
    private static final byte[] PUBIDTOK = Token.token(" \n'()+,/=?;!*#@$%");
    private static final byte[] QUESTION = new byte[]{63};
    private static final byte[] AMPER = new byte[]{38};
    final TokenBuilder token = new TokenBuilder();
    final String encoding;
    BuildText.Type type;
    private final TokenMap ents = new TokenMap();
    private final TokenMap pents = new TokenMap();
    private final boolean dtd;
    private final boolean chop;
    private State state = State.CONTENT;
    private boolean prolog = true;
    private boolean pe;
    private boolean text = true;
    private int quote;
    private XMLInput input;
    private static final TokenMap HTMLENTS = new TokenMap();
    private static final String[] HTMLENTITIES = new String[]{"Aacute", "\u00c1", "aacute", "\u00e1", "Acirc", "\u00c2", "acirc", "\u00e2", "acute", "\u00b4", "AElig", "\u00c6", "aelig", "\u00e6", "Agrave", "\u00c0", "agrave", "\u00e0", "alefsym", "\u2135", "Alpha", "\u0391", "alpha", "\u03b1", "and", "\u2227", "ang", "\u2220", "Aring", "\u00c5", "aring", "\u00e5", "asymp", "\u2248", "Atilde", "\u00c3", "atilde", "\u00e3", "Auml", "\u00c4", "auml", "\u00e4", "bdquo", "\u201e", "Beta", "\u0392", "beta", "\u03b2", "brvbar", "\u00a6", "bull", "\u2022", "cap", "\u2229", "Ccedil", "\u00c7", "ccedil", "\u00e7", "cedil", "\u00b8", "cent", "\u00a2", "Chi", "\u03a7", "chi", "\u03c7", "circ", "\u02c6", "clubs", "\u2663", "cong", "\u2245", "copy", "\u00a9", "crarr", "\u21b5", "cup", "\u222a", "curren", "\u00a4", "dagger", "\u2020", "Dagger", "\u2021", "darr", "\u2193", "dArr", "\u21d3", "deg", "\u00b0", "Delta", "\u0394", "delta", "\u03b4", "diams", "\u2666", "divide", "\u00f7", "Eacute", "\u00c9", "eacute", "\u00e9", "Ecirc", "\u00ca", "ecirc", "\u00ea", "Egrave", "\u00c8", "egrave", "\u00e8", "empty", "\u2205", "emsp", "\u2003", "ensp", "\u2002", "Epsilon", "\u0395", "epsilon", "\u03b5", "equiv", "\u2261", "Eta", "\u0397", "eta", "\u03b7", "ETH", "\u00d0", "eth", "\u00f0", "Euml", "\u00cb", "euml", "\u00eb", "euro", "\u20ac", "exist", "\u2203", "fnof", "\u0192", "forall", "\u2200", "frac12", "\u00bd", "frac14", "\u00bc", "frac34", "\u00be", "frasl", "\u2044", "Gamma", "\u0393", "gamma", "\u03b3", "ge", "\u2265", "harr", "\u2194", "hArr", "\u21d4", "hearts", "\u2665", "hellip", "\u2026", "Iacute", "\u00cd", "iacute", "\u00ed", "Icirc", "\u00ce", "icirc", "\u00ee", "iexcl", "\u00a1", "Igrave", "\u00cc", "igrave", "\u00ec", "image", "\u2111", "infin", "\u221e", "int", "\u222b", "Iota", "\u0399", "iota", "\u03b9", "iquest", "\u00bf", "isin", "\u2208", "Iuml", "\u00cf", "iuml", "\u00ef", "Kappa", "\u039a", "kappa", "\u03ba", "Lambda", "\u039b", "lambda", "\u03bb", "lang", "\u2329", "laquo", "\u00ab", "larr", "\u2190", "lArr", "\u21d0", "lceil", "\u2308", "ldquo", "\u201c", "le", "\u2264", "lfloor", "\u230a", "lowast", "\u2217", "loz", "\u25ca", "lrm", "\u200e", "lsaquo", "\u2039", "lsquo", "\u2018", "macr", "\u00af", "mdash", "\u2014", "micro", "\u00b5", "middot", "\u00b7", "minus", "\u2212", "Mu", "\u039c", "mu", "\u03bc", "nabla", "\u2207", "nbsp", "\u00a0", "ndash", "\u2013", "ne", "\u2260", "ni", "\u220b", "not", "\u00ac", "notin", "\u2209", "nsub", "\u2284", "Ntilde", "\u00d1", "ntilde", "\u00f1", "Nu", "\u039d", "nu", "\u03bd", "Oacute", "\u00d3", "oacute", "\u00f3", "Ocirc", "\u00d4", "ocirc", "\u00f4", "OElig", "\u0152", "oelig", "\u0153", "Ograve", "\u00d2", "ograve", "\u00f2", "oline", "\u203e", "Omega", "\u03a9", "omega", "\u03c9", "Omicron", "\u039f", "omicron", "\u03bf", "oplus", "\u2295", "or", "\u2228", "ordf", "\u00aa", "ordm", "\u00ba", "Oslash", "\u00d8", "oslash", "\u00f8", "Otilde", "\u00d5", "otilde", "\u00f5", "otimes", "\u2297", "Ouml", "\u00d6", "ouml", "\u00f6", "para", "\u00b6", "part", "\u2202", "permil", "\u2030", "perp", "\u22a5", "Phi", "\u03a6", "phi", "\u03c6", "Pi", "\u03a0", "pi", "\u03c0", "piv", "\u03d6", "plusmn", "\u00b1", "pound", "\u00a3", "prime", "\u2032", "Prime", "\u2033", "prod", "\u220f", "prop", "\u221d", "Psi", "\u03a8", "psi", "\u03c8", "radic", "\u221a", "rang", "\u232a", "raquo", "\u00bb", "rarr", "\u2192", "rArr", "\u21d2", "rceil", "\u2309", "rdquo", "\u201d", "real", "\u211c", "reg", "\u00ae", "rfloor", "\u230b", "Rho", "\u03a1", "rho", "\u03c1", "rlm", "\u200f", "rsaquo", "\u203a", "rsquo", "\u2019", "sbquo", "\u201a", "Scaron", "\u0160", "scaron", "\u0161", "sdot", "\u22c5", "sect", "\u00a7", "shy", "\u00ad", "Sigma", "\u03a3", "sigma", "\u03c3", "sigmaf", "\u03c2", "sim", "\u223c", "spades", "\u2660", "sub", "\u2282", "sube", "\u2286", "sum", "\u2211", "sup", "\u2283", "sup1", "\u00b9", "sup2", "\u00b2", "sup3", "\u00b3", "supe", "\u2287", "szlig", "\u00df", "Tau", "\u03a4", "tau", "\u03c4", "there4", "\u2234", "Theta", "\u0398", "theta", "\u03b8", "thetasym", "\u03d1", "thinsp", "\u2009", "THORN", "\u00de", "thorn", "\u00fe", "tilde", "\u02dc", "times", "\u00d7", "trade", "\u2122", "Uacute", "\u00da", "uacute", "\u00fa", "uarr", "\u2191", "uArr", "\u21d1", "Ucirc", "\u00db", "ucirc", "\u00fb", "Ugrave", "\u00d9", "ugrave", "\u00f9", "uml", "\u00a8", "upsih", "\u03d2", "Upsilon", "\u03a5", "upsilon", "\u03c5", "Uuml", "\u00dc", "uuml", "\u00fc", "weierp", "\u2118", "Xi", "\u039e", "xi", "\u03be", "Yacute", "\u00dd", "yacute", "\u00fd", "yen", "\u00a5", "yuml", "\u00ff", "Yuml", "\u0178", "Zeta", "\u0396", "zeta", "\u03b6", "zwj", "\u200d", "zwnj", "\u200c"};

    XMLScanner(IO f, Prop pr) throws IOException {
        this.input = new XMLInput(f);
        try {
            for (int e = 0; e < ENTITIES.length; e += 2) {
                this.ents.add(Token.token(ENTITIES[e]), Token.token(ENTITIES[e + 1]));
            }
            this.dtd = pr.is(Prop.DTD);
            this.chop = pr.is(Prop.CHOP);
            String enc = null;
            if (this.consume(BuildText.DOCDECL)) {
                if (this.s()) {
                    if (!this.version()) {
                        this.error("Document declaration must start with 'version'.", new Object[0]);
                    }
                    boolean s = this.s();
                    enc = this.encoding();
                    if (enc != null) {
                        if (!s) {
                            this.error("Missing Whitespace.", new Object[0]);
                        }
                        s = this.s();
                    }
                    if (this.sddecl() != null && !s) {
                        this.error("Missing Whitespace.", new Object[0]);
                    }
                    this.s();
                    int ch = this.nextChar();
                    if (ch != 63 || this.nextChar() != 62) {
                        this.error("Invalid document declaration.", new Object[0]);
                    }
                } else {
                    this.prev(5);
                }
            }
            this.encoding = enc == null ? "UTF-8" : enc;
            int n = this.consume();
            if (!this.s(n)) {
                if (n != 60) {
                    this.error("No text allowed before root element.", new Object[0]);
                }
                this.prev(1);
            }
        }
        catch (IOException ex) {
            this.input.close();
            throw ex;
        }
    }

    boolean more() throws IOException {
        this.token.reset();
        int ch = this.consume();
        if (ch == 0) {
            this.type = BuildText.Type.EOF;
            return false;
        }
        switch (this.state) {
            case CONTENT: {
                this.scanCONTENT(ch);
                break;
            }
            case TAG: 
            case ATT: {
                this.scanTAG(ch);
                break;
            }
            case QUOTE: {
                this.scanATTVALUE(ch);
            }
        }
        return true;
    }

    void close() throws IOException {
        this.input.close();
        if (this.prolog) {
            this.error("Document is empty.", new Object[0]);
        }
    }

    private void scanCONTENT(int ch) throws IOException {
        if (this.text && (ch != 60 || this.isCDATA())) {
            this.content(ch);
            return;
        }
        this.text = true;
        int c = this.nextChar();
        if (c == 33) {
            if (this.consume(BuildText.DOCTYPE)) {
                this.type = BuildText.Type.DTD;
                this.dtd();
            } else {
                this.type = BuildText.Type.COMMENT;
                if (!this.consume('-') || !this.consume('-')) {
                    this.error("Missing '-' in comment declaration.", new Object[0]);
                }
                this.comment();
            }
            return;
        }
        if (c == 63) {
            this.type = BuildText.Type.PI;
            this.pi();
            return;
        }
        this.prolog = false;
        this.state = State.TAG;
        if (c == 47) {
            this.type = BuildText.Type.L_BR_CLOSE;
            return;
        }
        this.type = BuildText.Type.L_BR;
        this.prev(1);
    }

    private void scanTAG(int ch) throws IOException {
        int c = ch;
        if (c == 62) {
            this.type = BuildText.Type.R_BR;
            this.state = State.CONTENT;
        } else if (c == 61) {
            this.type = BuildText.Type.EQ;
        } else if (c == 39 || c == 34) {
            this.type = BuildText.Type.QUOTE;
            this.state = State.QUOTE;
            this.quote = c;
        } else if (c == 47) {
            this.type = BuildText.Type.CLOSE_R_BR;
            c = this.nextChar();
            if (c == 62) {
                this.state = State.CONTENT;
            } else {
                this.token.add(c);
                this.error("Tag was not properly closed.", new Object[0]);
            }
        } else if (this.s(c)) {
            this.type = BuildText.Type.WS;
        } else if (XMLToken.isStartChar(c)) {
            this.type = this.state == State.ATT ? BuildText.Type.ATTNAME : BuildText.Type.TAGNAME;
            do {
                this.token.add(c);
            } while (XMLToken.isChar(c = this.nextChar()));
            this.prev(1);
            this.state = State.ATT;
        } else {
            this.error("Invalid character found: '%'", Character.valueOf((char)c));
        }
    }

    private void scanATTVALUE(int ch) throws IOException {
        if (ch == this.quote) {
            this.type = BuildText.Type.QUOTE;
            this.state = State.ATT;
        } else {
            this.type = BuildText.Type.ATTVALUE;
            this.attValue(ch);
            this.prev(1);
        }
    }

    private void attValue(int ch) throws IOException {
        boolean wrong = false;
        int c = ch;
        do {
            if (c == 0) {
                this.error("Attribute value was not properly closed.", Character.valueOf((char)c));
            }
            wrong |= c == 39 || c == 34;
            if (c == 60) {
                this.error(wrong ? "Attribute value was not properly closed." : "Invalid character '%' in attribute value.", Character.valueOf((char)c));
            }
            if (c == 10) {
                c = 32;
            }
            if (c == 38) {
                byte[] r = this.ref(true);
                if (r.length == 1) {
                    this.token.add(r);
                    continue;
                }
                if (this.input.add(r, false)) continue;
                this.error("Recursive entity definition.", new Object[0]);
                continue;
            }
            this.token.add(c);
        } while ((c = this.consume()) != this.quote);
    }

    private void content(int ch) throws IOException {
        this.type = BuildText.Type.TEXT;
        boolean f = true;
        int c = ch;
        while (c != 0) {
            if (c != 60) {
                if (c == 38) {
                    byte[] r = this.ref(true);
                    if (r.length == 1) {
                        this.token.add(r);
                    } else if (!this.input.add(r, false)) {
                        this.error("Recursive entity definition.", new Object[0]);
                    }
                } else {
                    if (c == 93) {
                        if (this.consume() == 93) {
                            if (this.consume() == 62) {
                                this.error("']]>' not allowed in content.", new Object[0]);
                            }
                            this.prev(1);
                        }
                        this.prev(1);
                    }
                    this.token.add(c);
                }
            } else {
                if (!f && !this.isCDATA()) {
                    this.text = false;
                    this.prev(1);
                    if (this.chop) {
                        this.token.trim();
                    }
                    return;
                }
                this.cDATA();
            }
            c = this.consume();
            f = false;
        }
        if (!Token.ws(this.token.finish())) {
            this.error("No text allowed after closed root element.", new Object[0]);
        }
        this.type = BuildText.Type.EOF;
    }

    private boolean isCDATA() throws IOException {
        if (!this.consume('!')) {
            return false;
        }
        if (!this.consume('[')) {
            this.prev(1);
            return false;
        }
        if (!this.consume(BuildText.CDATA)) {
            this.error("Invalid CDATA section.", new Object[0]);
        }
        return true;
    }

    private void cDATA() throws IOException {
        while (true) {
            int ch;
            if ((ch = this.nextChar()) != 93) {
                this.token.add(ch);
                continue;
            }
            if (this.consume(']')) {
                if (this.consume('>')) {
                    return;
                }
                this.prev(1);
            }
            this.token.add(ch);
        }
    }

    private void comment() throws IOException {
        while (true) {
            int ch;
            if ((ch = this.nextChar()) == 45 && this.consume('-')) {
                this.check('>');
                return;
            }
            this.token.add(ch);
        }
    }

    private void pi() throws IOException {
        byte[] tok = this.name(true);
        if (Token.eq(Token.lc(tok), Token.XML)) {
            this.error("'<?xml' is reserved for document declaration.", new Object[0]);
        }
        this.token.add(tok);
        int ch = this.nextChar();
        if (ch != 63 && !Token.ws(ch)) {
            this.error("Invalid processing instruction.", new Object[0]);
        }
        while (true) {
            if (ch != 63) {
                this.token.add(ch);
                ch = this.nextChar();
                continue;
            }
            ch = this.consume();
            if (ch == 62) {
                return;
            }
            this.token.add(63);
        }
    }

    private boolean s() throws IOException {
        int ch = this.consume();
        if (this.s(ch)) {
            return true;
        }
        this.prev(1);
        return false;
    }

    private void checkS() throws IOException {
        if (!this.s()) {
            this.error("Whitespace expected, '%' found.", Character.valueOf((char)this.consume()));
        }
    }

    private void check(char ch) throws IOException {
        int c = this.consume();
        if (c != ch) {
            this.error("'%' expected, '%' found.", Character.valueOf(ch), Character.valueOf((char)c));
        }
    }

    private void check(byte[] tok) throws IOException {
        if (!this.consume(tok)) {
            this.error("'%' expected, '%' found.", tok, Character.valueOf((char)this.consume()));
        }
    }

    private boolean s(int ch) throws IOException {
        int c = ch;
        if (Token.ws(c)) {
            while (Token.ws(c = this.consume())) {
            }
            this.prev(1);
            return true;
        }
        return false;
    }

    private int qu() throws IOException {
        int qu = this.consume();
        if (qu != 39 && qu != 34) {
            this.error("Quote expected, '%' found.", Character.valueOf((char)qu));
        }
        return qu;
    }

    private byte[] ref(boolean f) throws IOException {
        if (this.consume('#')) {
            TokenBuilder ent = new TokenBuilder();
            int b = 10;
            int ch = this.nextChar();
            ent.add(ch);
            if (ch == 120) {
                b = 16;
                ch = this.nextChar();
                ent.add(ch);
            }
            int n = 0;
            do {
                boolean h;
                boolean m = ch >= 48 && ch <= 57;
                boolean bl = h = b == 16 && (ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70);
                if (!m && !h) {
                    this.completeRef(ent);
                    return QUESTION;
                }
                n *= b;
                n += ch & 0xF;
                if (!m) {
                    n += 9;
                }
                ch = this.nextChar();
                ent.add(ch);
            } while (ch != 59);
            if (!XMLToken.valid(n)) {
                return QUESTION;
            }
            ent.reset();
            ent.add(n);
            return ent.finish();
        }
        byte[] name = this.name(false);
        if (!this.consume(';')) {
            return QUESTION;
        }
        if (!f) {
            return Token.concat(AMPER, name, BuildText.SEMI);
        }
        byte[] en = this.ents.get(name);
        if (en == null) {
            if (HTMLENTS.size() == 0) {
                for (int s = 0; s < HTMLENTITIES.length; s += 2) {
                    HTMLENTS.add(Token.token(HTMLENTITIES[s]), Token.token(HTMLENTITIES[s + 1]));
                }
            }
            en = HTMLENTS.get(name);
        }
        return en == null ? QUESTION : en;
    }

    private byte[] peRef() throws IOException {
        byte[] name = this.name(true);
        this.consume(';');
        byte[] en = this.pents.get(name);
        if (en != null) {
            return en;
        }
        return name;
    }

    private void completeRef(TokenBuilder ent) throws IOException {
        int ch = this.consume();
        while (ent.size() < 10 && ch >= 32 && ch != 59) {
            ent.add(ch);
            ch = this.consume();
        }
    }

    private int nextChar() throws IOException {
        int ch = this.consume();
        if (ch == 0) {
            this.error("Unclosed tokens found.", this.token);
        }
        return ch;
    }

    private void prev(int p) {
        this.input.prev(p);
    }

    private int consume() throws IOException {
        int ch;
        while (true) {
            if ((ch = this.input.read()) == -1) {
                return 0;
            }
            if (ch != 37 || !this.pe) break;
            byte[] key = this.name(true);
            byte[] val = this.pents.get(key);
            if (val == null) {
                this.error("Unknown parameter reference '%'.", new Object[]{key});
            }
            this.check(';');
            this.input.add(val, true);
        }
        return ch;
    }

    private boolean consume(char ch) throws IOException {
        if (this.consume() == ch) {
            return true;
        }
        this.prev(1);
        return false;
    }

    private boolean consume(byte[] tok) throws IOException {
        for (int t = 0; t < tok.length; ++t) {
            int ch = this.consume();
            if (ch == tok[t]) continue;
            this.prev(t + 1);
            return false;
        }
        return true;
    }

    private byte[] name(boolean f) throws IOException {
        TokenBuilder name = new TokenBuilder();
        int c = this.consume();
        if (!XMLToken.isStartChar(c)) {
            if (f) {
                this.error("Invalid name.", new Object[0]);
            }
            this.prev(1);
            return null;
        }
        do {
            name.add(c);
        } while (XMLToken.isChar(c = this.nextChar()));
        this.prev(1);
        return name.finish();
    }

    private void nmtoken() throws IOException {
        int c;
        TokenBuilder name = new TokenBuilder();
        while (XMLToken.isChar(c = this.nextChar())) {
            name.add(c);
        }
        this.prev(1);
        if (name.isEmpty()) {
            this.error("Invalid name.", new Object[0]);
        }
    }

    private void dtd() throws IOException {
        if (!this.prolog) {
            this.error("Misplaced document type definition.", new Object[0]);
        }
        if (!this.s()) {
            this.error("Error in DTD.", new Object[0]);
        }
        this.name(true);
        this.s();
        this.externalID(true, true);
        this.s();
        while (this.consume('[')) {
            this.s();
            while (this.markupDecl()) {
            }
            this.s();
            this.check(']');
            this.s();
        }
        this.check('>');
    }

    private byte[] externalID(boolean f, boolean r) throws IOException {
        byte[] cont = null;
        boolean pub = this.consume(BuildText.PUBLIC);
        if (pub || this.consume(BuildText.SYSTEM)) {
            int qu;
            this.checkS();
            if (pub) {
                this.pubidLit();
                if (f) {
                    this.checkS();
                }
            }
            if ((qu = this.consume()) == 39 || qu == 34) {
                int ch;
                TokenBuilder tok = new TokenBuilder();
                while ((ch = this.nextChar()) != qu) {
                    tok.add(ch);
                }
                if (!f) {
                    return null;
                }
                String name = Token.string(tok.finish());
                if (!this.dtd && r) {
                    return cont;
                }
                XMLInput tin = this.input;
                try {
                    IO file = this.input.io().merge(name);
                    cont = file.read();
                }
                catch (IOException ex) {
                    Util.debug(ex);
                    cont = new byte[]{63};
                }
                this.input = new XMLInput(new IOContent(cont, name));
                if (this.consume(BuildText.XDECL)) {
                    this.check(Token.XML);
                    this.s();
                    if (this.version()) {
                        this.checkS();
                    }
                    this.s();
                    if (this.encoding() == null) {
                        this.error("'encoding' expected in text declaration.", new Object[0]);
                    }
                    if (this.s(ch = this.nextChar())) {
                        ch = this.nextChar();
                    }
                    if (ch != 63 || this.nextChar() != 62) {
                        this.error("Invalid document declaration.", new Object[0]);
                    }
                    cont = Arrays.copyOfRange(cont, this.input.pos(), cont.length);
                }
                this.s();
                if (r) {
                    this.extSubsetDecl();
                    if (!this.consume('\u0000')) {
                        this.error("Unexpected end.", new Object[0]);
                    }
                }
                this.input = tin;
            } else {
                if (f) {
                    this.error("Quote expected, '%' found.", Character.valueOf((char)qu));
                }
                this.prev(1);
            }
        }
        return cont;
    }

    private void pubidLit() throws IOException {
        int ch;
        int qu = this.qu();
        while ((ch = this.nextChar()) != qu) {
            if (XMLToken.isChar(ch) || Token.contains(PUBIDTOK, ch)) continue;
            this.error("Invalid character '%' in public identifier.", Character.valueOf((char)ch));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void extSubsetDecl() throws IOException {
        block0: while (true) {
            this.s();
            if (this.markupDecl()) continue;
            if (!this.consume(BuildText.COND)) {
                return;
            }
            this.s();
            incl = this.consume(BuildText.INCL);
            if (!incl) {
                this.check(BuildText.IGNO);
            }
            this.s();
            this.check('[');
            if (incl) {
                this.extSubsetDecl();
                this.check(BuildText.CONE);
                continue;
            }
            c = 1;
            while (true) {
                if (c != 0) ** break;
                continue block0;
                if (this.consume(BuildText.COND)) {
                    ++c;
                    continue;
                }
                if (this.consume(BuildText.CONE)) {
                    --c;
                    continue;
                }
                if (this.consume() != 0) continue;
                this.error("Unexpected end.", new Object[0]);
            }
            break;
        }
    }

    private boolean markupDecl() throws IOException {
        if (this.consume(BuildText.ENT)) {
            this.checkS();
            if (this.consume('%')) {
                this.checkS();
                byte[] key = this.name(true);
                this.checkS();
                byte[] val = this.entityValue(true);
                if (val == null && (val = this.externalID(true, false)) == null) {
                    this.error("Unexpected end.", new Object[0]);
                }
                this.s();
                this.pents.add(key, val);
            } else {
                byte[] key = this.name(true);
                this.checkS();
                byte[] val = this.entityValue(false);
                if (val == null) {
                    val = this.externalID(true, false);
                    if (val == null) {
                        this.error("Unexpected end.", new Object[0]);
                    }
                    if (this.s()) {
                        this.check(BuildText.ND);
                        this.checkS();
                        this.name(true);
                    }
                }
                this.s();
                this.ents.add(key, val);
            }
            this.check('>');
            this.pe = true;
        } else if (this.consume(BuildText.ELEM)) {
            this.checkS();
            this.name(true);
            this.checkS();
            this.pe = true;
            if (!this.consume(BuildText.EMP) && !this.consume(BuildText.ANY)) {
                if (this.consume('(')) {
                    this.s();
                    if (this.consume(BuildText.PC)) {
                        this.s();
                        boolean alt = false;
                        while (this.consume('|')) {
                            this.s();
                            this.name(true);
                            this.s();
                            alt = true;
                        }
                        this.check(')');
                        if (!this.consume('*') && alt) {
                            this.error("Unexpected end.", new Object[0]);
                        }
                    } else {
                        this.cp();
                        this.s();
                        while (!this.consume(')')) {
                            this.consume();
                        }
                        this.occ();
                    }
                } else {
                    this.error("Unexpected end.", new Object[0]);
                }
            }
            this.s();
            this.check('>');
        } else if (this.consume(BuildText.ATTL)) {
            this.pe = true;
            this.checkS();
            this.name(true);
            this.s();
            while (this.name(false) != null) {
                this.checkS();
                if (!(this.consume(BuildText.CD) || this.consume(BuildText.IDRS) || this.consume(BuildText.IDR) || this.consume(BuildText.ID) || this.consume(BuildText.ENTS) || this.consume(BuildText.ENT1) || this.consume(BuildText.NMTS) || this.consume(BuildText.NMT))) {
                    if (this.consume(BuildText.NOT)) {
                        this.checkS();
                        this.check('(');
                        this.s();
                        this.name(true);
                        this.s();
                        while (this.consume('|')) {
                            this.s();
                            this.name(true);
                            this.s();
                        }
                        this.check(')');
                    } else {
                        this.check('(');
                        this.s();
                        this.nmtoken();
                        this.s();
                        while (this.consume('|')) {
                            this.s();
                            this.nmtoken();
                            this.s();
                        }
                        this.check(')');
                    }
                }
                this.pe = true;
                this.checkS();
                if (!this.consume(BuildText.REQ) && !this.consume(BuildText.IMP)) {
                    if (this.consume(BuildText.FIX)) {
                        this.checkS();
                    }
                    this.quote = this.qu();
                    this.attValue(this.consume());
                }
                this.s();
            }
            this.check('>');
        } else if (this.consume(BuildText.NOTA)) {
            this.checkS();
            this.name(true);
            this.s();
            this.externalID(false, false);
            this.s();
            this.check('>');
        } else if (this.consume(BuildText.COMS)) {
            this.comment();
        } else if (this.consume(Token.XML)) {
            this.pi();
        } else {
            return false;
        }
        this.s();
        this.pe = false;
        return true;
    }

    private void cp() throws IOException {
        this.s();
        byte[] name = this.name(false);
        if (name == null) {
            this.check('(');
            this.s();
            this.cp();
        } else {
            this.occ();
        }
        this.s();
        if (this.consume('|') || this.consume(',')) {
            this.cp();
            this.s();
        }
        if (name == null) {
            this.check(')');
            this.occ();
        }
    }

    private void occ() throws IOException {
        if (!this.consume('+') && !this.consume('?')) {
            this.consume('*');
        }
    }

    private byte[] entityValue(boolean p) throws IOException {
        int ch;
        int qu = this.consume();
        if (qu != 39 && qu != 34) {
            this.prev(1);
            return null;
        }
        TokenBuilder tok = new TokenBuilder();
        while ((ch = this.nextChar()) != qu) {
            if (ch == 38) {
                tok.add(this.ref(false));
                continue;
            }
            if (ch == 37) {
                if (!p) {
                    this.error("Parameter reference not allowed here.", new Object[0]);
                }
                tok.add(this.peRef());
                continue;
            }
            tok.add(ch);
        }
        XMLInput tmp = this.input;
        this.input = new XMLInput(new IOContent(tok.finish()));
        tok = new TokenBuilder();
        while ((ch = this.consume()) != 0) {
            if (ch == 38) {
                tok.add(this.ref(false));
                continue;
            }
            tok.add(ch);
        }
        this.input = tmp;
        return tok.finish();
    }

    private boolean version() throws IOException {
        if (!this.consume(BuildText.VERS)) {
            return false;
        }
        this.s();
        this.check('=');
        this.s();
        int d = this.qu();
        if (!this.consume(BuildText.VERS10) && !this.consume(BuildText.VERS11)) {
            this.error("XML version must be '1.0' or '1.1'.", new Object[0]);
        }
        this.check((char)d);
        return true;
    }

    private String encoding() throws IOException {
        if (!this.consume(BuildText.ENCOD)) {
            return null;
        }
        this.s();
        this.check('=');
        this.s();
        TokenBuilder enc = new TokenBuilder();
        int d = this.qu();
        int ch = this.nextChar();
        if (Token.letter(ch) && ch != 95) {
            while (Token.letterOrDigit(ch) || ch == 46 || ch == 45) {
                enc.add(ch);
                ch = this.nextChar();
            }
            this.prev(1);
        }
        this.check((char)d);
        if (enc.isEmpty()) {
            this.error("Invalid encoding.", enc);
        }
        String e = Token.string(enc.finish());
        this.input.encoding(e);
        return e;
    }

    private byte[] sddecl() throws IOException {
        if (!this.consume(BuildText.STANDALONE)) {
            return null;
        }
        this.s();
        this.check('=');
        this.s();
        int d = this.qu();
        byte[] sd = Token.token("yes");
        if (!this.consume(sd) && !this.consume(sd = Token.token("no"))) {
            this.error("Invalid standalone attribute in declaration.", new Object[0]);
        }
        this.check((char)d);
        return sd;
    }

    private BuildException error(String e, Object ... a) throws BuildException {
        throw new BuildException(this.det() + ": " + e, a);
    }

    @Override
    public String det() {
        String path = this.input.io().path();
        return path.isEmpty() ? Util.info(Text.LINE_X, this.input.line()) : Util.info(Text.SCANPOS_X_X, this.input.io().path(), this.input.line());
    }

    @Override
    public double prog() {
        double l = this.input.length();
        return l <= 0.0 ? 0.0 : (double)this.input.pos() / l;
    }

    private static enum State {
        CONTENT,
        TAG,
        ATT,
        QUOTE;

    }
}

