/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import java.io.IOException;
import java.io.InputStream;
import org.basex.io.IO;
import org.basex.io.in.TextInput;
import org.basex.util.TokenBuilder;

public final class NewlineInput
extends TextInput {
    private int next = -2;

    public NewlineInput(InputStream is) throws IOException {
        super(is);
    }

    public NewlineInput(IO in) throws IOException {
        super(in);
    }

    @Override
    public NewlineInput encoding(String encoding) throws IOException {
        super.encoding(encoding);
        return this;
    }

    @Override
    public int read() throws IOException {
        int n = this.next;
        if (n != -2) {
            this.next = -2;
        } else {
            n = super.read();
        }
        if (n != 13) {
            return n;
        }
        n = super.read();
        if (n != 10) {
            this.next = n;
        }
        return 10;
    }

    public String readLine() throws IOException {
        TokenBuilder tb = this.readLine(new TokenBuilder());
        return tb == null ? null : tb.toString();
    }

    public TokenBuilder readLine(TokenBuilder tb) throws IOException {
        tb.reset();
        int ch;
        while ((ch = this.read()) != -1) {
            if (ch == 10) {
                return tb;
            }
            tb.add(ch);
        }
        return tb.isEmpty() ? null : tb;
    }
}

