/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.flwor;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.flwor.ForLet;
import org.basex.query.iter.Iter;
import org.basex.query.util.Var;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class For
extends ForLet {
    final Var pos;
    final Var score;

    public For(InputInfo ii, Expr e, Var v) {
        this(ii, e, v, null, null);
    }

    public For(InputInfo ii, Expr e, Var v, Var p, Var s) {
        super(ii, e, v);
        this.pos = p;
        this.score = s;
    }

    @Override
    public For compile(QueryContext ctx) throws QueryException {
        this.expr = this.expr.compile(ctx);
        this.type = this.expr.type();
        this.size = this.expr.size();
        if (ctx.grouping) {
            this.var.ret = SeqType.get(this.type.type, SeqType.Occ.ZERO_MORE);
        } else {
            this.var.size = Math.min(1L, this.size);
            this.var.ret = this.type.type.seqType();
        }
        ctx.vars.add(this.var);
        if (this.pos != null) {
            ctx.vars.add(this.pos);
        }
        if (this.score != null) {
            ctx.vars.add(this.score);
        }
        return this;
    }

    @Override
    public Iter iter(final QueryContext ctx) {
        final Var v = this.var.copy();
        final Var p = this.pos != null ? this.pos.copy() : null;
        final Var s = this.score != null ? this.score.copy() : null;
        return new Iter(){
            private int vs;
            private Iter ir;
            private int c;

            @Override
            public Item next() throws QueryException {
                this.init();
                Item it = this.ir.next();
                if (it != null) {
                    return this.bind(it, ++this.c);
                }
                this.reset();
                return null;
            }

            @Override
            public long size() {
                return For.this.expr.size();
            }

            @Override
            public Item get(long i) throws QueryException {
                this.init();
                return this.bind(this.ir.get(i), i + 1L);
            }

            @Override
            public boolean reset() {
                if (this.ir != null) {
                    ctx.vars.size(this.vs);
                    this.ir.reset();
                    this.ir = null;
                    this.c = 0;
                }
                return true;
            }

            private void init() throws QueryException {
                if (this.ir == null) {
                    this.vs = ctx.vars.size();
                    this.ir = ctx.iter(For.this.expr);
                    ctx.vars.add(v);
                    if (p != null) {
                        ctx.vars.add(p);
                    }
                    if (s != null) {
                        ctx.vars.add(s);
                    }
                }
            }

            private Item bind(Item it, long i) throws QueryException {
                v.bind(it, ctx);
                if (p != null) {
                    p.bind(Int.get(i), ctx);
                }
                if (s != null) {
                    s.bind(Dbl.get(it.score()), ctx);
                }
                return it;
            }
        };
    }

    @Override
    boolean simple(boolean one) {
        return this.pos == null && this.score == null && (!one || this.type.one() || this.size == 1L);
    }

    @Override
    public boolean declares(Var v) {
        return this.var.is(v) || this.pos != null && this.pos.is(v) || this.score != null && this.score.is(v);
    }

    @Override
    public Var[] vars() {
        if (this.pos != null) {
            if (this.score != null) {
                return new Var[]{this.var, this.pos, this.score};
            }
            return new Var[]{this.var, this.pos};
        }
        if (this.score != null) {
            return new Var[]{this.var, this.score};
        }
        return new Var[]{this.var};
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.VAR, this.var, QueryText.POS, this.pos, "score", this.score), this.expr);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("for " + this.var + ' ');
        if (this.pos != null) {
            sb.append("at " + this.pos + ' ');
        }
        if (this.score != null) {
            sb.append("score " + this.score + ' ');
        }
        return sb.append("in " + this.expr).toString();
    }
}

