/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.flwor;

import java.util.ArrayList;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.And;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.If;
import org.basex.query.expr.ParseExpr;
import org.basex.query.flwor.FLWR;
import org.basex.query.flwor.For;
import org.basex.query.flwor.ForLet;
import org.basex.query.flwor.Group;
import org.basex.query.flwor.Let;
import org.basex.query.flwor.Order;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.path.AxisPath;
import org.basex.query.util.ExprList;
import org.basex.query.util.ValueList;
import org.basex.query.util.Var;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public class GFLWOR
extends ParseExpr {
    Expr ret;
    ForLet[] fl;
    Expr where;
    private Order order;
    private final Group group;

    GFLWOR(ForLet[] f, Expr w, Order o, Group g, Expr r, InputInfo ii) {
        super(ii);
        this.ret = r;
        this.fl = f;
        this.where = w;
        this.group = g;
        this.order = o;
    }

    public static GFLWOR get(ForLet[] fl, Expr whr, Order ord, Group grp, Expr ret, InputInfo ii) {
        return ord == null && grp == null ? new FLWR(fl, whr, ret, ii) : new GFLWOR(fl, whr, ord, grp, ret, ii);
    }

    @Override
    public void checkUp() throws QueryException {
        for (ForLet f : this.fl) {
            f.checkUp();
        }
        this.checkNoneUp(this.where, this.group, this.order);
        this.ret.checkUp();
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        this.compHoist(ctx);
        this.compWhere(ctx);
        boolean grp = ctx.grouping;
        ctx.grouping = this.group != null;
        int vs = ctx.vars.size();
        for (int f = 0; f < this.fl.length; ++f) {
            ForLet flt = this.fl[f].compile(ctx);
            boolean let = true;
            for (int g = f + 1; g < this.fl.length; ++g) {
                let &= flt instanceof Let;
            }
            if (!flt.expr.isValue() && (!let || this.count(flt.var, f) != 1)) continue;
            flt.bind(ctx);
        }
        boolean empty = false;
        if (this.where != null) {
            this.where = this.where.compile(ctx).compEbv(ctx);
            if (this.where.isValue()) {
                boolean bl = empty = !this.where.ebv(ctx, this.info).bool(this.info);
                if (!empty) {
                    ctx.compInfo("%: removing %", this.description(), this.where);
                    this.where = null;
                }
            }
        }
        if (this.group != null) {
            this.group.compile(ctx);
        }
        if (this.order != null) {
            this.order.compile(ctx);
        }
        this.ret = this.ret.compile(ctx);
        ctx.vars.size(vs);
        ctx.grouping = grp;
        if (empty) {
            ctx.compInfo("%: removing %", this.description(), this.where);
            return Empty.SEQ;
        }
        if (this.ret == Empty.SEQ) {
            ctx.compInfo("simplifying flwor expression", new Object[0]);
            return this.ret;
        }
        for (int f = 0; f < this.fl.length; ++f) {
            ForLet l = this.fl[f];
            if (l.var.expr() == null && (!l.simple(true) || this.count(l.var, f) != 0 || l.expr.uses(Expr.Use.NDT))) continue;
            ctx.compInfo("removing variable %", l.var);
            this.fl = Array.delete(this.fl, f--);
        }
        if (this.fl.length == 0) {
            ctx.compInfo("simplifying flwor expression", new Object[0]);
            return this.where != null ? new If(this.info, this.where, this.ret, (Expr)Empty.SEQ) : this.ret;
        }
        for (ForLet f : this.fl) {
            if (!(f instanceof For) || f.size() != 0L) continue;
            ctx.compInfo("simplifying flwor expression", new Object[0]);
            return Empty.SEQ;
        }
        if (this.where == null && this.group == null) {
            this.size = this.ret.size();
            if (this.size != -1L) {
                for (ForLet f : this.fl) {
                    long s = f.size();
                    if (s == -1L) {
                        this.size = s;
                        break;
                    }
                    this.size *= s;
                }
            }
        }
        this.type = SeqType.get(this.ret.type().type, this.size);
        this.compHoist(ctx);
        return this;
    }

    private void compHoist(QueryContext ctx) {
        int m = 0;
        for (int i = 1; i < this.fl.length; ++i) {
            ForLet in = this.fl[i];
            if (in.size() != 1L || in.uses(Expr.Use.NDT) || in.uses(Expr.Use.CNS)) continue;
            int p = -1;
            int o = i;
            while (o-- != 0 && in.count(this.fl[o]) == 0) {
                p = o;
            }
            if (p == -1) continue;
            Array.move(this.fl, p, 1, i - p);
            this.fl[p] = in;
            if (m++ != 0) continue;
            ctx.compInfo("moving for/let clauses", new Object[0]);
        }
    }

    private void compWhere(QueryContext ctx) {
        Expr[] exprArray;
        if (this.where == null) {
            return;
        }
        for (ForLet f : this.fl) {
            if (!(f instanceof For) || f.simple(false) && this.where.removable(f.var)) continue;
            return;
        }
        if (this.where instanceof And) {
            exprArray = ((And)this.where).expr;
        } else {
            Expr[] exprArray2 = new Expr[1];
            exprArray = exprArray2;
            exprArray2[0] = this.where;
        }
        Expr[] tests = exprArray;
        int[] tar = new int[tests.length];
        block1: for (int t = 0; t < tests.length; ++t) {
            int fr = -1;
            for (int f = this.fl.length - 1; f >= 0; --f) {
                if (this.fl[f] instanceof For) {
                    fr = f;
                }
                if (tests[t].count(this.fl[f].var) == 0) continue;
                if (fr == -1) {
                    return;
                }
                tar[t] = fr;
                continue block1;
            }
        }
        ctx.compInfo("rewriting where clause to predicate(s)", new Object[0]);
        for (int f = 0; f < this.fl.length; ++f) {
            Expr e;
            ForLet c = this.fl[f];
            ExprList el = new ExprList();
            for (int t = 0; t < tests.length; ++t) {
                if (tar[t] != f) continue;
                el.add(tests[t].remove(c.var));
            }
            if (el.isEmpty()) continue;
            Expr a = el.size() == 1 ? ((e = el.get(0)).type().mayBeNumber() ? Function.BOOLEAN.get(this.info, e) : e) : new And(this.info, el.finish());
            c.expr = c.expr instanceof AxisPath ? ((AxisPath)c.expr).addPreds(a) : (c.expr instanceof Filter ? ((Filter)c.expr).addPred(a) : new Filter(this.info, c.expr, a));
        }
        this.where = null;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Iter[] iter = new Iter[this.fl.length];
        int vs = ctx.vars.size();
        for (int f = 0; f < this.fl.length; ++f) {
            iter[f] = ctx.iter(this.fl[f]);
        }
        ArrayList<Item[]> keys = null;
        ValueList vals = null;
        if (this.order != null) {
            keys = new ArrayList<Item[]>();
            vals = new ValueList();
        }
        if (this.group != null) {
            this.group.init(this.order);
        }
        this.iter(ctx, iter, 0, keys, vals);
        ctx.vars.size(vs);
        for (ForLet f : this.fl) {
            ctx.vars.add(f.var);
        }
        Iter ir = this.group != null ? this.group.gp.ret(ctx, this.ret, keys, vals) : ctx.iter(this.order.set(keys, vals));
        ctx.vars.size(vs);
        return ir;
    }

    private void iter(QueryContext ctx, Iter[] it, int p, ArrayList<Item[]> ks, ValueList vs) throws QueryException {
        boolean more;
        boolean bl = more = p + 1 != this.fl.length;
        while (it[p].next() != null) {
            if (more) {
                this.iter(ctx, it, p + 1, ks, vs);
                continue;
            }
            if (this.where != null && !this.where.ebv(ctx, this.info).bool(this.info)) continue;
            if (this.group != null) {
                this.group.gp.add(ctx);
                continue;
            }
            if (this.order == null) continue;
            this.order.add(ctx, this.ret, ks, vs);
        }
    }

    @Override
    public final boolean uses(Expr.Use u) {
        for (ForLet f : this.fl) {
            if (!f.uses(u)) continue;
            return true;
        }
        return this.where != null && this.where.uses(u) || this.order != null && this.order.uses(u) || this.group != null && this.group.uses(u) || this.ret.uses(u);
    }

    @Override
    public final int count(Var v) {
        return this.count(v, 0);
    }

    final int count(Var v, int i) {
        int c = 0;
        for (int f = i; f < this.fl.length; ++f) {
            c += this.fl[f].count(v);
        }
        if (this.where != null) {
            c += this.where.count(v);
        }
        if (this.order != null) {
            c += this.order.count(v);
        }
        if (this.group != null) {
            c += this.group.count(v);
        }
        return c + this.ret.count(v);
    }

    @Override
    public final boolean removable(Var v) {
        for (ForLet f : this.fl) {
            if (f.removable(v)) continue;
            return false;
        }
        return !(this.where != null && !this.where.removable(v) || this.order != null && !this.order.removable(v) || this.group != null && !this.group.removable(v) || !this.ret.removable(v));
    }

    @Override
    public final Expr remove(Var v) {
        for (ForLet f : this.fl) {
            f.remove(v);
        }
        if (this.where != null) {
            this.where = this.where.remove(v);
        }
        if (this.order != null) {
            this.order = this.order.remove(v);
        }
        this.ret = this.ret.remove(v);
        return this;
    }

    @Override
    public boolean databases(StringList db) {
        for (ForLet f : this.fl) {
            if (f.databases(db)) continue;
            return false;
        }
        return !(this.where != null && !this.where.databases(db) || this.order != null && !this.order.databases(db) || this.group != null && !this.group.databases(db) || !this.ret.databases(db));
    }

    @Override
    public final void plan(FElem plan) {
        FElem el = this.planElem(new Object[0]);
        this.addPlan(plan, el, this.fl);
        if (this.where != null) {
            this.addPlan(el, new FElem(QueryText.WHR), this.where);
        }
        if (this.group != null) {
            this.group.plan(el);
        }
        if (this.order != null) {
            this.order.plan(el);
        }
        this.addPlan(el, new FElem(QueryText.RET), this.ret);
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i != this.fl.length; ++i) {
            sb.append(i != 0 ? " " : "").append(this.fl[i]);
        }
        if (this.where != null) {
            sb.append(" where " + this.where);
        }
        if (this.group != null) {
            sb.append(this.group);
        }
        if (this.order != null) {
            sb.append(this.order);
        }
        return sb.append(" return " + this.ret).toString();
    }
}

