/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncParams;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeSeqBuilder;
import org.basex.query.util.ANodeList;
import org.basex.query.util.Err;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FTxt;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.hash.TokenMap;

public final class FNSql
extends StandardFunc {
    private static final byte[] INT = AtomType.INT.string();
    private static final byte[] STRING = AtomType.STR.string();
    private static final byte[] BOOL = AtomType.BLN.string();
    private static final byte[] DATE = AtomType.DAT.string();
    private static final byte[] DOUBLE = AtomType.DBL.string();
    private static final byte[] FLOAT = AtomType.FLT.string();
    private static final byte[] SHORT = AtomType.SHR.string();
    private static final byte[] TIME = AtomType.TIM.string();
    private static final byte[] TIMESTAMP = Token.token("timestamp");
    private static final QNm Q_ROW = new QNm("sql:row", QueryText.SQLURI);
    private static final QNm Q_COLUMN = new QNm("sql:column", QueryText.SQLURI);
    private static final QNm Q_NAME = new QNm("name");
    private static final QNm E_OPS = new QNm("options", QueryText.SQLURI);
    private static final QNm E_PARAMS = new QNm("parameters", QueryText.SQLURI);
    private static final QNm E_PARAM = new QNm("parameter", QueryText.SQLURI);
    private static final byte[] AUTO_COMM = Token.token("autocommit");
    private static final String USER = "user";
    private static final String PASS = "password";
    private static final Atts NS_SQL = new Atts(QueryText.SQL, QueryText.SQLURI);
    private static final byte[] TYPE = Token.token("type");

    public FNSql(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        this.checkCreate(ctx);
        switch (this.sig) {
            case _SQL_EXECUTE: {
                return this.execute(ctx);
            }
            case _SQL_EXECUTE_PREPARED: {
                return this.executePrepared(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.checkCreate(ctx);
        switch (this.sig) {
            case _SQL_INIT: {
                return this.init(ctx);
            }
            case _SQL_CONNECT: {
                return this.connect(ctx);
            }
            case _SQL_PREPARE: {
                return this.prepare(ctx);
            }
            case _SQL_CLOSE: {
                return this.close(ctx);
            }
            case _SQL_COMMIT: {
                return this.commit(ctx);
            }
            case _SQL_ROLLBACK: {
                return this.rollback(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Item init(QueryContext ctx) throws QueryException {
        String driver = Token.string(this.checkStr(this.expr[0], ctx));
        if (Reflect.find(driver) == null) {
            Err.BXSQ_DRIVER.thrw(this.info, driver);
        }
        return null;
    }

    private Int connect(QueryContext ctx) throws QueryException {
        String url = Token.string(this.checkStr(this.expr[0], ctx));
        try {
            if (this.expr.length > 2) {
                String user = Token.string(this.checkStr(this.expr[1], ctx));
                String pass = Token.string(this.checkStr(this.expr[2], ctx));
                if (this.expr.length == 4) {
                    Item opt = this.expr[3].item(ctx, this.info);
                    TokenMap options = new FuncParams(E_OPS, this.info).parse(opt);
                    boolean ac = true;
                    byte[] commit = options.get(AUTO_COMM);
                    if (commit != null) {
                        ac = Token.eq(commit, Token.TRUE);
                        options.delete(AUTO_COMM);
                    }
                    Properties props = FNSql.connProps(options);
                    props.setProperty(USER, user);
                    props.setProperty(PASS, pass);
                    Connection conn = DriverManager.getConnection(url, props);
                    conn.setAutoCommit(ac);
                    return Int.get(ctx.jdbc().add(conn));
                }
                return Int.get(ctx.jdbc().add(DriverManager.getConnection(url, user, pass)));
            }
            return Int.get(ctx.jdbc().add(DriverManager.getConnection(url)));
        }
        catch (SQLException ex) {
            throw Err.BXSQ_ERROR.thrw(this.info, ex);
        }
    }

    private static Properties connProps(TokenMap options) {
        Properties props = new Properties();
        for (byte[] next : options.keys()) {
            if (next == null) continue;
            props.setProperty(Token.string(next), Token.string(options.get(next)));
        }
        return props;
    }

    private Int prepare(QueryContext ctx) throws QueryException {
        Connection conn = this.connection(ctx, false);
        byte[] prepStmt = this.checkStr(this.expr[1], ctx);
        try {
            PreparedStatement prep = conn.prepareStatement(Token.string(prepStmt));
            return Int.get(ctx.jdbc().add(prep));
        }
        catch (SQLException ex) {
            throw Err.BXSQ_ERROR.thrw(this.info, ex);
        }
    }

    private NodeSeqBuilder execute(QueryContext ctx) throws QueryException {
        int id = (int)this.checkItr(this.expr[0].item(ctx, this.info));
        Object obj = ctx.jdbc().get(id);
        if (!(obj instanceof Connection)) {
            Err.BXSQ_CONN.thrw(this.info, id);
        }
        String query = Token.string(this.checkStr(ctx.iter(this.expr[1]).next(), ctx));
        Statement stmt = null;
        try {
            stmt = ((Connection)obj).createStatement();
            boolean result = stmt.execute(query);
            NodeSeqBuilder nodeSeqBuilder = result ? this.buildResult(stmt.getResultSet()) : new NodeSeqBuilder();
            return nodeSeqBuilder;
        }
        catch (SQLException ex) {
            throw Err.BXSQ_ERROR.thrw(this.info, ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    private NodeSeqBuilder executePrepared(QueryContext ctx) throws QueryException {
        int id = (int)this.checkItr(this.expr[0].item(ctx, this.info));
        Object obj = ctx.jdbc().get(id);
        if (!(obj instanceof PreparedStatement)) {
            Err.BXSQ_STATE.thrw(this.info, id);
        }
        long c = 0L;
        ANode params = null;
        if (this.expr.length > 1) {
            params = (ANode)this.checkType(this.expr[1].item(ctx, this.info), NodeType.ELM);
            if (!params.qname().eq(E_PARAMS)) {
                Err.ELMOPTION.thrw(this.info, params.qname());
            }
            c = FNSql.countParams(params);
        }
        try {
            PreparedStatement stmt = (PreparedStatement)obj;
            if (c != (long)stmt.getParameterMetaData().getParameterCount()) {
                Err.BXSQ_PARAMS.thrw(this.info, new Object[0]);
            }
            if (params != null) {
                this.setParameters(params.children(), stmt);
            }
            return stmt.execute() ? this.buildResult(stmt.getResultSet()) : new NodeSeqBuilder();
        }
        catch (SQLException ex) {
            throw Err.BXSQ_ERROR.thrw(this.info, ex);
        }
    }

    private static long countParams(ANode params) {
        AxisMoreIter ch = params.children();
        long c = ch.size();
        if (c == -1L) {
            do {
                ++c;
            } while (ch.next() != null);
        }
        return c;
    }

    private void setParameters(AxisMoreIter params, PreparedStatement stmt) throws QueryException {
        ANode next;
        int i = 0;
        while ((next = params.next()) != null) {
            ANode attr;
            if (!next.qname().eq(E_PARAM)) {
                Err.ELMOPTION.thrw(this.info, next.qname());
            }
            AxisMoreIter attrs = next.attributes();
            byte[] paramType = null;
            boolean isNull = false;
            while ((attr = attrs.next()) != null) {
                if (Token.eq(attr.name(), TYPE)) {
                    paramType = attr.string();
                    continue;
                }
                if (Token.eq(attr.name(), Token.NULL)) {
                    isNull = attr.string() != null && Bln.parse(attr.string(), this.info);
                    continue;
                }
                throw Err.BXSQ_ATTR.thrw(this.info, Token.string(attr.name()));
            }
            if (paramType == null) {
                Err.BXSQ_TYPE.thrw(this.info, new Object[0]);
            }
            byte[] v = next.string();
            this.setParam(++i, stmt, paramType, isNull ? null : Token.string(v), isNull);
        }
    }

    private void setParam(int index, PreparedStatement stmt, byte[] paramType, String value, boolean isNull) throws QueryException {
        block30: {
            try {
                if (Token.eq(BOOL, paramType)) {
                    if (isNull) {
                        stmt.setNull(index, 16);
                    } else {
                        stmt.setBoolean(index, Boolean.parseBoolean(value));
                    }
                    break block30;
                }
                if (Token.eq(DATE, paramType)) {
                    if (isNull) {
                        stmt.setNull(index, 91);
                    } else {
                        stmt.setDate(index, Date.valueOf(value));
                    }
                    break block30;
                }
                if (Token.eq(DOUBLE, paramType)) {
                    if (isNull) {
                        stmt.setNull(index, 8);
                    } else {
                        stmt.setDouble(index, Double.parseDouble(value));
                    }
                    break block30;
                }
                if (Token.eq(FLOAT, paramType)) {
                    if (isNull) {
                        stmt.setNull(index, 6);
                    } else {
                        stmt.setFloat(index, Float.parseFloat(value));
                    }
                    break block30;
                }
                if (Token.eq(INT, paramType)) {
                    if (isNull) {
                        stmt.setNull(index, 4);
                    } else {
                        stmt.setInt(index, Integer.parseInt(value));
                    }
                    break block30;
                }
                if (Token.eq(SHORT, paramType)) {
                    if (isNull) {
                        stmt.setNull(index, 5);
                    } else {
                        stmt.setShort(index, Short.parseShort(value));
                    }
                    break block30;
                }
                if (Token.eq(STRING, paramType)) {
                    if (isNull) {
                        stmt.setNull(index, 12);
                    } else {
                        stmt.setString(index, value);
                    }
                    break block30;
                }
                if (Token.eq(TIME, paramType)) {
                    if (isNull) {
                        stmt.setNull(index, 92);
                    } else {
                        stmt.setTime(index, Time.valueOf(value));
                    }
                    break block30;
                }
                if (Token.eq(TIMESTAMP, paramType)) {
                    if (isNull) {
                        stmt.setNull(index, 93);
                    } else {
                        stmt.setTimestamp(index, Timestamp.valueOf(value));
                    }
                    break block30;
                }
                throw Err.BXSQ_ERROR.thrw(this.info, "unsupported type: " + Token.string(paramType));
            }
            catch (SQLException ex) {
                throw Err.BXSQ_ERROR.thrw(this.info, ex);
            }
            catch (IllegalArgumentException ex) {
                throw Err.BXSQ_FORMAT.thrw(this.info, Token.string(paramType));
            }
        }
    }

    private NodeSeqBuilder buildResult(ResultSet rs) throws QueryException {
        try {
            ResultSetMetaData metadata = rs.getMetaData();
            int cc = metadata.getColumnCount();
            NodeSeqBuilder rows = new NodeSeqBuilder();
            while (rs.next()) {
                ANodeList columns = new ANodeList(cc);
                for (int k = 1; k <= cc; ++k) {
                    String label = metadata.getColumnLabel(k);
                    Object value = rs.getObject(label);
                    if (value == null) continue;
                    FAttr columnName = new FAttr(Q_NAME, Token.token(label));
                    ANodeList attr = new ANodeList(columnName);
                    FTxt columnValue = new FTxt(Token.token(value.toString()));
                    ANodeList ch = new ANodeList(columnValue);
                    columns.add(new FElem(Q_COLUMN, ch, attr, NS_SQL));
                }
                rows.add(new FElem(Q_ROW, columns, null, NS_SQL));
            }
            return rows;
        }
        catch (SQLException ex) {
            throw Err.BXSQ_ERROR.thrw(this.info, ex);
        }
    }

    private Item close(QueryContext ctx) throws QueryException {
        try {
            this.connection(ctx, true).close();
            return null;
        }
        catch (SQLException ex) {
            throw Err.BXSQ_ERROR.thrw(this.info, ex);
        }
    }

    private Item commit(QueryContext ctx) throws QueryException {
        try {
            this.connection(ctx, false).commit();
            return null;
        }
        catch (SQLException ex) {
            throw Err.BXSQ_ERROR.thrw(this.info, ex);
        }
    }

    private Item rollback(QueryContext ctx) throws QueryException {
        try {
            this.connection(ctx, false).rollback();
            return null;
        }
        catch (SQLException ex) {
            throw Err.BXSQ_ERROR.thrw(this.info, ex);
        }
    }

    private Connection connection(QueryContext ctx, boolean del) throws QueryException {
        int id = (int)this.checkItr(this.expr[0].item(ctx, this.info));
        Object obj = ctx.jdbc().get(id);
        if (obj == null || !(obj instanceof Connection)) {
            Err.BXSQ_CONN.thrw(this.info, id);
        }
        if (del) {
            ctx.jdbc().remove(id);
        }
        return (Connection)obj;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.NDT || super.uses(u);
    }
}

