/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.data.ExprInfo;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.util.Err;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class RangeSeq
extends Seq {
    private final long start;

    public RangeSeq(long s, long sz) {
        super(sz);
        this.start = s;
    }

    @Override
    public Object toJava() {
        long[] obj = new long[(int)this.size];
        int s = 0;
        while ((long)s < this.size) {
            obj[s] = this.start + (long)s;
            ++s;
        }
        return obj;
    }

    @Override
    public Item ebv(QueryContext ctx, InputInfo ii) throws QueryException {
        throw Err.CONDTYPE.thrw(ii, this);
    }

    @Override
    public SeqType type() {
        return SeqType.ITR_OM;
    }

    @Override
    public boolean iterable() {
        return true;
    }

    @Override
    public int writeTo(Item[] arr, int pos) {
        int i = 0;
        while ((long)i < this.size) {
            arr[pos + i] = this.itemAt(i);
            ++i;
        }
        return (int)this.size;
    }

    @Override
    public Item itemAt(long pos) {
        return Int.get(this.start + pos);
    }

    @Override
    public boolean homogenous() {
        return true;
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.MIN, this.start, QueryText.MAX, this.start + this.size - 1L), new ExprInfo[0]);
    }

    @Override
    public String toString() {
        return "(" + this.start + ' ' + "to" + ' ' + (this.start + this.size - 1L) + ")";
    }
}

