/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.math.BigDecimal;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.util.Err;
import org.basex.query.util.NSGlobal;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.DTd;
import org.basex.query.value.item.Dat;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.GDt;
import org.basex.query.value.item.Hex;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Jav;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Tim;
import org.basex.query.value.item.Uri;
import org.basex.query.value.item.YMDur;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;

public enum AtomType implements Type
{
    ITEM("item", null, Token.EMPTY, false, false, false, false, false, 32),
    UTY("untyped", null, QueryText.XSURI, false, false, false, false, false, 33),
    ATY("anyType", null, QueryText.XSURI, false, false, false, false, false, 34),
    AST("anySimpleType", null, QueryText.XSURI, false, false, false, false, false, 35),
    AAT("anyAtomicType", ITEM, QueryText.XSURI, false, false, false, false, false, 36){

        @Override
        public Atm cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return new Atm(it.string(ii));
        }

        @Override
        public Atm cast(Object o, InputInfo ii) {
            return new Atm(o.toString());
        }
    }
    ,
    ATM("untypedAtomic", AAT, QueryText.XSURI, false, true, true, false, false, 37){

        @Override
        public Atm cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return new Atm(it.string(ii));
        }

        @Override
        public Atm cast(Object o, InputInfo ii) {
            return new Atm(o.toString());
        }
    }
    ,
    STR("string", AAT, QueryText.XSURI, false, false, true, false, false, 38){

        @Override
        public Str cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return Str.get(it.string(ii));
        }

        @Override
        public Str cast(Object o, InputInfo ii) {
            return Str.get(o);
        }
    }
    ,
    NST("normalizedString", STR, QueryText.XSURI, false, false, true, false, false, 39){

        @Override
        public Str cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return new Str(it.string(ii), this);
        }

        @Override
        public Str cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    TOK("token", NST, QueryText.XSURI, false, false, true, false, false, 40){

        @Override
        public Str cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return new Str(Token.norm(it.string(ii)), this);
        }

        @Override
        public Str cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    LAN("language", TOK, QueryText.XSURI, false, false, true, false, false, 41){

        @Override
        public Str cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            byte[] v = Token.norm(it.string(ii));
            if (!LANGPATTERN.matcher(Token.string(v)).matches()) {
                this.error(it, ii);
            }
            return new Str(v, this);
        }

        @Override
        public Str cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    NMT("NMTOKEN", TOK, QueryText.XSURI, false, false, true, false, false, 42){

        @Override
        public Str cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            byte[] v = Token.norm(it.string(ii));
            if (!XMLToken.isNMToken(v)) {
                this.error(it, ii);
            }
            return new Str(v, this);
        }

        @Override
        public Str cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    NAM("Name", TOK, QueryText.XSURI, false, false, true, false, false, 43){

        @Override
        public Str cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            byte[] v = Token.norm(it.string(ii));
            if (!XMLToken.isName(v)) {
                this.error(it, ii);
            }
            return new Str(v, this);
        }

        @Override
        public Str cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    NCN("NCName", NAM, QueryText.XSURI, false, false, true, false, false, 44){

        @Override
        public Str cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return new Str(this.checkName(it, ii), this);
        }

        @Override
        public Str cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    ID("ID", NCN, QueryText.XSURI, false, false, true, false, false, 45){

        @Override
        public Str cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return new Str(this.checkName(it, ii), this);
        }

        @Override
        public Str cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    IDR("IDREF", NCN, QueryText.XSURI, false, false, true, false, false, 46){

        @Override
        public Str cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return new Str(this.checkName(it, ii), this);
        }

        @Override
        public Str cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    ENT("ENTITY", NCN, QueryText.XSURI, false, false, true, false, false, 47){

        @Override
        public Str cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return new Str(this.checkName(it, ii), this);
        }

        @Override
        public Str cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    FLT("float", AAT, QueryText.XSURI, true, false, false, false, false, 48){

        @Override
        public Flt cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return Flt.get(this.checkNum(it, ii).flt(ii));
        }

        @Override
        public Flt cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    DBL("double", AAT, QueryText.XSURI, true, false, false, false, false, 49){

        @Override
        public Dbl cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return Dbl.get(this.checkNum(it, ii).dbl(ii));
        }

        @Override
        public Dbl cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    DEC("decimal", AAT, QueryText.XSURI, true, false, false, false, false, 50){

        @Override
        public Dec cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return Dec.get(this.checkNum(it, ii).dec(ii));
        }

        @Override
        public Dec cast(Object o, InputInfo ii) {
            return Dec.get(new BigDecimal(o.toString()));
        }
    }
    ,
    PDC("precisionDecimal", null, Token.EMPTY, false, false, false, false, false, 51),
    ITR("integer", DEC, QueryText.XSURI, true, false, false, false, false, 52){

        @Override
        public Int cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.cast(it, ii);
        }

        @Override
        public Int cast(Object o, InputInfo ii) throws QueryException {
            return Int.get(this.checkLong(o, 0L, 0L, ii));
        }
    }
    ,
    NPI("nonPositiveInteger", ITR, QueryText.XSURI, true, false, false, false, false, 53){

        @Override
        public Int cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.cast(it, ii);
        }

        @Override
        public Int cast(Object o, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, Long.MIN_VALUE, 0L, ii), this);
        }
    }
    ,
    NIN("negativeInteger", NPI, QueryText.XSURI, true, false, false, false, false, 54){

        @Override
        public Int cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.cast(it, ii);
        }

        @Override
        public Int cast(Object o, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, Long.MIN_VALUE, -1L, ii), this);
        }
    }
    ,
    LNG("long", ITR, QueryText.XSURI, true, false, false, false, false, 55){

        @Override
        public Int cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type.isDate() ? new Int((ADate)it) : this.cast(it, ii);
        }

        @Override
        public Int cast(Object o, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, 0L, 0L, ii), this);
        }
    }
    ,
    INT("int", LNG, QueryText.XSURI, true, false, false, false, false, 56){

        @Override
        public Int cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.cast(it, ii);
        }

        @Override
        public Int cast(Object o, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, Integer.MIN_VALUE, Integer.MAX_VALUE, ii), this);
        }
    }
    ,
    SHR("short", INT, QueryText.XSURI, true, false, false, false, false, 57){

        @Override
        public Int cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.cast(it, ii);
        }

        @Override
        public Int cast(Object o, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, -32768L, 32767L, ii), this);
        }
    }
    ,
    BYT("byte", SHR, QueryText.XSURI, true, false, false, false, false, 58){

        @Override
        public Int cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.cast(it, ii);
        }

        @Override
        public Int cast(Object o, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, -128L, 127L, ii), this);
        }
    }
    ,
    NNI("nonNegativeInteger", ITR, QueryText.XSURI, true, false, false, false, false, 59){

        @Override
        public Int cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.cast(it, ii);
        }

        @Override
        public Int cast(Object o, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, 0L, Long.MAX_VALUE, ii), this);
        }
    }
    ,
    ULN("unsignedLong", NNI, QueryText.XSURI, true, false, false, false, false, 60){
        final BigDecimal max = new BigDecimal(Long.MAX_VALUE).multiply(BigDecimal.valueOf(2L)).add(BigDecimal.ONE);

        @Override
        public Dec cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            BigDecimal v = this.checkNum(it, ii).dec(ii);
            if (v.signum() < 0 || v.compareTo(this.max) > 0 || it.type.isString() && Token.contains(it.string(ii), 46)) {
                Err.FUNCAST.thrw(ii, this, it);
            }
            return new Dec(v, this);
        }

        @Override
        public Dec cast(Object o, InputInfo ii) {
            return new Dec(Token.token(o.toString()));
        }
    }
    ,
    UIN("unsignedInt", ULN, QueryText.XSURI, true, false, false, false, false, 61){

        @Override
        public Int cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.cast(it, ii);
        }

        @Override
        public Int cast(Object o, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, 0L, 0xFFFFFFFFL, ii), this);
        }
    }
    ,
    USH("unsignedShort", UIN, QueryText.XSURI, true, false, false, false, false, 62){

        @Override
        public Int cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.cast(it, ii);
        }

        @Override
        public Int cast(Object o, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, 0L, 65535L, ii), this);
        }
    }
    ,
    UBY("unsignedByte", USH, QueryText.XSURI, true, false, false, false, false, 63){

        @Override
        public Int cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.cast(it, ii);
        }

        @Override
        public Int cast(Object o, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, 0L, 255L, ii), this);
        }
    }
    ,
    PIN("positiveInteger", NNI, QueryText.XSURI, true, false, false, false, false, 64){

        @Override
        public Int cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.cast(it, ii);
        }

        @Override
        public Int cast(Object o, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, 1L, Long.MAX_VALUE, ii), this);
        }
    }
    ,
    DUR("duration", AAT, QueryText.XSURI, false, false, false, true, false, 65){

        @Override
        public Item cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type.isDuration() ? new Dur((Dur)it) : (29.str(it) ? new Dur(it.string(ii), ii) : this.error(it, ii));
        }

        @Override
        public Item cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    YMD("yearMonthDuration", DUR, QueryText.XSURI, false, false, false, true, false, 66){

        @Override
        public Item cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type.isDuration() ? new YMDur((Dur)it) : (30.str(it) ? new YMDur(it.string(ii), ii) : this.error(it, ii));
        }

        @Override
        public Item cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    DTD("dayTimeDuration", DUR, QueryText.XSURI, false, false, false, true, false, 67){

        @Override
        public Item cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type.isDuration() ? new DTd((Dur)it) : (31.str(it) ? new DTd(it.string(ii), ii) : this.error(it, ii));
        }

        @Override
        public Item cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    DTM("dateTime", AAT, QueryText.XSURI, false, false, false, false, true, 68){

        @Override
        public Item cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type == LNG ? new Dtm((Int)it, ii) : (it.type == DAT ? new Dtm((ADate)it) : (32.str(it) ? new Dtm(it.string(ii), ii) : this.error(it, ii)));
        }

        @Override
        public Item cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    DTS("dateTimeStamp", null, Token.EMPTY, false, false, false, false, true, 69),
    DAT("date", AAT, QueryText.XSURI, false, false, false, false, true, 70){

        @Override
        public Item cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type == DTM ? new Dat((ADate)it) : (33.str(it) ? new Dat(it.string(ii), ii) : this.error(it, ii));
        }

        @Override
        public Item cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    TIM("time", AAT, QueryText.XSURI, false, false, false, false, true, 71){

        @Override
        public Item cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type == DTM ? new Tim((ADate)it) : (34.str(it) ? new Tim(it.string(ii), ii) : this.error(it, ii));
        }

        @Override
        public Item cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    YMO("gYearMonth", AAT, QueryText.XSURI, false, false, false, false, true, 72){

        @Override
        public Item cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type == DTM || it.type == DAT ? new GDt((ADate)it, this) : (35.str(it) ? new GDt(it.string(ii), this, ii) : this.error(it, ii));
        }

        @Override
        public Item cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    YEA("gYear", AAT, QueryText.XSURI, false, false, false, false, true, 73){

        @Override
        public Item cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type == DTM || it.type == DAT ? new GDt((ADate)it, this) : (36.str(it) ? new GDt(it.string(ii), this, ii) : this.error(it, ii));
        }

        @Override
        public Item cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    MDA("gMonthDay", AAT, QueryText.XSURI, false, false, false, false, true, 74){

        @Override
        public Item cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type == DTM || it.type == DAT ? new GDt((ADate)it, this) : (37.str(it) ? new GDt(it.string(ii), this, ii) : this.error(it, ii));
        }

        @Override
        public Item cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    DAY("gDay", AAT, QueryText.XSURI, false, false, false, false, true, 75){

        @Override
        public Item cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type == DTM || it.type == DAT ? new GDt((ADate)it, this) : (38.str(it) ? new GDt(it.string(ii), this, ii) : this.error(it, ii));
        }

        @Override
        public Item cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    MON("gMonth", AAT, QueryText.XSURI, false, false, false, false, true, 76){

        @Override
        public Item cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type == DTM || it.type == DAT ? new GDt((ADate)it, this) : (39.str(it) ? new GDt(it.string(ii), this, ii) : this.error(it, ii));
        }

        @Override
        public Item cast(Object o, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o), null, ii);
        }
    }
    ,
    BLN("boolean", AAT, QueryText.XSURI, false, false, false, false, false, 77){

        @Override
        public Item cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type.isNumber() ? Bln.get(it.bool(ii)) : (40.str(it) ? Bln.get(Bln.parse(it.string(ii), ii)) : this.error(it, ii));
        }

        @Override
        public Bln cast(Object o, InputInfo ii) {
            return o instanceof Boolean ? Bln.get((Boolean)o) : Bln.get(Boolean.parseBoolean(o.toString()));
        }
    }
    ,
    BIN("binary", AAT, QueryText.BASEXURI, false, false, false, false, false, 78),
    B64("base64Binary", BIN, QueryText.XSURI, false, false, false, false, false, 79){

        @Override
        public Item cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it instanceof Bin ? new B64((Bin)it, ii) : (41.str(it) ? new B64(it.string(ii), ii) : this.error(it, ii));
        }

        @Override
        public Item cast(Object o, InputInfo ii) throws QueryException {
            return new B64(o instanceof byte[] ? (byte[])o : Token.token(o.toString()), ii);
        }
    }
    ,
    HEX("hexBinary", BIN, QueryText.XSURI, false, false, false, false, false, 80){

        @Override
        public Item cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it instanceof Bin ? new Hex((Bin)it, ii) : (42.str(it) ? new Hex(it.string(ii), ii) : this.error(it, ii));
        }

        @Override
        public Item cast(Object o, InputInfo ii) throws QueryException {
            return new Hex(o instanceof byte[] ? (byte[])o : Token.token(o.toString()), ii);
        }
    }
    ,
    URI("anyURI", AAT, QueryText.XSURI, false, false, true, false, false, 81){

        @Override
        public Item cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            Uri u;
            if (!it.type.isString()) {
                this.error(it, ii);
            }
            if (!(u = Uri.uri(it.string(ii))).isValid()) {
                Err.FUNCAST.thrw(ii, this, it);
            }
            return u;
        }

        @Override
        public Item cast(Object o, InputInfo ii) {
            return Uri.uri(Token.token(o.toString()));
        }
    }
    ,
    QNM("QName", AAT, QueryText.XSURI, false, false, false, false, false, 82){

        @Override
        public Item cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            QNm qn;
            byte[] nm;
            if (it.type != STR) {
                this.error(it, ii);
            }
            if ((nm = it.string(ii)).length == 0) {
                Err.FUNCAST.thrw(ii, this, it);
            }
            if (!(qn = new QNm(nm, ctx)).hasURI() && qn.hasPrefix()) {
                Err.NSDECL.thrw(ii, new Object[]{qn.prefix()});
            }
            return qn;
        }

        @Override
        public Item cast(Object o, InputInfo ii) {
            return o instanceof QName ? new QNm((QName)o) : new QNm(o.toString());
        }
    }
    ,
    NOT("NOTATION", AAT, QueryText.XSURI, false, false, false, false, false, 83),
    JAVA("java", null, Token.EMPTY, true, true, true, false, false, 86){

        @Override
        public Item cast(Item it, QueryContext ctx, InputInfo ii) {
            return new Jav(it);
        }

        @Override
        public Item cast(Object o, InputInfo ii) {
            return new Jav(o);
        }
    };

    static final Pattern LANGPATTERN;
    public final QNm name;
    public final Type par;
    private final byte id;
    private final boolean num;
    private final boolean unt;
    private final boolean str;
    private final boolean dur;
    private final boolean dat;
    private SeqType seq;

    private AtomType(String nm, Type pr, byte[] ur, boolean n2, boolean u, boolean s, boolean d, boolean t, int i) {
        this.name = new QNm(nm, ur);
        this.par = pr;
        this.num = n2;
        this.unt = u;
        this.str = s;
        this.dur = d;
        this.dat = t;
        this.id = (byte)i;
    }

    @Override
    public boolean isNumber() {
        return this.num;
    }

    @Override
    public boolean isString() {
        return this.str;
    }

    @Override
    public boolean isUntyped() {
        return this.unt;
    }

    @Override
    public boolean isDuration() {
        return this.dur;
    }

    @Override
    public boolean isDate() {
        return this.dat;
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public byte[] string() {
        return this.name.string();
    }

    @Override
    public Item cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
        return it.type != this ? this.error(it, ii) : it;
    }

    @Override
    public Item cast(Object o, InputInfo ii) throws QueryException {
        Util.notexpected(o);
        return null;
    }

    @Override
    public Item castString(String o, InputInfo ii) throws QueryException {
        return this.cast(o, ii);
    }

    @Override
    public SeqType seqType() {
        if (this.seq == null) {
            this.seq = new SeqType(this);
        }
        return this.seq;
    }

    @Override
    public final boolean instanceOf(Type t) {
        return this == t || this.par != null && this.par.instanceOf(t);
    }

    @Override
    public final boolean isNode() {
        return false;
    }

    @Override
    public byte id() {
        return this.id;
    }

    @Override
    public String toString() {
        boolean xs = Token.eq(QueryText.XSURI, this.name.uri());
        TokenBuilder tb = new TokenBuilder();
        if (xs) {
            tb.add(NSGlobal.prefix(this.name.uri())).add(58);
        }
        tb.add(this.name.string());
        if (!xs) {
            tb.add("()");
        }
        return tb.toString();
    }

    Item checkNum(Item it, InputInfo ii) throws QueryException {
        Type ip = it.type;
        return ip == URI || !ip.isString() && !ip.isNumber() && !ip.isUntyped() && ip != BLN ? this.error(it, ii) : it;
    }

    long checkLong(Object o, long min, long max, InputInfo ii) throws QueryException {
        double d;
        Item it = o instanceof Item ? (Item)o : Str.get(o.toString());
        this.checkNum(it, ii);
        Type ip = it.type;
        if (ip == DBL || ip == FLT) {
            double d2 = it.dbl(ii);
            if (Double.isNaN(d2) || d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
                Err.value(ii, this, it);
            }
            if (d2 < -9.223372036854776E18 || d2 > 9.223372036854776E18) {
                Err.INTRANGE.thrw(ii, d2);
            }
            if (min != max && (d2 < (double)min || d2 > (double)max)) {
                Err.FUNCAST.thrw(ii, this, it);
            }
            return (long)d2;
        }
        long l = it.itr(ii);
        if (min == max && ((d = it.dbl(ii)) < -9.223372036854776E18 || d > 9.223372036854776E18)) {
            Err.FUNCAST.thrw(ii, this, it);
        }
        if (min != max && (l < min || l > max)) {
            Err.FUNCAST.thrw(ii, this, it);
        }
        return l;
    }

    static boolean str(Item it) {
        Type ip = it.type;
        return (ip.isString() || ip.isUntyped()) && ip != URI;
    }

    byte[] checkName(Item it, InputInfo ii) throws QueryException {
        byte[] v = Token.norm(it.string(ii));
        if (!XMLToken.isNCName(v)) {
            this.error(it, ii);
        }
        return v;
    }

    Item error(Item it, InputInfo ii) throws QueryException {
        throw Err.cast(ii, this, it);
    }

    public static AtomType find(QNm type, boolean all) {
        for (AtomType t : AtomType.values()) {
            if (!t.name.eq(type) || !all && t.par == null) continue;
            return t;
        }
        return null;
    }

    static {
        LANGPATTERN = Pattern.compile("[A-Za-z]{1,8}(-[A-Za-z0-9]{1,8})*");
    }
}

