/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.HashMap;
import java.util.Locale;
import org.basex.core.Prop;

public final class Language
implements Comparable<Language> {
    public static final HashMap<String, Language> ALL = new HashMap();
    private static final HashMap<String, Language> DISP = new HashMap();
    private final Locale locale;

    private Language(Locale loc) {
        this.locale = loc;
    }

    public static Language get(String lang) {
        int i = lang.indexOf(45);
        String l = i == -1 ? lang : lang.substring(0, i);
        Language ln = ALL.get(l.toLowerCase(Locale.ENGLISH));
        if (ln == null) {
            ln = DISP.get(lang);
        }
        return ln;
    }

    public static Language get(Prop prop) {
        Language lang = Language.get(prop.get(Prop.LANGUAGE));
        return lang == null ? Language.get("en") : lang;
    }

    public static Language def() {
        Language lang = DISP.get(Prop.language);
        return lang == null ? Language.get("en") : lang;
    }

    String code() {
        return this.locale.getLanguage();
    }

    public boolean equals(Object o) {
        return o instanceof Language && this.code().equals(((Language)o).code());
    }

    public int hashCode() {
        return this.code().hashCode();
    }

    @Override
    public int compareTo(Language o) {
        return this.code().compareTo(o.code());
    }

    public String toString() {
        return this.locale.getDisplayLanguage(Locale.ENGLISH);
    }

    static {
        for (Locale l : Locale.getAvailableLocales()) {
            ALL.put(l.getLanguage(), new Language(l));
            DISP.put(l.getDisplayLanguage(Locale.ENGLISH), new Language(l));
        }
    }
}

