/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.ImageIcon;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.svg.EntitySvg;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class SymbolGraphic {
    HashMap<String[], ImageIcon> symbolMapEgo = new HashMap();
    HashMap<String[], ImageIcon> symbolMapAlter = new HashMap();
    private MessageDialogHandler dialogHandler;

    public SymbolGraphic(MessageDialogHandler dialogHandler) {
        this.dialogHandler = dialogHandler;
    }

    public ImageIcon getSymbolGraphic(String[] symbolNames, boolean isEgo) {
        HashMap<String[], ImageIcon> symbolMap = isEgo ? this.symbolMapEgo : this.symbolMapAlter;
        if (symbolMap.containsKey(symbolNames)) {
            return symbolMap.get(symbolNames);
        }
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        SVGDocument doc = (SVGDocument)impl.createDocument(svgNS, "svg", null);
        new EntitySvg(this.dialogHandler).updateSymbolsElement(doc, svgNS);
        int symbolSize = 15;
        for (String currentSymbol : symbolNames) {
            Element symbolNode = doc.createElementNS(svgNS, "use");
            symbolNode.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#" + currentSymbol);
            if (isEgo) {
                symbolNode.setAttribute("fill", "black");
            } else {
                symbolNode.setAttribute("fill", "none");
            }
            symbolNode.setAttribute("stroke", "black");
            symbolNode.setAttribute("stroke-width", "2");
            Element svgRoot = doc.getDocumentElement();
            svgRoot.appendChild(symbolNode);
        }
        ImageIconTranscoder transcoder = new ImageIconTranscoder();
        TranscodingHints hints = new TranscodingHints();
        hints.put((Object)ImageTranscoder.KEY_WIDTH, (Object)Float.valueOf(symbolSize));
        hints.put((Object)ImageTranscoder.KEY_HEIGHT, (Object)Float.valueOf(symbolSize));
        transcoder.setTranscodingHints(hints);
        try {
            transcoder.transcode(new TranscoderInput((Document)doc), null);
            BufferedImage bufferedImage = transcoder.getImage();
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            symbolMap.put(symbolNames, imageIcon);
            return imageIcon;
        }
        catch (TranscoderException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
            return null;
        }
    }

    class ImageIconTranscoder
    extends ImageTranscoder {
        private BufferedImage image = null;

        ImageIconTranscoder() {
        }

        public BufferedImage createImage(int w, int h) {
            this.image = new BufferedImage(w, h, 2);
            return this.image;
        }

        public void writeImage(BufferedImage img, TranscoderOutput out) {
        }

        public BufferedImage getImage() {
            return this.image;
        }
    }
}

