/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.uniqueidentifiers;

import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.flap.plugin.PluginSessionStorage;
import nl.mpi.kinnate.uniqueidentifiers.IdentifierException;

public class UniqueIdentifier {
    @XmlValue
    private String identifierString;
    @XmlAttribute(name="type", namespace="http://mpi.nl/tla/kin")
    private IdentifierType identifierType;

    private UniqueIdentifier() {
        this.identifierString = null;
        this.identifierType = null;
    }

    public UniqueIdentifier(IdentifierType identifierTypeLocal) {
        this.identifierString = null;
        this.identifierType = null;
        this.identifierType = identifierTypeLocal;
        this.identifierString = UUID.randomUUID().toString();
    }

    public UniqueIdentifier(ArbilField arbilField) {
        this.identifierString = null;
        this.identifierType = null;
        if (arbilField.getFullXmlPath().endsWith(".UniqueIdentifier.LocalIdentifier")) {
            this.identifierType = IdentifierType.lid;
        } else if (arbilField.getFullXmlPath().endsWith(".UniqueIdentifier.PersistantIdentifier")) {
            this.identifierType = IdentifierType.pid;
        } else {
            throw new UnsupportedOperationException("Incorrect ArbilField: " + arbilField.getFullXmlPath());
        }
        this.identifierString = arbilField.getFieldValue();
    }

    public UniqueIdentifier(String attributeIdentifier) throws IdentifierException {
        block4: {
            this.identifierString = null;
            this.identifierType = null;
            String[] attributeIdentifierParts = attributeIdentifier.split("\\_");
            try {
                if (attributeIdentifierParts.length == 2) {
                    this.identifierType = IdentifierType.valueOf(attributeIdentifierParts[0]);
                    this.identifierString = attributeIdentifierParts[1];
                    break block4;
                }
                if (attributeIdentifierParts.length == 3) {
                    this.identifierType = IdentifierType.valueOf(attributeIdentifierParts[1]);
                    this.identifierString = attributeIdentifierParts[2];
                    break block4;
                }
                throw new IdentifierException("Incorrect identifier format: " + attributeIdentifier);
            }
            catch (IllegalArgumentException exception) {
                throw new IdentifierException("Incorrect identifier IdentifierType: " + attributeIdentifier);
            }
        }
    }

    public UniqueIdentifier(String userDefinedIdentifier, IdentifierType identifierTypeLocal) {
        this.identifierString = null;
        this.identifierType = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] digestbytes = messageDigest.digest(userDefinedIdentifier.getBytes());
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < digestbytes.length; ++i) {
                hexString.append(Integer.toHexString(256 + (digestbytes[i] & 0xFF)).substring(1));
            }
            switch (identifierTypeLocal) {
                case tid: 
                case iid: {
                    this.identifierString = hexString.toString();
                    this.identifierType = identifierTypeLocal;
                    break;
                }
                case pid: 
                case lid: 
                case gid: {
                    throw new UnsupportedOperationException("Unsupported user defined identifier, these must be transient identifiers");
                }
            }
        }
        catch (NoSuchAlgorithmException exception) {
            throw new UnsupportedOperationException("Cannot hash the transient identifier");
        }
    }

    public String getQueryIdentifier() {
        if (this.identifierString != null) {
            return this.identifierString;
        }
        throw new UnsupportedOperationException();
    }

    public String getAttributeIdentifier() {
        return this.identifierType.name() + "_" + this.identifierString;
    }

    public boolean isTransientIdentifier() {
        return this.identifierType == IdentifierType.tid;
    }

    public boolean isGraphicsIdentifier() {
        return this.identifierType == IdentifierType.gid;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UniqueIdentifier other = (UniqueIdentifier)obj;
        if (this.identifierString == null ? other.identifierString != null : !this.identifierString.equals(other.identifierString)) {
            return false;
        }
        return this.identifierType == other.identifierType;
    }

    public int hashCode() {
        int hash = 5;
        hash = 19 * hash + (this.identifierString != null ? this.identifierString.hashCode() : 0);
        hash = 19 * hash + (this.identifierType != null ? this.identifierType.hashCode() : 0);
        return hash;
    }

    public String toString() {
        throw new UnsupportedOperationException();
    }

    public File getFileInProject(PluginSessionStorage sessionStorage) {
        return new File(new File(sessionStorage.getProjectWorkingDirectory(), this.identifierString.substring(0, 3)), this.identifierString + ".kmdi");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IdentifierType {
        pid,
        lid,
        tid,
        gid,
        iid;

    }
}

