/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.imdidb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import nl.mpi.corpusstructure.Node;
import nl.mpi.corpusstructure.NodeIdUtils;
import nl.mpi.imdidb.DBImpl;
import nl.mpi.imdidb.IMDIDB;
import nl.mpi.imdidb.IMDIDBTable;
import nl.mpi.imdidb.IMDIQueryToSQL;
import nl.mpi.imdidb.IMDIRdbModel;
import nl.mpi.imdidb.MDDigester;
import nl.mpi.imdidb.MDTable;
import nl.mpi.util.DBConnection;
import nl.mpi.util.OurURL;
import org.apache.log4j.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMDIDBImpl
extends DBImpl
implements IMDIDB {
    private static String adminTableName = "IMDIADMIN";
    private static final String IMDI_VERSION = "IMDI_VERSION";
    private static final String CREATION_DATE = "CREATION_DATE";
    private String imdiVersion = "3.0";
    private static boolean bootstrapMode;
    static int id;

    public static void setLogger(Logger l) {
        DBImpl.setLogger(l);
        IMDIDBTable.setLogger(l);
    }

    public IMDIDBImpl() {
        this("lams.Configuration.IMDIDBname", false, "lams.Configuration.IMDIDBuser", "lams.Configuration.IMDIDBpasswd");
    }

    public IMDIDBImpl(String dbname) {
        this(dbname, false, null, null);
    }

    public IMDIDBImpl(String dbname, boolean bootstrapMode) {
        this(dbname, bootstrapMode, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMDIDBImpl(String dbname, boolean bootstrapMode, String user, String passwd) {
        logger.debug((Object)("IMDIDBImpl: constr(): dbname=" + dbname + ", bootstrap=" + bootstrapMode));
        String string = staticSyncFlag;
        synchronized (string) {
            this.db = new DBConnection(dbname, user, passwd, "IMDIDBImpl:constr()");
            if (bootstrapMode && IMDIDBImpl.bootstrapMode) {
                logger.error((Object)"IMDIDBImpl: ERROR: attempt to use bootstrap mode more than once at a time");
                this.setStatus(false);
                return;
            }
            IMDIDBImpl.bootstrapMode = bootstrapMode;
            IMDIDBTable.setBootstrapMode(bootstrapMode);
            ++id;
            this.setStatus(this.db.getStatus());
            if (!this.getStatus()) {
                logger.error((Object)("IMDIDBImpl: ERROR creating DB for " + dbname));
                return;
            }
            this.initPreparedStatements();
            if (bootstrapMode) {
                this.dropTmpTables();
                IMDIDBTable.setTmpTableNames();
                adminTableName = "TMP" + adminTableName;
                this.init();
                this.insertAdminKey(IMDI_VERSION, this.imdiVersion);
                this.insertAdminKey(CREATION_DATE, new Date().toString());
            } else {
                this.imdiVersion = this.getAdminKey(IMDI_VERSION);
                if (this.imdiVersion == null) {
                    logger.error((Object)"IMDIDBImpl: constr(): error getting values from Admin table");
                }
            }
        }
    }

    @Override
    public void flush() {
        IMDIDBTable.flushAllTables(this.db);
    }

    public Vector getTableNames() {
        return IMDIDBTable.getTableNames(this.db, "IMDIMD_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean dumpTable(String name, Writer w) throws IOException {
        ResultSet rs;
        Statement statement;
        block22: {
            SQLException e222;
            block21: {
                int i;
                logger.info((Object)("dumptable: " + name));
                if (!this.getStatus()) {
                    logger.error((Object)"IMDIDBImpl:dumpTable(): No connection: status=false");
                    return false;
                }
                statement = null;
                rs = null;
                String cmd = "SELECT * FROM " + name;
                statement = this.db.getConnection().createStatement();
                rs = statement.executeQuery(cmd);
                ResultSetMetaData rsmd = rs.getMetaData();
                int numberOfColumns = rsmd.getColumnCount();
                w.write("#");
                for (i = 0; i < numberOfColumns; ++i) {
                    w.write(rsmd.getColumnName(i + 1) + "\t");
                }
                w.write("\n");
                while (rs.next()) {
                    for (i = 0; i < numberOfColumns - 1; ++i) {
                        this.writeColumn(rs.getString(i + 1), w);
                        w.write("\t");
                    }
                    this.writeColumn(rs.getString(numberOfColumns), w);
                    w.write("\n");
                }
                Object var10_11 = null;
                if (statement == null) break block21;
                try {
                    statement.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                    break block22;
                }
                catch (SQLException e222) {
                    // empty catch block
                }
                {
                }
            }
            break block22;
            {
                catch (SQLException sqle) {
                    SQLException e222;
                    sqle.printStackTrace();
                    boolean bl = false;
                    Object var10_12 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e222) {
                            // empty catch block
                        }
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e222) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    rs = null;
                    return bl;
                }
            }
            catch (Throwable throwable) {
                SQLException e222;
                Object var10_13 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e222) {
                        // empty catch block
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e222) {
                        // empty catch block
                    }
                }
                statement = null;
                rs = null;
                throw throwable;
            }
        }
        statement = null;
        rs = null;
        return true;
    }

    private void writeColumn(String s, Writer w) throws IOException {
        if (s != null) {
            w.write(s);
        } else {
            w.write("NULL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishUpdate() {
        logger.debug((Object)"IMDIDBImpl: finishUpdate called");
        String string = staticSyncFlag;
        synchronized (string) {
            if (!bootstrapMode) {
                IMDIDBTable.createAllIndexes(this.db);
            }
            if (bootstrapMode) {
                logger.debug((Object)"IMDIDBImpl: finishUpdate: dropping old DB objects, renaming tables, creating new indexes");
                this.reset();
                this.renameTmpAdminTable();
                IMDIDBTable.renameTmpTables(this.db);
                IMDIDBTable.unsetTmpTableNames();
                IMDIDBTable.createAllIndexes(this.db);
                bootstrapMode = false;
            }
            IMDIDBTable.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void shutdown() {
        logger.debug((Object)"IMDIDBImpl: shutdown called");
        String string = staticSyncFlag;
        synchronized (string) {
            block17: {
                if (this.db.dbType == 2) {
                    Statement statement;
                    block16: {
                        String cmd = "SHUTDOWN COMPACT";
                        logger.debug((Object)("IMDIDBImpl:" + id + " shutdown()"));
                        statement = null;
                        statement = this.db.getConnection().createStatement();
                        statement.execute(cmd);
                        Object var6_4 = null;
                        if (statement == null) break block16;
                        try {
                            statement.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    {
                        break block17;
                        catch (SQLException sqle) {
                            if (sqle.toString().indexOf("is shutdown") != -1) {
                                logger.debug((Object)"database already shutdown");
                            } else {
                                logger.error((Object)"IMDIDBImpl: shutdown(): SQLException: ", (Throwable)sqle);
                            }
                            Object var6_5 = null;
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (SQLException e) {
                                    // empty catch block
                                }
                            }
                            statement = null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        statement = null;
                        throw throwable;
                    }
                }
            }
        }
        this.close();
    }

    @Override
    public boolean addIMDINode(Node node, OurURL url, String treepath) {
        return this.processIMDINode(node, url, treepath);
    }

    @Override
    public boolean deleteIMDINode(String nodeId) {
        IMDIDBTable.deleteFromAllTables(this.db, nodeId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public List getDBMatches(String[] queries, int limit, int offset, Set nodeIdsToFilter) {
        IMDIQueryToSQL iq = new IMDIQueryToSQL();
        if (!this.getStatus()) {
            logger.error((Object)"IMDIDBImpl:getIMDINodesByQuery(): No connection: status=false");
            return null;
        }
        String sql = iq.IMDIqueryToSQL(queries, limit, offset, nodeIdsToFilter);
        Statement stat = null;
        ResultSet rs = null;
        stat = this.db.getConnection().createStatement();
        rs = stat.executeQuery(sql);
        ArrayList<String[]> hs = new ArrayList<String[]>();
        while (rs.next()) {
            String[] tarr = new String[3];
            tarr[0] = NodeIdUtils.TONODEID(rs.getInt("NODEID"));
            try {
                tarr[1] = rs.getString("TREEPATH");
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            try {
                tarr[2] = rs.getString("CODE");
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            hs.add(tarr);
        }
        ArrayList<String[]> arrayList = hs;
        Object var13_15 = null;
        try {
            if (stat != null) {
                stat.close();
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        stat = null;
        rs = null;
        return arrayList;
        catch (SQLException sqle) {
            try {
                logger.error((Object)"IMDIDBImpl: getIMDINodesByQuery(): SQLException ", (Throwable)sqle);
                Object var13_16 = null;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                try {
                    if (stat != null) {
                        stat.close();
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
                stat = null;
                rs = null;
                throw throwable;
            }
            try {
                if (stat != null) {
                    stat.close();
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            stat = null;
            rs = null;
            {
            }
        }
        return null;
    }

    @Override
    protected boolean createTables() {
        return this.createAdminTable();
    }

    protected void dropTmpTables() {
        logger.debug((Object)"IMDIDBImpl: dropTmpTables called");
        this.dropTable("TMP" + adminTableName);
        IMDIDBTable.deleteAllTmpTables(this.db);
    }

    @Override
    protected void dropOldTables() {
        logger.debug((Object)"IMDIDBImpl: dropOldTables called");
        String name = adminTableName;
        if (adminTableName.startsWith("TMP")) {
            name = name.substring(3);
        }
        this.dropTable(name);
        IMDIDBTable.deleteAllTables(this.db);
    }

    @Override
    protected boolean createIndexes() {
        return true;
    }

    @Override
    protected void dropOldIndexes() {
        logger.debug((Object)"IMDIDBImpl: dropOldIndexes called");
    }

    @Override
    protected boolean initPreparedStatements() {
        return true;
    }

    @Override
    protected void closePreparedStatements() {
    }

    protected void dropPreparedStatements() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void insertAdminKey(String name, String value) {
        block12: {
            Statement stat = null;
            stat = this.db.getConnection().createStatement();
            stat.execute("INSERT INTO " + adminTableName + " (Name,Value) VALUES('" + name + "', '" + value + "')");
            Object var6_4 = null;
            try {
                if (stat != null) {
                    // empty if block
                }
                stat.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            stat = null;
            {
                break block12;
                catch (SQLException sqle) {
                    logger.error((Object)"IMDIDBImpl: insertAdminKey(): SQLException ", (Throwable)sqle);
                    Object var6_5 = null;
                    try {
                        if (stat != null) {
                            // empty if block
                        }
                        stat.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    stat = null;
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (stat != null) {
                        // empty if block
                    }
                    stat.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                stat = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getAdminKey(String name) {
        SQLException e222;
        Object o;
        ResultSet rs;
        Statement ps;
        block18: {
            ps = null;
            String answer = null;
            rs = null;
            ps = this.db.getConnection().prepareStatement("SELECT Value FROM " + adminTableName + " WHERE NAME = ?");
            ps.clearParameters();
            ps.setString(1, name);
            rs = ps.executeQuery();
            while (rs.next()) {
                answer = answer == null ? "" : answer + ";";
                o = rs.getObject(1);
                if (o != null) {
                    answer = answer + o.toString();
                    continue;
                }
                logger.error((Object)("getAdminKey: " + name + " error Object is null"));
            }
            o = answer;
            Object var8_7 = null;
            if (ps == null) break block18;
            try {
                ps.close();
            }
            catch (SQLException e222) {
                // empty catch block
            }
        }
        ps = null;
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e222) {
                // empty catch block
            }
        }
        rs = null;
        return o;
        catch (SQLException sqle) {
            SQLException e222;
            String string;
            block20: {
                try {
                    logger.error((Object)"getAdminKey: SQLException: ", (Throwable)sqle);
                    string = null;
                    Object var8_8 = null;
                    if (ps == null) break block20;
                }
                catch (Throwable throwable) {
                    SQLException e222;
                    Object var8_9 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException e222) {
                            // empty catch block
                        }
                    }
                    ps = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e222) {
                            // empty catch block
                        }
                    }
                    rs = null;
                    throw throwable;
                }
                try {
                    ps.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            ps = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            rs = null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void renameTmpAdminTable() {
        block13: {
            logger.debug((Object)"IMDIDBImpl: RenameTmpAdminTable");
            Statement stat = null;
            if (adminTableName.startsWith("TMP")) {
                stat = this.db.getConnection().createStatement();
                stat.execute("ALTER TABLE " + adminTableName + " RENAME TO " + adminTableName.substring(3));
                adminTableName = adminTableName.substring(3);
                Object var4_2 = null;
                try {
                    if (stat != null) {
                        // empty if block
                    }
                    stat.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                stat = null;
                {
                    break block13;
                    catch (SQLException sqle) {
                        logger.error((Object)"IMDIDBImpl: renameTmpAdminTable(): SQLException", (Throwable)sqle);
                        Object var4_3 = null;
                        try {
                            if (stat != null) {
                                // empty if block
                            }
                            stat.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        stat = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    try {
                        if (stat != null) {
                            // empty if block
                        }
                        stat.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    stat = null;
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean createAdminTable() {
        Statement stat;
        block11: {
            logger.debug((Object)"IMDIDBImpl: Creating Admin table");
            stat = null;
            stat = this.db.getConnection().createStatement();
            stat.execute("CREATE " + this.db.tableType + " TABLE " + adminTableName + " (Name VARCHAR, Value VARCHAR)");
            stat.execute("INSERT INTO " + adminTableName + " ( NAME, VALUE) VALUES('UPDATEINPROGRESS','TRUE')");
            stat.execute("GRANT SELECT ON " + adminTableName + " TO PUBLIC");
            Object var5_2 = null;
            try {
                if (stat != null) {
                    // empty if block
                }
                stat.close();
                break block11;
            }
            catch (SQLException e) {
                // empty catch block
            }
            {
                break block11;
                catch (SQLException sqle) {
                    logger.error((Object)"IMDIDBImpl: createAdminTable(): SQLException ", (Throwable)sqle);
                    boolean bl = false;
                    Object var5_3 = null;
                    try {
                        if (stat != null) {
                            // empty if block
                        }
                        stat.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    stat = null;
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    if (stat != null) {
                        // empty if block
                    }
                    stat.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                stat = null;
                throw throwable;
            }
        }
        stat = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void dropTable(String name) {
        block14: {
            Statement stat = null;
            stat = this.db.getConnection().createStatement();
            String cmd = "DROP TABLE " + name;
            if (this.db.dbType == 1) {
                cmd = "DROP TABLE IF EXISTS " + name;
            }
            stat.executeUpdate(cmd);
            logger.debug((Object)("IMDIDBImpl:dropTable() Dropped table: " + name));
            Object var5_5 = null;
            try {
                if (stat != null) {
                    stat.close();
                }
            }
            catch (SQLException slqe) {
                // empty catch block
            }
            stat = null;
            {
                break block14;
                catch (SQLException e) {
                    if (!name.startsWith("TMP")) {
                        logger.error((Object)("IMDIDBImpl:dropTable() Error dropping table: " + name + ", " + e));
                    }
                    Object var5_6 = null;
                    try {
                        if (stat != null) {
                            stat.close();
                        }
                    }
                    catch (SQLException slqe) {
                        // empty catch block
                    }
                    stat = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (stat != null) {
                        stat.close();
                    }
                }
                catch (SQLException slqe) {
                    // empty catch block
                }
                stat = null;
                throw throwable;
            }
        }
    }

    private boolean processIMDINode(Node node, OurURL url, String treePath) {
        boolean result = false;
        try {
            switch (node.getNodeType()) {
                case 1: {
                    MDTable sessionTable = MDDigester.processSessionNode(url);
                    sessionTable.addColumn("TREEPATH", treePath);
                    result = this.processTable(node, url, sessionTable);
                    break;
                }
                case 128: {
                    MDTable catalogTable = MDDigester.processCatalogueNode(url);
                    catalogTable.addColumn("TREEPATH", treePath);
                    result = this.processTable(node, url, catalogTable);
                    break;
                }
            }
        }
        catch (SAXException e) {
            logger.error((Object)("Error while parsing node= " + node + ", url=" + url), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("IO error while processing node= " + node + ", url=" + url), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)("Error while persisting node= " + node + ", url=" + url), (Throwable)e);
        }
        return result;
    }

    private boolean processTable(Node node, OurURL url, MDTable table) throws SQLException {
        int id = NodeIdUtils.TOINT(node.getNodeId());
        LinkedList<Integer> foreignKeyIds = new LinkedList<Integer>();
        foreignKeyIds.add(id);
        this.storeMDTable(table, foreignKeyIds, url, table.getTableName());
        return true;
    }

    private void storeMDTable(MDTable table, LinkedList<Integer> foreignKeyIds, OurURL url, String mainTableName) throws SQLException {
        String tableName = table.getTableName();
        IMDIDBTable imdidbTable = IMDIDBTable.get(this.db, tableName, foreignKeyIds.size(), true, mainTableName);
        List<MDTable.MDColumn> columns = table.getColumns();
        for (MDTable.MDColumn column : columns) {
            imdidbTable.insert(column.getName(), this.adjustColumnValue(column, url), this.adjustColumnType(column.getType()), foreignKeyIds);
        }
        List<MDTable> tables = table.getTables();
        int tableInstanceCount = 0;
        HashSet<String> tableNames = new HashSet<String>();
        for (int i = 0; i < tables.size(); ++i) {
            MDTable subTable = tables.get(i);
            tableInstanceCount = tableNames.add(subTable.getTableName()) ? 0 : ++tableInstanceCount;
            foreignKeyIds.addLast(tableInstanceCount);
            this.storeMDTable(subTable, foreignKeyIds, url, mainTableName);
            foreignKeyIds.removeLast();
        }
    }

    private String adjustColumnType(String type) {
        if (this.db.dbType == 2 && "VARCHAR".equals(type)) {
            return "VARCHAR_IGNORECASE";
        }
        return type;
    }

    private String adjustColumnValue(MDTable.MDColumn column, OurURL url) {
        String result = null;
        String name = column.getName();
        String value = column.getValue();
        if (name.equals("Age")) {
            try {
                Float age = IMDIRdbModel.agePeriodToFloat(value);
                if (age != null) {
                    result = age.toString();
                }
            }
            catch (NumberFormatException e) {
                logger.warn((Object)("Illegal age format: " + value + " in file " + url));
                result = null;
            }
        } else if (name.endsWith("Date")) {
            try {
                Float date = IMDIRdbModel.datePeriodToFloat(value);
                if (date != null) {
                    result = date.toString();
                }
            }
            catch (NumberFormatException e) {
                logger.warn((Object)("Illegal date format: " + value + " in file " + url));
                result = null;
            }
        } else if (name.endsWith("Link")) {
            if (!(value.equals("") || value.startsWith("notyet:") || value.startsWith("file:") || value.startsWith("http:") || value.startsWith("ftp:"))) {
                try {
                    OurURL ourUrl = new OurURL(url, value);
                    result = ourUrl.toString();
                }
                catch (MalformedURLException mue) {
                    logger.error((Object)("ERROR IMDI2RDB making url from " + value + " in file " + url));
                    result = "";
                }
            }
        } else {
            result = value;
        }
        if ((column.getType().equals("INTEGER") || column.getType().equals("DECIMAL")) && result != null && (result.equalsIgnoreCase("Unknown") || result.equals("Unspecified"))) {
            result = null;
        }
        return result;
    }

    static {
        id = 0;
    }

    public class MyEntityResolver
    implements EntityResolver {
        public InputSource resolveEntity(String publicId, String systemId) {
            if (systemId.endsWith("IMDI_3.0.xsd")) {
                try {
                    InputSource inputSource = new InputSource(new FileInputStream(new File("IMDI_3.0.xsd")));
                    return inputSource;
                }
                catch (FileNotFoundException e) {
                    DBImpl.logger.debug((Object)"IMDI2RDB: put IMDI_3.0.xsd in current dir!!!");
                    return null;
                }
            }
            if (systemId.endsWith("IMDI.xsd")) {
                try {
                    InputSource inputSource = new InputSource(new FileInputStream(new File("IMDI.xsd")));
                    return inputSource;
                }
                catch (FileNotFoundException e) {
                    DBImpl.logger.debug((Object)"IMDI2RDB: put IMDI.xsd in current dir!!!");
                    return null;
                }
            }
            return null;
        }
    }
}

