/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import java.util.Locale;
import org.basex.build.BuildException;
import org.basex.build.Builder;
import org.basex.build.SingleParser;
import org.basex.build.file.CSVParser;
import org.basex.build.file.HTMLParser;
import org.basex.build.file.JSONParser;
import org.basex.build.file.MAB2Parser;
import org.basex.build.file.ParserProp;
import org.basex.build.file.TextParser;
import org.basex.build.xml.SAXWrapper;
import org.basex.build.xml.XMLParser;
import org.basex.core.Progress;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.io.IO;
import org.basex.io.MimeTypes;
import org.basex.io.in.TextInput;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.DBNode;
import org.basex.util.Atts;
import org.basex.util.Token;

public abstract class Parser
extends Progress {
    public IO src;
    protected final Atts atts = new Atts();
    protected final Prop prop;
    protected String target = "";

    protected Parser(String source, Prop pr) {
        this(source == null ? null : IO.get(source), pr);
    }

    protected Parser(IO source, Prop pr) {
        this.src = source;
        this.prop = pr;
    }

    public abstract void parse(Builder var1) throws IOException;

    public void close() throws IOException {
    }

    public String info() {
        return "";
    }

    public Parser target(String path) {
        this.target = path.isEmpty() ? "" : (path + '/').replaceAll("//+", "/");
        return this;
    }

    public static Parser emptyParser(Prop pr) {
        return new Parser((IO)null, pr){

            @Override
            public void parse(Builder build) {
            }
        };
    }

    public static SingleParser xmlParser(IO in, Prop prop) throws IOException {
        return prop.is(Prop.INTPARSE) ? new XMLParser(in, prop) : new SAXWrapper(in, prop);
    }

    public static SingleParser singleParser(IO in, Prop prop, String target) throws IOException {
        SingleParser p;
        String parser = prop.get(Prop.PARSER).toLowerCase(Locale.ENGLISH);
        if (parser.equals("html")) {
            p = new HTMLParser(in, prop);
        } else if (parser.equals("text")) {
            p = new TextParser(in, prop);
        } else if (parser.equals("mab2")) {
            p = new MAB2Parser(in, prop);
        } else if (parser.equals("json")) {
            p = new JSONParser(in, prop);
        } else if (parser.equals("csv")) {
            p = new CSVParser(in, prop);
        } else if (parser.equals("xml")) {
            p = Parser.xmlParser(in, prop);
        } else {
            throw new BuildException(Text.UNKNOWN_PARSER_X, parser);
        }
        p.target(target);
        return p;
    }

    public static Item item(IO in, Prop prop, String type) throws IOException {
        Item it = null;
        if (type != null) {
            if (Token.eq(type, "application/json", "application/jsonml+json")) {
                String options = ParserProp.JSONML[0] + "=" + Token.eq(type, "application/jsonml+json");
                it = new DBNode(new JSONParser(in, prop, options));
            } else if ("text/comma-separated-values".equals(type)) {
                it = new DBNode(new CSVParser(in, prop));
            } else if ("text/html".equals(type)) {
                it = new DBNode(new HTMLParser(in, prop));
            } else if (MimeTypes.isXML(type)) {
                it = new DBNode(in, prop);
            } else if (MimeTypes.isText(type)) {
                it = Str.get(new TextInput(in).content());
            }
        }
        return it == null ? new B64(in.read()) : it;
    }
}

