/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.util.regex.Pattern;
import org.basex.core.Command;
import org.basex.core.Perm;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.util.list.StringList;

abstract class AUser
extends Command {
    AUser(Perm p, String ... a) {
        super(p, a);
    }

    AUser(String ... a) {
        this(Perm.ADMIN, a);
    }

    private String[] users(String name) {
        String pat = name.matches(".*[*?,].*") ? IOFile.regex(name) : name;
        return this.context.users.find(Pattern.compile(pat, Prop.WIN ? 2 : 0));
    }

    boolean run(int off, boolean opt) {
        String d;
        String u = this.args[off];
        String string = d = off + 1 < this.args.length ? this.args[off + 1] : null;
        if (!MetaData.validName(u, true)) {
            return this.error(Text.NAME_INVALID_X, u);
        }
        if (d != null && !MetaData.validName(d, true)) {
            return this.error(Text.NAME_INVALID_X, d);
        }
        String[] users = this.users(u);
        if (users.length == 0) {
            return this.info(Text.UNKNOWN_USER_X, u) && opt;
        }
        StringList dbs = null;
        if (d != null && (dbs = this.context.databases().listDBs(d)).size() == 0) {
            return this.info(Text.DB_NOT_FOUND_X, d) && opt;
        }
        boolean ok = true;
        for (String user : users) {
            if (dbs == null) {
                ok &= this.run(user, null);
                continue;
            }
            for (String db : dbs) {
                ok &= this.run(user, db);
            }
        }
        return ok;
    }

    static boolean isMD5(String md5) {
        return md5 != null && md5.matches("[0-9a-f]{32}");
    }

    boolean run(String user, String db) {
        return true;
    }
}

