/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.User;
import org.basex.core.cmd.AUser;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.Data;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Grant
extends AUser {
    private Perm perm;

    public Grant(Object permission, String user) {
        this(permission, user, null);
    }

    public Grant(Object permission, String user, String db) {
        super(permission.toString(), user, db);
    }

    @Override
    protected boolean run() {
        Commands.CmdPerm cmd = this.getOption(Commands.CmdPerm.class);
        if (cmd == Commands.CmdPerm.NONE) {
            this.perm = Perm.NONE;
        } else if (cmd == Commands.CmdPerm.READ) {
            this.perm = Perm.READ;
        } else if (cmd == Commands.CmdPerm.WRITE) {
            this.perm = Perm.WRITE;
        } else if (cmd == Commands.CmdPerm.CREATE && this.args[2] == null) {
            this.perm = Perm.CREATE;
        } else if (cmd == Commands.CmdPerm.ADMIN && this.args[2] == null) {
            this.perm = Perm.ADMIN;
        }
        if (this.perm == null) {
            return this.error(Text.PERM_UNKNOWN_X, this.args[0]);
        }
        return this.run(1, false);
    }

    @Override
    protected boolean run(String user, String db) {
        Data data;
        if (user.equals("admin")) {
            return !this.info(Text.ADMIN_STATIC_X, new Object[0]);
        }
        if (db == null) {
            this.context.users.get((String)user).perm = this.perm;
            this.context.users.write();
            return this.info(Text.GRANTED_X_X, this.args[0], user);
        }
        try {
            data = Open.open(db, this.context);
        }
        catch (IOException ex) {
            Util.debug(ex);
            String msg = ex.getMessage();
            return !this.info(msg.isEmpty() ? Text.DB_NOT_OPENED_X : msg, db);
        }
        if (!data.startUpdate()) {
            return !this.info(Text.DB_PINNED_X, data.meta.name);
        }
        User u = data.meta.users.get(user);
        if (u == null) {
            u = this.context.users.get(user).copy();
            data.meta.users.create(u);
        }
        u.perm = this.perm;
        data.meta.dirty = true;
        data.finishUpdate();
        Close.close(data, this.context);
        return this.info(Text.GRANTED_ON_X_X_X, this.args[0], user, db);
    }

    @Override
    protected boolean databases(StringList db) {
        return this.databases(db, 2);
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init().arg(0).arg("ON", 2).arg("TO", 1);
    }
}

