/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.AInfo;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.StringList;

public final class InfoIndex
extends AInfo {
    public InfoIndex() {
        this(null);
    }

    public InfoIndex(Object type) {
        super(Perm.READ, true, type != null && type != Commands.CmdIndexInfo.NULL ? type.toString() : null);
    }

    @Override
    protected boolean run() throws IOException {
        Data data = this.context.data();
        if (this.args[0] != null) {
            Commands.CmdIndexInfo ci = this.getOption(Commands.CmdIndexInfo.class);
            if (ci == null) {
                return this.error(Text.UNKNOWN_CMD_X, this);
            }
            byte[] inf = InfoIndex.info(ci, data);
            this.out.print(inf);
            return inf.length != 0;
        }
        TokenBuilder tb = new TokenBuilder();
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.TAG, data));
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.ATTNAME, data));
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.TEXT, data));
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.ATTRIBUTE, data));
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.FULLTEXT, data));
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.PATH, data));
        this.out.print(tb.finish());
        return true;
    }

    @Override
    protected boolean databases(StringList db) {
        db.add("");
        return true;
    }

    private static byte[] info(Commands.CmdIndexInfo idx, Data data) {
        switch (idx) {
            case TAG: {
                return InfoIndex.info(Text.ELEMENTS, IndexType.TAG, data, true);
            }
            case ATTNAME: {
                return InfoIndex.info(Text.ATTRIBUTES, IndexType.ATTNAME, data, true);
            }
            case PATH: {
                return InfoIndex.info(Text.PATH_INDEX, IndexType.PATH, data, true);
            }
            case TEXT: {
                return InfoIndex.info(Text.TEXT_INDEX, IndexType.TEXT, data, data.meta.textindex);
            }
            case ATTRIBUTE: {
                return InfoIndex.info(Text.ATTRIBUTE_INDEX, IndexType.ATTRIBUTE, data, data.meta.attrindex);
            }
            case FULLTEXT: {
                return InfoIndex.info(Text.FULLTEXT_INDEX, IndexType.FULLTEXT, data, data.meta.ftxtindex);
            }
        }
        return Token.token("- " + Text.NOT_AVAILABLE);
    }

    private static byte[] info(String ds, IndexType it, Data data, boolean avl) {
        TokenBuilder tb = new TokenBuilder(ds).add(Text.NL);
        if (avl) {
            tb.add(data.info(it));
        } else {
            tb.add("- ").addExt(Text.NOT_AVAILABLE, new Object[]{it}).add(Text.NL);
        }
        return tb.add(Text.NL).finish();
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.INFO) + " " + (Object)((Object)Commands.CmdInfo.INDEX)).args();
    }
}

