/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.Perm;
import org.basex.core.Prop;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Inspect
extends Command {
    public Inspect() {
        super(Perm.WRITE, true, new String[0]);
    }

    @Override
    protected boolean run() throws IOException {
        Data data = this.context.data();
        this.out.print(Inspect.inspect(data));
        return this.info("'%' inspected in %.", data.meta.name, this.perf);
    }

    @Override
    protected boolean databases(StringList db) {
        db.add("");
        return true;
    }

    public static String inspect(Data data) {
        MetaData md = data.meta;
        Check invKind = new Check();
        Check parRef = new Check();
        Check parChild = new Check();
        Check idPre = md.updindex ? new Check() : null;
        for (int pre = 0; pre < md.size; ++pre) {
            int par;
            int kind = data.kind(pre);
            if (kind > 6) {
                invKind.add(pre);
            }
            if ((par = data.parent(pre, kind)) >= 0) {
                int parKind = data.kind(par);
                if (par >= pre || (kind == 0 ? par != -1 : par < 0)) {
                    parRef.add(pre);
                }
                if (parKind != 0 && parKind != 1 || par + data.size(par, parKind) < pre) {
                    parChild.add(pre);
                }
            }
            if (idPre == null || data.pre(data.id(pre)) == pre) continue;
            idPre.add(pre);
        }
        TokenBuilder info = new TokenBuilder();
        info.addExt("Checking main table (% nodes):", md.size).add(Prop.NL);
        info.add(invKind.info("invalid node kinds"));
        info.add(parRef.info("invalid parent references"));
        info.add(parChild.info("wrong parent/descendant relationships"));
        if (idPre != null) {
            info.add(idPre.info("wrong id/pre mappings"));
        }
        if (invKind.invalid + parRef.invalid + parChild.invalid == 0) {
            info.add("No inconsistencies found.").add(Prop.NL);
        } else {
            info.add("Warning: Database is inconsistent.").add(Prop.NL);
        }
        return info.toString();
    }

    static final class Check {
        int invalid;
        int first = -1;

        Check() {
        }

        void add(int pre) {
            ++this.invalid;
            if (this.first == -1) {
                this.first = pre;
            }
        }

        String info(String info) {
            StringBuilder sb = new StringBuilder("- % " + info);
            if (this.invalid > 0) {
                sb.append(" (pre: %,..)");
            }
            return Util.info(sb, this.invalid, this.first) + Prop.NL;
        }
    }
}

