/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.util.Arrays;
import java.util.Iterator;
import org.basex.data.FTMatch;
import org.basex.data.FTStringMatch;
import org.basex.util.Array;
import org.basex.util.Util;

public final class FTMatches
implements Iterable<FTMatch> {
    public FTMatch[] match = new FTMatch[0];
    public int size;
    public int sTokenNum;

    public FTMatches(int s) {
        this.reset(s);
    }

    public void reset(int s) {
        this.sTokenNum = s;
        this.size = 0;
    }

    public void or(int p) {
        this.or(p, p);
    }

    public void or(int s, int e) {
        this.add(new FTMatch().add(new FTStringMatch(s, e, this.sTokenNum)));
    }

    public void and(int s, int e) {
        FTStringMatch sm = new FTStringMatch(s, e, this.sTokenNum);
        for (FTMatch m : this) {
            m.add(sm);
        }
    }

    public void add(FTMatch m) {
        if (this.size == this.match.length) {
            this.match = this.size == 0 ? new FTMatch[1] : Arrays.copyOf(this.match, this.size << 1);
        }
        this.match[this.size++] = m;
    }

    public void delete(int i) {
        Array.move(this.match, i + 1, -1, --this.size - i);
    }

    public boolean matches() {
        for (FTMatch m : this) {
            if (!m.match()) continue;
            return true;
        }
        return false;
    }

    public boolean phrase(FTMatches all, int dis) {
        int a = 0;
        int b = 0;
        int c = 0;
        while (a < this.size && b < all.size) {
            int e = all.match[b].match[0].s;
            int d = e - this.match[a].match[0].e - dis;
            if (d == 0) {
                this.match[c] = this.match[a];
                this.match[c++].match[0].e = e;
            }
            if (d >= 0) {
                ++a;
            }
            if (d > 0) continue;
            ++b;
        }
        this.size = c;
        return this.size != 0;
    }

    @Override
    public Iterator<FTMatch> iterator() {
        return new Iterator<FTMatch>(){
            private int c = -1;

            @Override
            public boolean hasNext() {
                return ++this.c < FTMatches.this.size;
            }

            @Override
            public FTMatch next() {
                return FTMatches.this.match[this.c];
            }

            @Override
            public void remove() {
                Util.notexpected(new Object[0]);
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Util.name(this) + '[' + this.sTokenNum + ']');
        for (FTMatch m : this) {
            sb.append("\n  ").append(m);
        }
        return sb.toString();
    }
}

