/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXPanel;

public final class BaseXPopup
extends JPopupMenu {
    final GUI gui;
    private final GUICommand[] popup;

    public BaseXPopup(BaseXPanel comp, GUICommand ... pop) {
        this((JComponent)comp, comp.gui, pop);
    }

    public BaseXPopup(JComponent comp, GUI g, GUICommand ... pop) {
        this.popup = pop;
        this.gui = g;
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!BaseXPopup.this.gui.updating && e.isPopupTrigger()) {
                    BaseXPopup.this.show(e.getComponent(), e.getX() - 10, e.getY() - 15);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mousePressed(e);
            }
        });
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!BaseXPopup.this.gui.updating && BaseXKeys.CONTEXT.is(e)) {
                    BaseXPopup.this.show(e.getComponent(), 10, 10);
                }
            }
        });
        for (final GUICommand c : pop) {
            if (c == null) {
                this.addSeparator();
                continue;
            }
            JMenuItem item = this.add(c.label());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!BaseXPopup.this.gui.updating) {
                        c.execute(BaseXPopup.this.gui);
                    }
                }
            });
            item.setMnemonic(c.label().charAt(0));
            item.setToolTipText(c.help());
        }
    }

    @Override
    public void show(Component comp, int x, int y) {
        for (int b = 0; b < this.popup.length; ++b) {
            if (this.popup[b] == null) continue;
            this.popup[b].refresh(this.gui, (JMenuItem)this.getComponent(b));
        }
        super.show(comp, x, y);
    }
}

