/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.ft;

import java.io.IOException;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.FTMatches;
import org.basex.index.Index;
import org.basex.index.IndexCache;
import org.basex.index.IndexEntry;
import org.basex.index.query.EntryIterator;
import org.basex.index.query.FTIndexIterator;
import org.basex.index.query.IndexEntries;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexToken;
import org.basex.index.stats.IndexStats;
import org.basex.io.random.DataAccess;
import org.basex.query.ft.FTWildcard;
import org.basex.util.Array;
import org.basex.util.Levenshtein;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.hash.IntMap;
import org.basex.util.list.IntList;

public final class FTIndex
implements Index {
    private static final int ENTRY = 9;
    private final IntMap<byte[]> ctext = new IntMap();
    private final Levenshtein ls = new Levenshtein();
    private final Data data;
    private final DataAccess inX;
    final DataAccess inY;
    final DataAccess inZ;
    final IndexCache cache = new IndexCache();
    final int[] tp;

    public FTIndex(Data d) throws IOException {
        this.data = d;
        this.inY = new DataAccess(d.meta.dbfile("ftxy"));
        this.inZ = new DataAccess(d.meta.dbfile("ftxz"));
        this.inX = new DataAccess(d.meta.dbfile("ftxx"));
        this.tp = new int[d.meta.maxlen + 3];
        for (int i = 0; i < this.tp.length; ++i) {
            this.tp[i] = -1;
        }
        int is = this.inX.readNum();
        while (--is >= 0) {
            int r;
            int p = this.inX.readNum();
            if (p < this.tp.length) {
                r = this.inX.read4();
            } else {
                r = p << 24 | (this.inX.read1() & 0xFF) << 16 | (this.inX.read1() & 0xFF) << 8 | this.inX.read1() & 0xFF;
                p = p >> 8 | 0x40;
            }
            this.tp[p] = r;
        }
        this.tp[this.tp.length - 1] = (int)this.inY.length();
    }

    @Override
    public synchronized void init() {
    }

    @Override
    public synchronized int count(IndexToken it) {
        byte[] tok = it.get();
        if (tok.length > this.data.meta.maxlen) {
            return Integer.MAX_VALUE;
        }
        FTOpt opt = ((FTLexer)it).ftOpt();
        if (opt.is(FTFlag.FZ) || opt.is(FTFlag.WC)) {
            return Math.max(1, this.data.meta.size / 10);
        }
        return this.entry((byte[])tok).size;
    }

    @Override
    public synchronized IndexIterator iter(IndexToken it) {
        byte[] tok = it.get();
        FTOpt opt = ((FTLexer)it).ftOpt();
        if (opt.is(FTFlag.WC)) {
            return this.wc(tok);
        }
        if (opt.is(FTFlag.FZ)) {
            int k = this.data.meta.prop.num(Prop.LSERROR);
            return this.fuzzy(tok, k == 0 ? tok.length >> 2 : k);
        }
        IndexEntry e = this.entry(tok);
        return e.size > 0 ? this.iter(e.pointer, e.size, this.inZ) : FTIndexIterator.FTEMPTY;
    }

    private IndexEntry entry(byte[] token) {
        IndexEntry e = this.cache.get(token);
        if (e != null) {
            return e;
        }
        long p = this.token(token);
        return p == -1L ? new IndexEntry(token, 0, 0L) : this.cache.add(token, this.size(p, token.length), this.pointer(p, token.length));
    }

    @Override
    public EntryIterator entries(IndexEntries entries) {
        final byte[] prefix = entries.get();
        return new EntryIterator(){
            int ti;
            int i;
            int e;
            int nr;
            boolean inner;
            {
                this.ti = prefix.length - 1;
            }

            @Override
            public synchronized byte[] next() {
                byte[] entry;
                if (this.inner && this.i < this.e && Token.startsWith(entry = FTIndex.this.inY.readBytes(this.i, this.ti), prefix)) {
                    long poi = FTIndex.this.inY.read5();
                    this.nr = FTIndex.this.inY.read4();
                    if (prefix.length != 0) {
                        FTIndex.this.cache.add(entry, this.nr, poi);
                    }
                    this.i += this.ti + 9;
                    return entry;
                }
                while (++this.ti < FTIndex.this.tp.length - 1) {
                    this.i = FTIndex.this.tp[this.ti];
                    if (this.i == -1) continue;
                    int c = this.ti + 1;
                    do {
                        this.e = FTIndex.this.tp[c++];
                    } while (this.e == -1);
                    this.nr = 0;
                    this.inner = true;
                    this.i = FTIndex.this.find(prefix, this.i, this.e, this.ti);
                    byte[] n = this.next();
                    if (n == null) continue;
                    return n;
                }
                return null;
            }

            @Override
            public int count() {
                return this.nr;
            }
        };
    }

    int find(byte[] token, int i, int e, int ti) {
        int tl = ti + 9;
        int l = 0;
        int h = (e - i) / tl;
        while (l <= h) {
            int d;
            int m = l + h >>> 1;
            int p = i + m * tl;
            byte[] txt = this.ctext.get(p);
            if (txt == null) {
                txt = this.inY.readBytes(p, ti);
                this.ctext.add(p, txt);
            }
            if ((d = Token.diff(txt, token)) == 0) {
                return i + m * tl;
            }
            if (d < 0) {
                l = m + 1;
                continue;
            }
            h = m - 1;
        }
        return i + l * tl;
    }

    @Override
    public synchronized byte[] info() {
        TokenBuilder tb = new TokenBuilder();
        tb.add("- Structure: Fuzzy" + Text.NL);
        tb.addExt("- %: %" + Text.NL, Text.STEMMING, Util.flag(this.data.meta.stemming));
        tb.addExt("- %: %" + Text.NL, Text.CASE_SENSITIVITY, Util.flag(this.data.meta.casesens));
        tb.addExt("- %: %" + Text.NL, Text.DIACRITICS, Util.flag(this.data.meta.diacritics));
        if (this.data.meta.language != null) {
            tb.addExt("- %: %" + Text.NL, Text.LANGUAGE, this.data.meta.language);
        }
        long l = this.inX.length() + this.inY.length() + this.inZ.length();
        tb.add("- Size: " + Performance.format(l, true) + Text.NL);
        IndexStats stats = new IndexStats(this.data);
        this.addOccs(stats);
        stats.print(tb);
        return tb.finish();
    }

    @Override
    public synchronized void close() {
        this.inX.close();
        this.inY.close();
        this.inZ.close();
    }

    private int token(byte[] token) {
        int r;
        int tl = token.length;
        int l = this.tp[tl];
        if (l == -1) {
            return -1;
        }
        int i = 1;
        while ((r = this.tp[tl + i++]) == -1) {
        }
        int x = r;
        int o = tl + 9;
        while (l < r) {
            int m = l + (r - l >> 1) / o * o;
            int c = Token.diff(this.inY.readBytes(m, tl), token);
            if (c == 0) {
                return m;
            }
            if (c < 0) {
                l = m + o;
                continue;
            }
            r = m - o;
        }
        return r != x && l == r && Token.eq(this.inY.readBytes(l, tl), token) ? l : -1;
    }

    private void addOccs(IndexStats stats) {
        int j;
        int i;
        for (i = 0; i < this.tp.length && this.tp[i] == -1; ++i) {
        }
        int p = this.tp[i];
        for (j = i + 1; j < this.tp.length && this.tp[j] == -1; ++j) {
        }
        while (p < this.tp[this.tp.length - 1]) {
            if (stats.adding(this.size(p, i))) {
                stats.add(this.inY.readBytes(p, i));
            }
            if ((p += i + 9) != this.tp[j]) continue;
            i = j;
            while (j + 1 < this.tp.length && this.tp[++j] == -1) {
            }
        }
    }

    private long pointer(long pt, int lt) {
        return this.inY.read5(pt + (long)lt);
    }

    private int size(long pt, int lt) {
        return this.inY.read4(pt + (long)lt + 5L);
    }

    private synchronized IndexIterator fuzzy(byte[] token, int k) {
        FTIndexIterator it = FTIndexIterator.FTEMPTY;
        int tl = token.length;
        int e = Math.min(this.tp.length - 1, tl + k);
        int s = Math.max(1, tl - k) - 1;
        while (++s <= e) {
            int p = this.tp[s];
            if (p == -1) continue;
            int i = s + 1;
            int r = -1;
            while (i < this.tp.length && r == -1) {
                r = this.tp[i++];
            }
            while (p < r) {
                if (this.ls.similar(this.inY.readBytes(p, s), token, k)) {
                    it = FTIndexIterator.union(this.iter(this.pointer(p, s), this.size(p, s), this.inZ), it);
                }
                p += s + 9;
            }
        }
        return it;
    }

    private synchronized IndexIterator wc(byte[] token) {
        FTIndexIterator it = FTIndexIterator.FTEMPTY;
        FTWildcard wc = new FTWildcard(token);
        if (!wc.parse()) {
            return it;
        }
        IntList pr = new IntList();
        IntList ps = new IntList();
        byte[] pref = wc.prefix();
        int l = Math.min(this.tp.length - 1, wc.max());
        for (int ti = pref.length; ti <= l; ++ti) {
            byte[] t;
            int i = this.tp[ti];
            if (i == -1) continue;
            int c = ti + 1;
            int e = -1;
            while (c < this.tp.length && e == -1) {
                e = this.tp[c++];
            }
            for (i = this.find(pref, i, e, ti); i < e && Token.startsWith(t = this.inY.readBytes(i, ti), pref); i += ti + 9) {
                if (!wc.match(t)) continue;
                this.inZ.cursor(this.pointer(i, ti));
                int s = this.size(i, ti);
                for (int d = 0; d < s; ++d) {
                    pr.add(this.inZ.readNum());
                    ps.add(this.inZ.readNum());
                }
            }
        }
        return this.iter(new FTCache(pr, ps));
    }

    private FTIndexIterator iter(long off, int size, DataAccess da) {
        da.cursor(off);
        IntList pr = new IntList(size);
        IntList ps = new IntList(size);
        for (int c = 0; c < size; ++c) {
            pr.add(da.readNum());
            ps.add(da.readNum());
        }
        return this.iter(new FTCache(pr, ps));
    }

    private synchronized FTIndexIterator iter(final FTCache ftc) {
        final int size = ftc.pre.size();
        return new FTIndexIterator(){
            final FTMatches all;
            int pre;
            int c;
            {
                this.all = new FTMatches(this.toknum);
            }

            @Override
            public synchronized boolean more() {
                if (this.c == size) {
                    return false;
                }
                this.all.reset(this.toknum);
                this.pre = ftc.pre.get(ftc.order[this.c]);
                this.all.or(ftc.pos.get(ftc.order[this.c++]));
                while (this.c < size && this.pre == ftc.pre.get(ftc.order[this.c])) {
                    this.all.or(ftc.pos.get(ftc.order[this.c++]));
                }
                return true;
            }

            @Override
            public synchronized FTMatches matches() {
                return this.all;
            }

            @Override
            public synchronized int next() {
                return this.pre;
            }

            @Override
            public synchronized int size() {
                return size;
            }

            public String toString() {
                return Integer.toString(size);
            }
        };
    }

    static final class FTCache {
        int[] order;
        IntList pre;
        IntList pos;

        FTCache(IntList pr, IntList ps) {
            int s = pr.size();
            double[] v = new double[s];
            for (int i = 0; i < s; ++i) {
                v[i] = (long)pr.get(i) << 32 | (long)ps.get(i);
            }
            this.order = Array.createOrder(v, true);
            this.pre = pr;
            this.pos = ps;
        }
    }
}

