/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.regex.parse;

import org.basex.query.regex.parse.Token;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token curr, int[][] exps, String[] imgs) {
        super(ParseException.initialise(curr, exps, imgs));
        this.currentToken = curr;
        this.expectedTokenSequences = exps;
        this.tokenImage = imgs;
    }

    public ParseException() {
    }

    public ParseException(String message) {
        super(message);
    }

    private static String initialise(Token curr, int[][] exps, String[] img) {
        String eol = System.getProperty("line.separator", "\n");
        StringBuilder expected = new StringBuilder();
        int maxSize = 0;
        for (int[] exp : exps) {
            if (maxSize < exp.length) {
                maxSize = exp.length;
            }
            for (int e : exp) {
                expected.append(img[e]).append(' ');
            }
            if (exp[exp.length - 1] != 0) {
                expected.append("...");
            }
            expected.append(eol).append("    ");
        }
        String retval = "Encountered \"";
        Token tok = curr.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retval = retval + " ";
            }
            if (tok.kind == 0) {
                retval = retval + img[0];
                break;
            }
            retval = retval + " " + img[tok.kind];
            retval = retval + " \"";
            retval = retval + ParseException.addEscapes(tok.image);
            retval = retval + " \"";
            tok = tok.next;
        }
        retval = retval + "\" at line " + curr.next.beginLine + ", column " + curr.next.beginColumn;
        retval = retval + "." + eol;
        retval = exps.length == 1 ? retval + "Was expecting:" + eol + "    " : retval + "Was expecting one of:" + eol + "    ";
        retval = retval + expected.toString();
        return retval;
    }

    static String addEscapes(String str) {
        StringBuilder retval = new StringBuilder();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

