/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import java.util.Arrays;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.Atts;
import org.basex.util.Token;

public final class NamePool {
    private QNm[] names = new QNm[1];
    private boolean[] attr = new boolean[1];
    private int[] occ = new int[1];
    private int size;

    public void add(QNm name, Type type) {
        int i;
        if (type != NodeType.ATT && type != NodeType.ELM) {
            return;
        }
        int n = i = this.index(name, type == NodeType.ATT);
        this.occ[n] = this.occ[n] + 1;
    }

    public void remove(ANode node) {
        int i;
        if (node.type != NodeType.ATT && node.type != NodeType.ELM) {
            return;
        }
        int n = i = this.index(node.qname(), node.type == NodeType.ATT);
        this.occ[n] = this.occ[n] - 1;
    }

    QNm duplicate() {
        for (int i = 0; i < this.size; ++i) {
            if (this.occ[i] <= 1) continue;
            return this.names[i];
        }
        return null;
    }

    boolean nsOK() {
        Atts at = new Atts();
        for (int i = 0; i < this.size; ++i) {
            if (this.occ[i] <= 0) continue;
            QNm nm = this.names[i];
            byte[] pref = nm.prefix();
            byte[] uri = nm.uri();
            byte[] u = at.string(pref);
            if (u == null) {
                at.add(pref, uri);
                continue;
            }
            if (Token.eq(uri, u)) continue;
            return false;
        }
        return true;
    }

    private int index(QNm name, boolean at) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.names[i].eq(name) || this.attr[i] != at) continue;
            return i;
        }
        if (this.size == this.names.length) {
            this.names = Arrays.copyOf(this.names, this.size << 1);
            this.attr = Arrays.copyOf(this.attr, this.size << 1);
            this.occ = Arrays.copyOf(this.occ, this.size << 1);
        }
        this.names[this.size] = name;
        this.attr[this.size] = at;
        return this.size++;
    }
}

