/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.Arrays;
import org.basex.util.list.IntList;

public final class Array {
    public static final double RESIZE = 1.5;

    private Array() {
    }

    public static byte[][] copyOf(byte[][] a, int s) {
        byte[][] tmp = new byte[s][];
        System.arraycopy(a, 0, tmp, 0, Math.min(s, a.length));
        return tmp;
    }

    public static int[][] copyOf(int[][] a, int s) {
        int[][] tmp = new int[s][];
        System.arraycopy(a, 0, tmp, 0, Math.min(s, a.length));
        return tmp;
    }

    public static String[] copyOf(String[] a, int s) {
        String[] tmp = new String[s];
        System.arraycopy(a, 0, tmp, 0, Math.min(s, a.length));
        return tmp;
    }

    public static <T> T[] add(T[] ar, T e) {
        int s = ar.length;
        T[] t = Arrays.copyOf(ar, s + 1);
        t[s] = e;
        return t;
    }

    public static int[] add(int[] ar, int e) {
        int s = ar.length;
        int[] t = Arrays.copyOf(ar, s + 1);
        t[s] = e;
        return t;
    }

    public static void move(Object ar, int pos, int off, int l) {
        System.arraycopy(ar, pos, ar, pos + off, l);
    }

    public static <T> T[] delete(T[] ar, int p) {
        int s = ar.length - 1;
        Array.move(ar, p + 1, -1, s - p);
        return Arrays.copyOf(ar, s);
    }

    public static int[] createOrder(byte[][] tok, boolean num, boolean asc) {
        IntList il = Array.number(tok.length);
        il.sort(tok, num, asc);
        return il.toArray();
    }

    public static int[] createOrder(double[] tok, boolean asc) {
        IntList il = Array.number(tok.length);
        il.sort(tok, asc);
        return il.toArray();
    }

    public static int[] createOrder(int[] tok, boolean asc) {
        IntList il = Array.number(tok.length);
        il.sort(tok, asc);
        return il.toArray();
    }

    private static IntList number(int l) {
        int[] tmp = new int[l];
        for (int i = 0; i < l; ++i) {
            tmp[i] = i;
        }
        return new IntList(tmp);
    }

    public static void reverse(byte[] arr) {
        Array.reverse(arr, 0, arr.length);
    }

    private static void reverse(byte[] arr, int pos, int len) {
        int l = pos;
        for (int r = pos + len - 1; l < r; ++l, --r) {
            byte tmp = arr[l];
            arr[l] = arr[r];
            arr[r] = tmp;
        }
    }

    public static void reverse(Object[] arr, int pos, int len) {
        int l = pos;
        for (int r = pos + len - 1; l < r; ++l, --r) {
            Object tmp = arr[l];
            arr[l] = arr[r];
            arr[r] = tmp;
        }
    }

    public static int newSize(int old) {
        return Array.newSize(old, 1.5);
    }

    public static int newSize(int old, double factor) {
        return (int)((double)old * factor) + 1;
    }

    public static void swap(int[] arr, int a, int b) {
        int c = arr[a];
        arr[a] = arr[b];
        arr[b] = c;
    }

    public static void swap(int[] arr, int a, int b, int n) {
        for (int i = 0; i < n; ++i) {
            Array.swap(arr, a + i, b + i);
        }
    }
}

