/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.plugins;

import java.awt.Component;
import java.util.HashSet;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.flap.module.BaseModule;
import nl.mpi.flap.plugin.KinOathPanelPlugin;
import nl.mpi.flap.plugin.PluginException;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;
import nl.mpi.pluginloader.PluginManager;

public class KinOathPluginManager
implements PluginManager {
    private final AbstractDiagramManager diagramWindowManager;
    private final ArbilWindowManager dialogHandler;
    private final Component parentComponent;
    private final HashSet<BaseModule> hashSet = new HashSet();

    public KinOathPluginManager(AbstractDiagramManager diagramWindowManager, ArbilWindowManager dialogHandler, Component parentComponent) {
        this.diagramWindowManager = diagramWindowManager;
        this.dialogHandler = dialogHandler;
        this.parentComponent = parentComponent;
    }

    private void setPluginPanel(KinOathPanelPlugin kinOathPanelPlugin, boolean isVisible) throws PluginException {
        SavePanel currentSavePanel = this.diagramWindowManager.getCurrentSavePanel(this.parentComponent);
        if (currentSavePanel instanceof KinDiagramPanel) {
            ((KinDiagramPanel)currentSavePanel).addPluginPanel(kinOathPanelPlugin, isVisible);
        }
    }

    public void activatePlugin(BaseModule kinOathPlugin) {
        if (kinOathPlugin instanceof KinOathPanelPlugin) {
            try {
                this.setPluginPanel((KinOathPanelPlugin)kinOathPlugin, true);
                this.hashSet.add(kinOathPlugin);
            }
            catch (PluginException exception) {
                this.dialogHandler.addMessageDialogToQueue("Failed to activate the requested plugin.\n" + exception.getMessage() + "\n" + kinOathPlugin.getName() + "\n" + kinOathPlugin.getMajorVersionNumber() + "." + kinOathPlugin.getMinorVersionNumber() + "." + kinOathPlugin.getBuildVersionNumber() + "\n" + kinOathPlugin.getDescription(), "Enable Plugin Error");
            }
        } else {
            this.dialogHandler.addMessageDialogToQueue("No method to activate this type of plugin yet.\n" + kinOathPlugin.getName() + "\n" + kinOathPlugin.getMajorVersionNumber() + "." + kinOathPlugin.getMinorVersionNumber() + "." + kinOathPlugin.getBuildVersionNumber() + "\n" + kinOathPlugin.getDescription(), "Enable Plugin");
        }
    }

    public void deactivatePlugin(BaseModule kinOathPlugin) {
        if (kinOathPlugin instanceof KinOathPanelPlugin) {
            try {
                this.setPluginPanel((KinOathPanelPlugin)kinOathPlugin, false);
                this.hashSet.remove(kinOathPlugin);
            }
            catch (PluginException exception) {
                this.dialogHandler.addMessageDialogToQueue("Failed to deactivate the requested plugin.\n" + exception.getMessage() + "\n" + kinOathPlugin.getName() + "\n" + kinOathPlugin.getMajorVersionNumber() + "." + kinOathPlugin.getMinorVersionNumber() + "." + kinOathPlugin.getBuildVersionNumber() + "\n" + kinOathPlugin.getDescription(), "Enable Plugin Error");
            }
        } else {
            this.dialogHandler.addMessageDialogToQueue("No method to deactivate this type of plugin yet.\n" + kinOathPlugin.getName() + "\n" + kinOathPlugin.getMajorVersionNumber() + "." + kinOathPlugin.getMinorVersionNumber() + "." + kinOathPlugin.getBuildVersionNumber() + "\n" + kinOathPlugin.getDescription(), "Enable Plugin");
        }
    }

    public boolean isActivated(BaseModule kinOathPlugin) {
        return this.hashSet.contains(kinOathPlugin);
    }
}

