/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import nl.mpi.kinnate.SavePanel;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;
import org.apache.fop.svg.PDFTranscoder;
import org.w3c.dom.Document;

public class DiagramTranscoder {
    private OutputType outputType = OutputType.PDF;
    private File outputFile;
    private SavePanel savePanel;
    private Dimension2D diagramSize;

    public DiagramTranscoder(SavePanel savePanel) {
        this.savePanel = savePanel;
        this.diagramSize = savePanel.getGraphPanel().getDiagramSize();
    }

    public Dimension getCurrentSize() {
        if (this.diagramSize != null) {
            return new Dimension((int)this.diagramSize.getWidth(), (int)this.diagramSize.getHeight());
        }
        return null;
    }

    public OutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(OutputType outputType) {
        this.outputType = outputType;
    }

    public void exportDiagram(File outputFile) throws IOException, TranscoderException {
        JPEGTranscoder transcoder;
        this.outputFile = outputFile;
        switch (this.outputType) {
            case JPEG: {
                this.fixSuffix(".jpg");
                transcoder = new JPEGTranscoder();
                transcoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
                break;
            }
            case PNG: {
                this.fixSuffix(".png");
                transcoder = new PNGTranscoder();
                break;
            }
            case TIFF: {
                this.fixSuffix(".tif");
                transcoder = new TIFFTranscoder();
                break;
            }
            default: {
                this.fixSuffix(".pdf");
                transcoder = new PDFTranscoder();
                transcoder.addTranscodingHint(PDFTranscoder.KEY_STROKE_TEXT, (Object)Boolean.FALSE);
            }
        }
        transcoder.addTranscodingHint(ImageTranscoder.KEY_BACKGROUND_COLOR, (Object)Color.WHITE);
        transcoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING, (Object)Boolean.FALSE);
        this.transcodeDom((Transcoder)transcoder);
    }

    private void fixSuffix(String requiredSuffix) {
        if (!this.outputFile.getName().toLowerCase().endsWith(requiredSuffix)) {
            String fileName = this.outputFile.getName();
            fileName = fileName.replaceFirst("\\....$", "");
            this.outputFile = new File(this.outputFile.getParentFile(), fileName + requiredSuffix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transcodeDom(Transcoder transcoder) throws IOException, TranscoderException {
        TranscoderInput transcoderInput = new TranscoderInput((Document)this.savePanel.getGraphPanel().doc);
        OutputStream outputStream = new FileOutputStream(this.outputFile);
        outputStream = new BufferedOutputStream(outputStream);
        try {
            TranscoderOutput transcoderOutput = new TranscoderOutput(outputStream);
            transcoder.transcode(transcoderInput, transcoderOutput);
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputType {
        PDF,
        JPEG,
        PNG,
        TIFF;

    }
}

