/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg.relationlines;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kindata.RelationTypeDefinition;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.svg.OldFormatException;
import nl.mpi.kinnate.svg.relationlines.LineLookUpTable;
import nl.mpi.kinnate.svg.relationlines.LineRecord;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationRecord {
    private String groupName = null;
    public String idString;
    public String lineIdString;
    public GraphPanel graphPanel;
    public EntityData leftEntity;
    public EntityData rightEntity;
    public DataTypes.RelationType directedRelation;
    public int lineWidth;
    public int lineDash;
    public RelationTypeDefinition.CurveLineOrientation curveLineOrientation;
    public String lineColour;
    public String lineLabel;
    public int hSpacing;
    public int vSpacing;
    public int relationLineIndex;
    public LineRecord lineRecord;
    private String curveLinePoints = null;
    private final String dcrType;
    private final String customType;

    public RelationRecord(String lineIdString, DataTypes.RelationType relationType, float vSpacing, Point egoPoint, Point alterPoint, Point averageParentPassed) throws OldFormatException {
        this.dcrType = null;
        this.customType = null;
        this.lineRecord = this.setPolylinePointsAttribute(lineIdString, relationType, vSpacing, egoPoint.x, egoPoint.y, alterPoint.x, alterPoint.y, averageParentPassed);
    }

    public RelationRecord(RelationTypeDefinition.CurveLineOrientation curveLineOrientation, float hSpacing, float vSpacing, Point egoPoint, Point alterPoint) {
        this.dcrType = null;
        this.customType = null;
        this.curveLinePoints = this.setPathPointsAttribute(curveLineOrientation, hSpacing, vSpacing, egoPoint.x, egoPoint.y, alterPoint.x, alterPoint.y);
    }

    protected RelationRecord(String groupName, GraphPanel graphPanel, int relationLineIndex, EntityData leftEntity, EntityData rightEntity, DataTypes.RelationType directedRelation, String dcrType, String customType, int lineWidth, int lineDash, RelationTypeDefinition.CurveLineOrientation curveLineOrientation, String lineColour, String lineLabel, int hSpacing, int vSpacing) throws OldFormatException {
        this.groupName = groupName;
        this.graphPanel = graphPanel;
        this.leftEntity = leftEntity;
        this.rightEntity = rightEntity;
        this.directedRelation = directedRelation;
        this.dcrType = dcrType;
        this.customType = customType;
        this.lineWidth = lineWidth;
        this.lineDash = lineDash;
        this.curveLineOrientation = curveLineOrientation;
        this.lineColour = lineColour;
        this.lineLabel = lineLabel;
        this.hSpacing = hSpacing;
        this.vSpacing = vSpacing;
        this.relationLineIndex = relationLineIndex;
        this.idString = "relation" + relationLineIndex;
        this.lineIdString = "relation" + relationLineIndex + "Line";
    }

    public boolean pertainsToEntity(ArrayList<UniqueIdentifier> selectedIdentifiers) {
        return selectedIdentifiers.contains(this.leftEntity.getUniqueIdentifier()) || selectedIdentifiers.contains(this.rightEntity.getUniqueIdentifier());
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean belongsToGroup(HashSet<String> groupSet) {
        if (this.groupName != null) {
            return groupSet.contains(this.groupName);
        }
        return false;
    }

    public String getPathPointsString() {
        String returnValue = this.curveLinePoints != null ? this.curveLinePoints : this.lineRecord.getPointsAttribute();
        return returnValue;
    }

    public Point getAverageParentLocation(HashSet<UniqueIdentifier> parentIdSet) {
        Integer maxY = null;
        int averageX = 0;
        int parentCount = 0;
        if (parentIdSet != null) {
            for (UniqueIdentifier parentIdentifier : parentIdSet) {
                Point parentLoc = this.graphPanel.entitySvg.getEntityLocationOffset(parentIdentifier);
                maxY = maxY == null ? Integer.valueOf(parentLoc.y) : Integer.valueOf(maxY >= parentLoc.y ? maxY : parentLoc.y);
                averageX += parentLoc.x;
                ++parentCount;
            }
        }
        averageX /= parentCount;
        if (maxY == null) {
            return null;
        }
        return new Point(averageX, maxY);
    }

    public Point getAverageParentLocation(EntityData entityData) {
        HashSet<UniqueIdentifier> identifierSet = new HashSet<UniqueIdentifier>();
        for (EntityRelation entityRelation : entityData.getAllRelations()) {
            if (entityRelation.getAlterNode() == null || !entityRelation.getAlterNode().isVisible || !entityRelation.isSameType(DataTypes.RelationType.ancestor, this.dcrType, this.customType)) continue;
            identifierSet.add(entityRelation.alterUniqueIdentifier);
        }
        if (identifierSet.size() < 2) {
            return null;
        }
        return this.getAverageParentLocation(identifierSet);
    }

    public void updatePathPoints(LineLookUpTable lineLookUpTable) throws OldFormatException {
        Point parentPoint = null;
        Point egoSymbolPoint = this.graphPanel.entitySvg.getEntityLocationOffset(this.leftEntity.getUniqueIdentifier());
        Point alterSymbolPoint = this.graphPanel.entitySvg.getEntityLocationOffset(this.rightEntity.getUniqueIdentifier());
        if (this.directedRelation != DataTypes.RelationType.sibling && this.directedRelation != DataTypes.RelationType.union) {
            parentPoint = this.getAverageParentLocation(this.leftEntity);
        }
        int fromX = egoSymbolPoint.x;
        int fromY = egoSymbolPoint.y;
        int toX = alterSymbolPoint.x;
        int toY = alterSymbolPoint.y;
        if (!DataTypes.isSanguinLine(this.directedRelation)) {
            this.curveLinePoints = this.setPathPointsAttribute(this.curveLineOrientation, this.hSpacing, this.vSpacing, fromX, fromY, toX, toY);
        } else {
            this.lineRecord = this.setPolylinePointsAttribute(this.lineIdString, this.directedRelation, this.vSpacing, fromX, fromY, toX, toY, parentPoint);
            lineLookUpTable.addRecord(this.lineRecord);
        }
    }

    private LineRecord setPolylinePointsAttribute(String lineIdString, DataTypes.RelationType relationType, float vSpacing, float egoX, float egoY, float alterX, float alterY, Point averageParentPassed) throws OldFormatException {
        float alterYmid;
        float egoYmid;
        ArrayList<Point> initialPointsList = new ArrayList<Point>();
        Point averageParent = null;
        float midSpacing = vSpacing / 2.0f;
        float centerX = (egoX + alterX) / 2.0f;
        switch (relationType) {
            case ancestor: {
                averageParent = averageParentPassed == null ? new Point((int)alterX, (int)alterY) : averageParentPassed;
                egoYmid = egoY - midSpacing + 10.0f;
                alterYmid = averageParent.y + 30;
                centerX = egoYmid < alterYmid ? centerX : egoX;
                centerX = egoY < alterY && egoX == alterX ? centerX - midSpacing : centerX;
                break;
            }
            case descendant: {
                throw new OldFormatException("This diagram needs to be updated, select recalculate diagram from the edit menu before continuing.");
            }
            case sibling: {
                if (averageParentPassed != null) {
                    throw new UnsupportedOperationException();
                }
                egoYmid = egoY - midSpacing + 16.0f;
                alterYmid = alterY - midSpacing + 16.0f;
                centerX = egoY < alterY ? alterX : egoX;
                centerX = egoX == alterX ? centerX - midSpacing : centerX;
                break;
            }
            case union: {
                if (averageParentPassed != null) {
                    throw new UnsupportedOperationException();
                }
                egoYmid = egoY + 30.0f;
                alterYmid = alterY + 30.0f;
                centerX = egoY < alterY ? egoX : alterX;
                centerX = egoX == alterX ? centerX - midSpacing : centerX;
                break;
            }
            default: {
                egoYmid = egoY + 10.0f;
                alterYmid = alterY + 10.0f;
            }
        }
        initialPointsList.add(new Point((int)egoX, (int)egoY));
        initialPointsList.add(new Point((int)egoX, (int)egoYmid));
        if (averageParent != null) {
            float averageParentX = averageParent.x;
            float centerParentX = (egoX + averageParentX) / 2.0f;
            float lowerParentLineY = (float)averageParent.y + midSpacing + 10.0f;
            if (egoY >= (float)averageParent.y + vSpacing) {
                initialPointsList.add(new Point((int)egoX, (int)lowerParentLineY));
                initialPointsList.add(new Point((int)averageParentX, (int)lowerParentLineY));
                initialPointsList.add(new Point((int)averageParentX, (int)alterYmid));
            } else {
                initialPointsList.add(new Point((int)centerParentX, (int)egoYmid));
                initialPointsList.add(new Point((int)centerParentX, (int)lowerParentLineY));
                initialPointsList.add(new Point((int)averageParentX, (int)lowerParentLineY));
                initialPointsList.add(new Point((int)averageParentX, (int)alterYmid));
            }
        } else {
            initialPointsList.add(new Point((int)centerX, (int)egoYmid));
            initialPointsList.add(new Point((int)centerX, (int)alterYmid));
        }
        if (averageParentPassed == null) {
            initialPointsList.add(new Point((int)alterX, (int)alterYmid));
            initialPointsList.add(new Point((int)alterX, (int)alterY));
        } else {
            initialPointsList.add((Point)initialPointsList.get(initialPointsList.size() - 1));
        }
        return new LineRecord(this.groupName, lineIdString, initialPointsList);
    }

    private String setPathPointsAttribute(RelationTypeDefinition.CurveLineOrientation curveLineOrientation, float hSpacing, float vSpacing, float egoX, float egoY, float alterX, float alterY) {
        float toBezY;
        float fromBezY;
        float toBezX;
        float fromBezX;
        if (curveLineOrientation == RelationTypeDefinition.CurveLineOrientation.vertical) {
            fromBezX = egoX;
            toBezX = alterX;
            if (egoY > alterY) {
                if (egoY - alterY < hSpacing / 4.0f) {
                    fromBezY = egoY - hSpacing / 4.0f;
                    toBezY = alterY - hSpacing / 4.0f;
                } else {
                    fromBezY = (egoY - alterY) / 2.0f + alterY;
                    toBezY = (egoY - alterY) / 2.0f + alterY;
                }
            } else if (alterY - egoY < hSpacing / 4.0f) {
                fromBezY = egoY + hSpacing / 4.0f;
                toBezY = alterY + hSpacing / 4.0f;
            } else {
                fromBezY = (alterY - egoY) / 2.0f + egoY;
                toBezY = (alterY - egoY) / 2.0f + egoY;
            }
            float distanceX = Math.abs(egoX - alterX);
            if (distanceX < hSpacing / 4.0f) {
                boolean quadrantType = egoY > alterY == egoY > alterY;
                float curveToAdd = hSpacing / 8.0f;
                if (quadrantType) {
                    fromBezX -= curveToAdd;
                    toBezX += curveToAdd;
                } else {
                    fromBezX += curveToAdd;
                    toBezX -= curveToAdd;
                }
            }
        } else {
            fromBezY = egoY;
            toBezY = alterY;
            if (egoX > alterX) {
                if (egoX - alterX < hSpacing / 4.0f) {
                    fromBezX = egoX - hSpacing / 4.0f;
                    toBezX = alterX - hSpacing / 4.0f;
                } else {
                    fromBezX = (egoX - alterX) / 2.0f + alterX;
                    toBezX = (egoX - alterX) / 2.0f + alterX;
                }
            } else if (alterX - egoX < hSpacing / 4.0f) {
                fromBezX = egoX + hSpacing / 4.0f;
                toBezX = alterX + hSpacing / 4.0f;
            } else {
                fromBezX = (alterX - egoX) / 2.0f + egoX;
                toBezX = (alterX - egoX) / 2.0f + egoX;
            }
            float distanceY = Math.abs(egoY - alterY);
            if (distanceY < hSpacing / 4.0f) {
                boolean quadrantType = egoX > alterX == egoY > alterY;
                float curveToAdd = hSpacing / 8.0f;
                if (quadrantType) {
                    fromBezY -= curveToAdd;
                    toBezY += curveToAdd;
                } else {
                    fromBezY += curveToAdd;
                    toBezY -= curveToAdd;
                }
            }
        }
        return "M " + egoX + "," + egoY + " C " + fromBezX + "," + fromBezY + " " + toBezX + "," + toBezY + " " + alterX + "," + alterY;
    }
}

