/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ContainerNode;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.data.KinTreeNode;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kintypestrings.ParserHighlight;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.KinDragTransferHandler;
import nl.mpi.kinnate.ui.KinTree;
import nl.mpi.kinnate.ui.KinTypeStringProvider;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class EntitySearchPanel
extends JPanel
implements KinTypeStringProvider {
    private EntityCollection entityCollection;
    private KinTree resultsTree;
    private JTextArea resultsArea = new JTextArea();
    private JCheckBox graphSelectionCheckBox;
    private JCheckBox expandByKinTypeCheckBox;
    private JCheckBox diagramSelectionCheckBox;
    private JTextField kinTypeStringTextArea;
    private JTextField searchField;
    private JProgressBar progressBar;
    private JButton searchButton;
    private JPanel searchPanel;
    private GraphPanel graphPanel;
    private MessageDialogHandler dialogHandler;
    private ArbilDataNodeLoader dataNodeLoader;
    private String kinTypeString = "P";
    ContainerNode rootNode;

    public EntitySearchPanel(EntityCollection entityCollection, KinDiagramPanel kinDiagramPanel, GraphPanel graphPanel, MessageDialogHandler dialogHandler, ArbilDataNodeLoader dataNodeLoader, String nodeSetTitle, UniqueIdentifier[] entityIdentifiers) {
        this.InitPanel(entityCollection, kinDiagramPanel, graphPanel, dialogHandler, dataNodeLoader, nodeSetTitle, entityIdentifiers);
    }

    public EntitySearchPanel(EntityCollection entityCollection, KinDiagramPanel kinDiagramPanel, GraphPanel graphPanel, MessageDialogHandler dialogHandler, ArbilDataNodeLoader dataNodeLoader) {
        this.InitPanel(entityCollection, kinDiagramPanel, graphPanel, dialogHandler, dataNodeLoader, "Search Entity Names", null);
    }

    private void InitPanel(EntityCollection entityCollection, final KinDiagramPanel kinDiagramPanel, GraphPanel graphPanel, MessageDialogHandler dialogHandler, ArbilDataNodeLoader dataNodeLoader, String nodeSetTitle, UniqueIdentifier[] entityIdentifiers) {
        this.entityCollection = entityCollection;
        this.graphPanel = graphPanel;
        this.dialogHandler = dialogHandler;
        this.dataNodeLoader = dataNodeLoader;
        this.setLayout(new BorderLayout());
        this.rootNode = new ContainerNode(null, "results", null, new ArbilNode[0]);
        this.resultsTree = new KinTree(kinDiagramPanel, graphPanel, this.rootNode);
        JLabel searchLabel = new JLabel(nodeSetTitle);
        this.searchField = new JTextField();
        this.searchField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    EntitySearchPanel.this.performSearch();
                }
                super.keyReleased(e);
            }
        });
        this.progressBar = new JProgressBar();
        this.searchButton = new JButton("Search");
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntitySearchPanel.this.performSearch();
            }
        });
        this.searchPanel = new JPanel();
        this.searchPanel.setLayout(new BorderLayout());
        this.searchPanel.add((Component)searchLabel, "First");
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 3));
        this.searchPanel.add((Component)optionsPanel, "Center");
        if (entityIdentifiers == null) {
            optionsPanel.add(this.searchField);
        }
        this.graphSelectionCheckBox = new JCheckBox("Graph selection", true);
        this.resultsTree.setUpdateGraphOnSelectionChange(true);
        optionsPanel.add(this.graphSelectionCheckBox);
        this.expandByKinTypeCheckBox = new JCheckBox("Expand selection by kin type string", false);
        optionsPanel.add(this.expandByKinTypeCheckBox);
        this.kinTypeStringTextArea = new JTextField(this.kinTypeString);
        this.kinTypeStringTextArea.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyReleased(KeyEvent e) {
                KeyEvent keyEvent = e;
                synchronized (keyEvent) {
                    if (!EntitySearchPanel.this.kinTypeStringTextArea.getText().equals(EntitySearchPanel.this.kinTypeString)) {
                        EntitySearchPanel.this.kinTypeString = EntitySearchPanel.this.kinTypeStringTextArea.getText();
                        if (EntitySearchPanel.this.expandByKinTypeCheckBox.isSelected() && EntitySearchPanel.this.graphSelectionCheckBox.isSelected()) {
                            kinDiagramPanel.drawGraph(true);
                        }
                    }
                }
            }
        });
        optionsPanel.add(this.kinTypeStringTextArea);
        this.graphSelectionCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntitySearchPanel.this.expandByKinTypeCheckBox.setEnabled(EntitySearchPanel.this.graphSelectionCheckBox.isSelected());
                EntitySearchPanel.this.kinTypeStringTextArea.setEnabled(EntitySearchPanel.this.expandByKinTypeCheckBox.isSelected() && EntitySearchPanel.this.graphSelectionCheckBox.isSelected());
                kinDiagramPanel.drawGraph(true);
                EntitySearchPanel.this.resultsTree.setUpdateGraphOnSelectionChange(EntitySearchPanel.this.graphSelectionCheckBox.isSelected());
            }
        });
        this.kinTypeStringTextArea.setEnabled(this.expandByKinTypeCheckBox.isSelected() && this.graphSelectionCheckBox.isSelected());
        this.expandByKinTypeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntitySearchPanel.this.kinTypeStringTextArea.setEnabled(EntitySearchPanel.this.expandByKinTypeCheckBox.isSelected());
                kinDiagramPanel.drawGraph(true);
            }
        });
        this.diagramSelectionCheckBox = new JCheckBox("Replace search with diagram selection", false);
        if (entityIdentifiers == null) {
            this.searchPanel.add((Component)this.searchButton, "Last");
        }
        this.add((Component)this.searchPanel, "First");
        this.add((Component)new JScrollPane((Component)((Object)this.resultsTree)), "Center");
        this.add((Component)this.resultsArea, "Last");
        if (entityIdentifiers != null) {
            this.loadCollection(entityIdentifiers);
        }
    }

    public void setTransferHandler(KinDragTransferHandler dragTransferHandler) {
        this.resultsTree.setTransferHandler(dragTransferHandler);
        this.resultsTree.setDragEnabled(true);
    }

    protected void performSearch() {
        this.searchPanel.remove(this.searchButton);
        this.progressBar.setIndeterminate(true);
        this.searchPanel.add((Component)this.progressBar, "Last");
        this.searchPanel.revalidate();
        new Thread(){

            public void run() {
                try {
                    ArrayList<KinTreeNode> resultsArray = new ArrayList<KinTreeNode>();
                    EntityData[] searchResults = EntitySearchPanel.this.entityCollection.getEntityByKeyWord(EntitySearchPanel.this.searchField.getText(), EntitySearchPanel.this.graphPanel.getIndexParameters());
                    EntitySearchPanel.this.resultsArea.setText("Found " + searchResults.length + " entities\n");
                    for (EntityData entityData : searchResults) {
                        resultsArray.add(new KinTreeNode(EntitySearchPanel.this.graphPanel.getSymbolGraphic(), entityData.getUniqueIdentifier(), entityData, ((EntitySearchPanel)EntitySearchPanel.this).graphPanel.dataStoreSvg, EntitySearchPanel.this.graphPanel.getIndexParameters(), EntitySearchPanel.this.dialogHandler, EntitySearchPanel.this.entityCollection, EntitySearchPanel.this.dataNodeLoader));
                    }
                    EntitySearchPanel.this.rootNode.setChildNodes(resultsArray.toArray(new ArbilNode[0]));
                    EntitySearchPanel.this.resultsTree.requestResort();
                    EntitySearchPanel.this.searchPanel.remove(EntitySearchPanel.this.progressBar);
                    EntitySearchPanel.this.searchPanel.add((Component)EntitySearchPanel.this.searchButton, "Last");
                    EntitySearchPanel.this.searchPanel.revalidate();
                }
                catch (EntityServiceException exception) {
                    EntitySearchPanel.this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Perform Search");
                }
            }
        }.start();
    }

    protected void loadCollection(final UniqueIdentifier[] entityIdentifiers) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(entityIdentifiers.length);
        this.progressBar.setValue(0);
        this.searchPanel.add((Component)this.progressBar, "Last");
        this.searchPanel.revalidate();
        new Thread(){

            public void run() {
                HashSet<KinTreeNode> resultsArray = new HashSet<KinTreeNode>();
                EntitySearchPanel.this.resultsArea.setText("Loading " + entityIdentifiers.length + " entities\n");
                int loadedCount = 0;
                for (UniqueIdentifier entityId : entityIdentifiers) {
                    EntityData entityData = EntitySearchPanel.this.entityCollection.getEntity(entityId, EntitySearchPanel.this.graphPanel.getIndexParameters());
                    resultsArray.add(new KinTreeNode(EntitySearchPanel.this.graphPanel.getSymbolGraphic(), entityData.getUniqueIdentifier(), entityData, ((EntitySearchPanel)EntitySearchPanel.this).graphPanel.dataStoreSvg, EntitySearchPanel.this.graphPanel.getIndexParameters(), EntitySearchPanel.this.dialogHandler, EntitySearchPanel.this.entityCollection, EntitySearchPanel.this.dataNodeLoader));
                    EntitySearchPanel.this.rootNode.setChildNodes(resultsArray.toArray(new ArbilNode[0]));
                    EntitySearchPanel.this.resultsTree.requestResort();
                    EntitySearchPanel.this.resultsArea.setText("Loaded " + ++loadedCount + " of " + entityIdentifiers.length + " entities\n");
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            EntitySearchPanel.this.progressBar.setValue(EntitySearchPanel.this.progressBar.getValue() + 1);
                        }
                    });
                }
                EntitySearchPanel.this.resultsArea.setText("");
                EntitySearchPanel.this.resultsArea.setVisible(false);
                EntitySearchPanel.this.searchPanel.remove(EntitySearchPanel.this.progressBar);
                EntitySearchPanel.this.searchPanel.revalidate();
            }
        }.start();
    }

    public String[] getCurrentStrings() {
        ArrayList<String> currentStrings = new ArrayList<String>();
        if (this.graphSelectionCheckBox.isSelected()) {
            String kinTypeStringExtention = "";
            String prefixString = "x";
            if (this.expandByKinTypeCheckBox.isSelected()) {
                kinTypeStringExtention = this.kinTypeString;
                prefixString = "E";
            }
            for (ArbilNode arbilNode : this.resultsTree.getSelectedNodeArray()) {
                if (!(arbilNode instanceof KinTreeNode)) continue;
                for (String kinTypeStringItem : kinTypeStringExtention.split(",")) {
                    currentStrings.add(prefixString + "[Entity.Identifier=" + ((KinTreeNode)arbilNode).getUniqueIdentifier().getQueryIdentifier() + "]" + kinTypeStringItem);
                }
            }
        }
        return currentStrings.toArray(new String[0]);
    }

    public int getTotalLength() {
        if (this.graphSelectionCheckBox.isSelected()) {
            return this.resultsTree.getSelectedNodeArray().length;
        }
        return 0;
    }

    public void highlightKinTypeStrings(ParserHighlight[] parserHighlight, String[] kinTypeStrings) {
    }
}

