/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.XsdChecker;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.gedcomimport.CsvImporter;
import nl.mpi.kinnate.gedcomimport.GedcomImporter;
import nl.mpi.kinnate.gedcomimport.GenericImporter;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.gedcomimport.KinOathImporter;
import nl.mpi.kinnate.gedcomimport.TipImporter;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.entityprofiles.ProfileRecord;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class GedcomImportPanel
extends JPanel {
    private final EntityCollection entityCollection;
    private final AbstractDiagramManager abstractDiagramManager;
    private final KinDiagramPanel kinDiagramPanel;
    private JTextArea importTextArea;
    private JProgressBar progressBar;
    private JCheckBox overwriteOnImport;
    private JCheckBox validateImportedXml;
    private JButton cancelButton;
    private JButton startButton;
    private JButton closeButton;
    private JPanel endPagePanel;
    private final SessionStorage sessionStorage;
    private final ArbilWindowManager dialogHandler;
    private final ArbilDataNodeLoader dataNodeLoader;
    private final ArbilTreeHelper treeHelper;
    private JDialog dialoguePanel;
    private Component errorPanel = null;

    public GedcomImportPanel(AbstractDiagramManager abstractDiagramManager, KinDiagramPanel kinDiagramPanel, SessionStorage sessionStorage, ArbilWindowManager dialogHandler, ArbilDataNodeLoader dataNodeLoader, ArbilTreeHelper treeHelper) {
        this.setPreferredSize(new Dimension(500, 500));
        this.abstractDiagramManager = abstractDiagramManager;
        this.kinDiagramPanel = kinDiagramPanel;
        this.entityCollection = kinDiagramPanel.getEntityCollection();
        this.sessionStorage = sessionStorage;
        this.dialogHandler = dialogHandler;
        this.dataNodeLoader = dataNodeLoader;
        this.treeHelper = treeHelper;
    }

    protected String getCreatedNodesMessage(final GenericImporter gedcomImporter) {
        if (gedcomImporter.getCreatedNodeIds().isEmpty()) {
            return "No data was imported, nothing to show in the graph.";
        }
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HashSet<UniqueIdentifier> selectedIds = new HashSet<UniqueIdentifier>();
                for (HashSet<UniqueIdentifier> identifiers : gedcomImporter.getCreatedNodeIds().values()) {
                    selectedIds.addAll(identifiers);
                }
                GedcomImportPanel.this.kinDiagramPanel.addNodeCollection(selectedIds.toArray(new UniqueIdentifier[0]), "Imported Entities");
                GedcomImportPanel.this.kinDiagramPanel.loadAllTrees();
                GedcomImportPanel.this.dialoguePanel.dispose();
            }
        });
        this.closeButton.setEnabled(true);
        return "Import complete.";
    }

    public void startImport(File importFile) throws ImportException {
        this.startImport(importFile, null, importFile.getName());
    }

    public void startImport(String importUriString) throws ImportException {
        File cachedFile = this.sessionStorage.updateCache(importUriString, 30, true);
        this.startImport(cachedFile, null, importUriString);
    }

    public void startImportJar(String importFileString) throws ImportException {
        this.startImport(null, importFileString, importFileString);
    }

    private void startImport(final File importFile, final String importFileString, String importLabel) throws ImportException {
        if (importFile != null && !importFile.exists()) {
            throw new ImportException("The import file was not found.");
        }
        this.importTextArea = new JTextArea();
        JScrollPane importScrollPane = new JScrollPane(this.importTextArea);
        this.setLayout(new BorderLayout());
        this.add((Component)importScrollPane, "Center");
        String titleString = importFile != null ? "Import: " + importFile.getName() : "Import: " + importFileString.substring(importFileString.lastIndexOf("/") + 1);
        this.setName(titleString);
        this.progressBar = new JProgressBar(0, 100);
        this.endPagePanel = new JPanel(new BorderLayout());
        this.endPagePanel.add((Component)this.progressBar, "First");
        this.add((Component)this.endPagePanel, "Last");
        this.progressBar.setVisible(true);
        JPanel bottomPanel = new JPanel();
        JPanel topPanel = new JPanel();
        final JComboBox<ProfileRecord> profileSelectBox = new JComboBox<ProfileRecord>(this.kinDiagramPanel.getGraphPanel().dataStoreSvg.selectedProfiles);
        ProfileRecord defaultImportProfile = ProfileRecord.getDefaultImportProfile();
        profileSelectBox.addItem(defaultImportProfile);
        profileSelectBox.setSelectedItem(defaultImportProfile);
        topPanel.add(profileSelectBox);
        this.overwriteOnImport = new JCheckBox("Overwrite Existing");
        this.overwriteOnImport.setEnabled(false);
        this.cancelButton = new JButton("Cancel");
        this.startButton = new JButton("Start Import");
        this.closeButton = new JButton("Close");
        this.closeButton.setEnabled(false);
        topPanel.add(this.overwriteOnImport);
        this.validateImportedXml = new JCheckBox("Validate Xml");
        topPanel.add(this.validateImportedXml);
        bottomPanel.add(this.cancelButton);
        bottomPanel.add(this.startButton);
        bottomPanel.add(this.closeButton);
        JPanel topOuterPanel = new JPanel(new BorderLayout());
        final JLabel messageLabel = new JLabel(importLabel, 0);
        this.endPagePanel.add((Component)messageLabel, "Center");
        topOuterPanel.add((Component)topPanel, "Center");
        this.endPagePanel.add((Component)bottomPanel, "Last");
        this.add((Component)topOuterPanel, "First");
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GedcomImportPanel.this.cancelButton.setEnabled(false);
                GedcomImportPanel.this.startButton.setEnabled(false);
                GedcomImportPanel.this.overwriteOnImport.setEnabled(false);
                GedcomImportPanel.this.validateImportedXml.setEnabled(false);
                profileSelectBox.setEnabled(false);
                final String profileId = ((ProfileRecord)profileSelectBox.getSelectedItem()).profileId;
                new Thread(){

                    public void run() {
                        try {
                            boolean overwriteExisting = GedcomImportPanel.this.overwriteOnImport.isSelected();
                            GenericImporter genericImporter = null;
                            for (GenericImporter testImporter : new GenericImporter[]{new GedcomImporter(GedcomImportPanel.this.progressBar, GedcomImportPanel.this.importTextArea, overwriteExisting, GedcomImportPanel.this.sessionStorage, GedcomImportPanel.this.entityCollection.getProjectRecord()), new CsvImporter(GedcomImportPanel.this.progressBar, GedcomImportPanel.this.importTextArea, overwriteExisting, GedcomImportPanel.this.sessionStorage, GedcomImportPanel.this.entityCollection.getProjectRecord()), new KinOathImporter(GedcomImportPanel.this.progressBar, GedcomImportPanel.this.importTextArea, overwriteExisting, GedcomImportPanel.this.sessionStorage, GedcomImportPanel.this.entityCollection.getProjectRecord()), new TipImporter(GedcomImportPanel.this.progressBar, GedcomImportPanel.this.importTextArea, overwriteExisting, GedcomImportPanel.this.sessionStorage, GedcomImportPanel.this.entityCollection.getProjectRecord())}) {
                                if (importFileString != null) {
                                    if (!testImporter.canImport(importFileString)) continue;
                                    genericImporter = testImporter;
                                    break;
                                }
                                if (!testImporter.canImport(importFile.toString())) continue;
                                genericImporter = testImporter;
                                break;
                            }
                            if (genericImporter == null) {
                                GedcomImportPanel.this.importTextArea.append("No importers found for this file\n");
                                return;
                            }
                            GedcomImportPanel.this.importTextArea.append("Importing the kinship data (step 1/4)\n");
                            GedcomImportPanel.this.importTextArea.setCaretPosition(GedcomImportPanel.this.importTextArea.getText().length());
                            UniqueIdentifier[] importedIdentifierArray = importFileString != null ? genericImporter.importFile(importFileString, profileId) : genericImporter.importFile(importFile, profileId);
                            boolean checkFilesAfterImport = GedcomImportPanel.this.validateImportedXml.isSelected();
                            if (importedIdentifierArray != null && checkFilesAfterImport) {
                                int maxXsdErrorToShow = 3;
                                GedcomImportPanel.this.importTextArea.append("Checking XML of imported data  (step 3/4)\n");
                                GedcomImportPanel.this.importTextArea.setCaretPosition(GedcomImportPanel.this.importTextArea.getText().length());
                                final int maxProgress = importedIdentifierArray.length + 1;
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        GedcomImportPanel.this.progressBar.setValue(0);
                                        GedcomImportPanel.this.progressBar.setMaximum(maxProgress);
                                    }
                                });
                                for (final UniqueIdentifier currentUniqueIdentifier : importedIdentifierArray) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            GedcomImportPanel.this.progressBar.setValue(GedcomImportPanel.this.progressBar.getValue() + 1);
                                        }
                                    });
                                    if (maxXsdErrorToShow <= 0) continue;
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            XsdChecker xsdChecker = new XsdChecker();
                                            if (xsdChecker.simpleCheck(new File(currentUniqueIdentifier.getFileInProject(GedcomImportPanel.this.entityCollection.getProjectRecord()).toURI())) != null) {
                                                xsdChecker.checkXML(GedcomImportPanel.this.dataNodeLoader.getArbilDataNode(null, currentUniqueIdentifier.getFileInProject(GedcomImportPanel.this.entityCollection.getProjectRecord()).toURI()));
                                                xsdChecker.setDividerLocation(0.5);
                                                if (GedcomImportPanel.this.errorPanel == null) {
                                                    xsdChecker.setName("XSD Error on Import");
                                                    GedcomImportPanel.this.errorPanel = GedcomImportPanel.this.abstractDiagramManager.createDiagramContainer((Component)xsdChecker, null);
                                                } else {
                                                    GedcomImportPanel.this.abstractDiagramManager.createDiagramSubPanel("XSD Error on Import", (Component)xsdChecker, GedcomImportPanel.this.errorPanel);
                                                }
                                            }
                                        }
                                    });
                                    if (--maxXsdErrorToShow > 0) continue;
                                    GedcomImportPanel.this.importTextArea.append("maximum xsd errors shown, no more files will be tested\n");
                                }
                                if (GedcomImportPanel.this.errorPanel instanceof JFrame) {
                                    ((JFrame)GedcomImportPanel.this.errorPanel).pack();
                                }
                            } else {
                                GedcomImportPanel.this.importTextArea.append("Skipping check XML of imported data  (step 3/4)\n");
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    GedcomImportPanel.this.progressBar.setIndeterminate(true);
                                }
                            });
                            GedcomImportPanel.this.importTextArea.append("Starting update of entity database (step 4/4)\n");
                            GedcomImportPanel.this.importTextArea.setCaretPosition(GedcomImportPanel.this.importTextArea.getText().length());
                            GedcomImportPanel.this.entityCollection.updateDatabase(importedIdentifierArray, GedcomImportPanel.this.progressBar);
                            GedcomImportPanel.this.importTextArea.append("Import complete\n");
                            GedcomImportPanel.this.importTextArea.setCaretPosition(GedcomImportPanel.this.importTextArea.getText().length());
                            GedcomImportPanel.this.progressBar.setIndeterminate(false);
                            messageLabel.setText(GedcomImportPanel.this.getCreatedNodesMessage(genericImporter));
                            GedcomImportPanel.this.revalidate();
                        }
                        catch (IOException exception) {
                            GedcomImportPanel.this.importTextArea.append("Import Failed: " + exception.getMessage() + "\n");
                        }
                        catch (ImportException exception) {
                            GedcomImportPanel.this.importTextArea.append("Import Failed:" + exception.getMessage() + "\n");
                        }
                        catch (EntityServiceException exception) {
                            GedcomImportPanel.this.importTextArea.append("Import Failed:" + exception.getMessage() + "\n");
                        }
                        GedcomImportPanel.this.progressBar.setVisible(false);
                    }
                }.start();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GedcomImportPanel.this.dialoguePanel.dispose();
            }
        });
        this.dialoguePanel = this.abstractDiagramManager.createDialogueContainer(this, this.kinDiagramPanel);
        this.dialoguePanel.setVisible(true);
    }
}

