/*
 * Decompiled with CFR 0.152.
 */
package org.basex;

import java.io.IOException;
import org.basex.core.Main;
import org.basex.core.MainProp;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.Check;
import org.basex.core.cmd.Set;
import org.basex.core.cmd.XQuery;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.NewlineInput;
import org.basex.io.in.TextInput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.SerializerProp;
import org.basex.server.LocalSession;
import org.basex.server.Session;
import org.basex.util.Args;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

public class BaseX
extends Main {
    private IntList ops;
    private StringList vals;
    String user;
    String pass;
    private boolean writeProps;

    public static void main(String ... args) {
        try {
            new BaseX(args);
        }
        catch (IOException ex) {
            Util.debug(ex);
            Util.errln(ex, new Object[0]);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseX(String ... args) throws IOException {
        super(args);
        this.session();
        StringBuilder serial = new StringBuilder();
        StringBuilder bind = new StringBuilder();
        boolean v = false;
        boolean qi = false;
        boolean qp = false;
        this.console = true;
        try {
            for (int i = 0; i < this.ops.size(); ++i) {
                IO io;
                int c = this.ops.get(i);
                String val = this.vals.get(i);
                Object[] prop = null;
                if (c == 98) {
                    if (bind.length() != 0) {
                        bind.append(',');
                    }
                    val = bind.append(val.replaceAll(",", ",,")).toString();
                    prop = Prop.BINDINGS;
                } else if (c == 99) {
                    io = IO.get(val);
                    if (io.exists() && !io.isDir()) {
                        this.script(io);
                    } else {
                        this.execute(val);
                    }
                    this.console = false;
                } else if (c == 100) {
                    this.context.mprop.set(MainProp.DEBUG, !this.context.mprop.is(MainProp.DEBUG));
                } else if (c == 68) {
                    prop = Prop.DOTPLAN;
                } else if (c == 105) {
                    this.execute(new Set(Prop.MAINMEM, true), false);
                    this.execute(new Check(val), this.verbose);
                    this.execute(new Set(Prop.MAINMEM, false), false);
                } else if (c == 76) {
                    this.newline ^= true;
                    this.execute(new Set(Prop.SERIALIZER, (Object)(this.newline ? SerializerProp.S_SEPARATOR[0] + "=\\n" : "")), false);
                } else if (c == 111) {
                    if (this.out != System.out) {
                        this.out.close();
                    }
                    this.out = new PrintOutput(val);
                } else if (c == 113) {
                    io = IO.get(val);
                    if (io.exists() && !io.isDir()) {
                        this.query(io);
                    } else {
                        this.execute(new XQuery(val), this.verbose);
                    }
                    this.console = false;
                } else if (c == 114) {
                    prop = Prop.RUNS;
                } else if (c == 115) {
                    if (serial.length() != 0) {
                        serial.append(',');
                    }
                    val = serial.append(val).toString();
                    prop = Prop.SERIALIZER;
                } else if (c == 117) {
                    prop = Prop.WRITEBACK;
                } else if (c == 118) {
                    v ^= true;
                } else if (c == 86) {
                    qi ^= true;
                    prop = Prop.QUERYINFO;
                } else if (c == 119) {
                    prop = Prop.CHOP;
                } else if (c == 87) {
                    this.writeProps ^= true;
                } else if (c == 120) {
                    prop = Prop.XMLPLAN;
                    qp ^= true;
                } else if (c == 88) {
                    prop = Prop.COMPPLAN;
                } else if (c == 122) {
                    prop = Prop.SERIALIZE;
                }
                if (prop != null) {
                    this.execute(new Set(prop, (Object)val), false);
                }
                this.verbose = qi || qp || v;
            }
            if (this.console) {
                this.verbose = true;
                Util.outln(Text.CONSOLE + Text.TRY_MORE_X, this.sa() ? "Standalone" : "Client");
                this.console();
            }
            if (this.writeProps) {
                this.context.mprop.write();
            }
        }
        finally {
            this.quit();
        }
    }

    private void query(IO io) throws IOException {
        String query = Token.string(new TextInput(io).content());
        this.execute(new Set(Prop.QUERYPATH, (Object)io.path()), false);
        this.execute(new XQuery(query), this.verbose);
    }

    private void script(IO io) throws IOException {
        byte[] cmd = new TextInput(io).content();
        if (Token.startsWith(cmd, 60)) {
            this.execute(Token.string(cmd));
        } else {
            String line;
            NewlineInput nli = new NewlineInput(new IOContent(cmd));
            while ((line = nli.readLine()) != null) {
                String l = line.trim();
                if (l.isEmpty() || l.startsWith("#")) continue;
                this.execute(l);
            }
        }
    }

    boolean sa() {
        return true;
    }

    @Override
    protected Session session() throws IOException {
        if (this.session == null) {
            this.session = new LocalSession(this.context, this.out);
        }
        this.session.setOutputStream(this.out);
        return this.session;
    }

    @Override
    protected final void parseArguments(String ... args) throws IOException {
        this.ops = new IntList();
        this.vals = new StringList();
        Args arg = new Args(args, this, this.sa() ? Text.LOCALINFO : Text.CLIENTINFO, Util.info(Text.CONSOLE, this.sa() ? "Standalone" : "Client"));
        while (arg.more()) {
            int c;
            String v = null;
            if (arg.dash()) {
                c = arg.next();
                if (c == 98 || c == 99 || c == 67 || c == 105 || c == 111 || c == 113 || c == 114 || c == 115) {
                    v = arg.string();
                } else if (c == 100 || c == 68 && this.sa() || c == 76 || c == 117 || c == 118 || c == 86 || c == 119 || c == 87 || c == 120 || c == 88 || c == 122) {
                    v = "";
                } else if (!this.sa()) {
                    if (c == 110) {
                        this.context.mprop.set(MainProp.HOST, arg.string());
                    } else if (c == 112) {
                        this.context.mprop.set(MainProp.PORT, arg.number());
                    } else if (c == 80) {
                        this.pass = arg.string();
                    } else if (c == 85) {
                        this.user = arg.string();
                    } else {
                        arg.usage();
                    }
                } else {
                    arg.usage();
                }
            } else {
                c = 113;
                v = arg.string();
            }
            if (v == null) continue;
            this.ops.add(c);
            this.vals.add(v);
        }
    }
}

